/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postgres;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.postgres.util.PostgresqlConfFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgresDiscoveryComponent
implements ResourceDiscoveryComponent {
    private static final Log log = LogFactory.getLog(PostgresDiscoveryComponent.class);
    public static final String PGDATA_DIR_CONFIGURATION_PROPERTY = "pgdataDir";
    public static final String CONFIG_FILE_CONFIGURATION_PROPERTY = "configFile";
    public static final String DRIVER_CONFIGURATION_PROPERTY = "driverClass";
    public static final String HOST_CONFIGURATION_PROPERTY = "host";
    public static final String PORT_CONFIGURATION_PROPERTY = "port";
    public static final String DB_CONFIGURATION_PROPERTY = "db";
    public static final String PRINCIPAL_CONFIGURATION_PROPERTY = "principal";
    public static final String CREDENTIALS_CONFIGURATION_PROPERTY = "credentials";
    private static final String PGDATA_ENV_VAR = "PGDATA";
    private static final String DEFAULT_RESOURCE_DESCRIPTION = "Postgres relational database server";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) {
        LinkedHashSet<DiscoveredResourceDetails> servers = new LinkedHashSet<DiscoveredResourceDetails>();
        List autoDiscoveryResults = context.getAutoDiscoveredProcesses();
        for (ProcessScanResult result : autoDiscoveryResults) {
            String port;
            log.info((Object)("Discovered a postgres process: " + result));
            ProcessInfo procInfo = result.getProcessInfo();
            String pgDataPath = PostgresDiscoveryComponent.getDataDirPath(procInfo);
            if (pgDataPath == null) {
                log.error((Object)("Unable to obtain data directory for postgres process with pid " + procInfo.getPid() + " (tried checking both -D command line argument, as well as " + PGDATA_ENV_VAR + " environment variable)."));
                continue;
            }
            File pgData = new File(pgDataPath);
            String configFilePath = PostgresDiscoveryComponent.getConfigFilePath(procInfo);
            PostgresqlConfFile confFile = null;
            if (!pgData.exists()) {
                log.warn((Object)("PostgreSQL data directory (" + pgData + ") does not exist or cannot be read."));
            } else {
                File postgresConfFile;
                log.debug((Object)("PostgreSQL data directory: " + pgData));
                File file = postgresConfFile = configFilePath != null ? new File(configFilePath) : new File(pgData, "postgresql.conf");
                if (!postgresConfFile.exists()) {
                    log.warn((Object)("PostgreSQL configuration file (" + postgresConfFile + ") does not exist."));
                }
                log.debug((Object)("PostgreSQL configuration file: " + postgresConfFile));
                try {
                    confFile = new PostgresqlConfFile(postgresConfFile);
                }
                catch (IOException e) {
                    log.warn((Object)"Could not load PostgreSQL configuration file.", (Throwable)e);
                }
            }
            Configuration pluginConfig = context.getDefaultPluginConfiguration();
            pluginConfig.put((Property)new PropertySimple(PGDATA_DIR_CONFIGURATION_PROPERTY, (Object)pgData));
            pluginConfig.put((Property)new PropertySimple(CONFIG_FILE_CONFIGURATION_PROPERTY, (Object)configFilePath));
            if (confFile != null && (port = confFile.getPort()) != null) {
                pluginConfig.put((Property)new PropertySimple(PORT_CONFIGURATION_PROPERTY, (Object)port));
            }
            DiscoveredResourceDetails resourceDetails = PostgresDiscoveryComponent.createResourceDetails(context, pluginConfig, procInfo);
            servers.add(resourceDetails);
        }
        List contextPluginConfigurations = context.getPluginConfigurations();
        for (Configuration pluginConfiguration : contextPluginConfigurations) {
            ProcessInfo processInfo = null;
            DiscoveredResourceDetails resourceDetails = PostgresDiscoveryComponent.createResourceDetails(context, pluginConfiguration, processInfo);
            servers.add(resourceDetails);
        }
        return servers;
    }

    protected static DiscoveredResourceDetails createResourceDetails(ResourceDiscoveryContext discoveryContext, Configuration pluginConfiguration, @Nullable ProcessInfo processInfo) {
        String key = PostgresDiscoveryComponent.buildUrl(pluginConfiguration);
        String db = pluginConfiguration.getSimple(DB_CONFIGURATION_PROPERTY).getStringValue();
        String name = "Postgres [" + db + "]";
        String version = PostgresDiscoveryComponent.getVersion(pluginConfiguration);
        return new DiscoveredResourceDetails(discoveryContext.getResourceType(), key, name, version, DEFAULT_RESOURCE_DESCRIPTION, pluginConfiguration, processInfo);
    }

    protected static String buildUrl(Configuration config) {
        String host = config.getSimple(HOST_CONFIGURATION_PROPERTY).getStringValue();
        String port = config.getSimple(PORT_CONFIGURATION_PROPERTY).getStringValue();
        String db = config.getSimple(DB_CONFIGURATION_PROPERTY).getStringValue();
        String url = "jdbc:postgresql://" + host + ":" + port + "/" + db;
        return url;
    }

    protected static String getVersion(Configuration config) {
        String version = null;
        try {
            Connection conn = PostgresDiscoveryComponent.buildConnection(config);
            version = conn.getMetaData().getDatabaseProductVersion();
        }
        catch (SQLException e) {
            log.info((Object)"Exception detecting postgres instance", (Throwable)e);
        }
        return version;
    }

    public static Connection buildConnection(Configuration configuration) throws SQLException {
        String driverClass = configuration.getSimple(DRIVER_CONFIGURATION_PROPERTY).getStringValue();
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidPluginConfigurationException("Specified JDBC driver class (" + driverClass + ") not found.");
        }
        String url = PostgresDiscoveryComponent.buildUrl(configuration);
        String principal = configuration.getSimple(PRINCIPAL_CONFIGURATION_PROPERTY).getStringValue();
        String credentials = configuration.getSimple(CREDENTIALS_CONFIGURATION_PROPERTY).getStringValue();
        return DriverManager.getConnection(url, principal, credentials);
    }

    @Nullable
    protected static String getDataDirPath(@NotNull ProcessInfo procInfo) {
        String dataDirPath = null;
        String[] cmdLine = procInfo.getCommandLine();
        for (int i = 0; i < cmdLine.length; ++i) {
            if (!cmdLine[i].equals("-D")) continue;
            if (i != cmdLine.length - 1) {
                dataDirPath = cmdLine[i + 1];
                break;
            }
            log.error((Object)("-D option was last option on postgres command line: " + Arrays.asList(cmdLine)));
        }
        if (dataDirPath == null) {
            dataDirPath = procInfo.getEnvironmentVariable(PGDATA_ENV_VAR);
        }
        if (dataDirPath == null) {
            // empty if block
        }
        return dataDirPath;
    }

    @Nullable
    private static String getConfigFilePath(@NotNull ProcessInfo procInfo) {
        String configFilePath = null;
        String[] cmdLine = procInfo.getCommandLine();
        for (int i = 0; i < cmdLine.length; ++i) {
            if (!cmdLine[i].equals("-c")) continue;
            if (i != cmdLine.length - 1) {
                String paramString = cmdLine[i + 1];
                int equalsIndex = paramString.indexOf(61);
                if (equalsIndex == -1) {
                    log.error((Object)("Invalid value '" + paramString + "' for -c option on postgres command line: " + Arrays.asList(cmdLine)));
                    continue;
                }
                String paramName = paramString.substring(0, equalsIndex);
                if (!paramName.equalsIgnoreCase("config_file")) continue;
                configFilePath = paramString.substring(equalsIndex + 1);
                break;
            }
            log.error((Object)("-c option was last option on postgres command line: " + Arrays.asList(cmdLine)));
        }
        return configFilePath;
    }
}

