/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postgres;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.database.DatabaseQueryUtility;
import org.rhq.plugins.postgres.PostgresDatabaseComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgresTableComponent
implements DatabaseComponent<PostgresDatabaseComponent>,
MeasurementFacet,
ConfigurationFacet,
DeleteResourceFacet {
    private static final List<String> PG_STAT_USER_TABLE_STATS = Arrays.asList("seq_scan", "seq_tup_read", "idx_scan", "idx_tup_fetch", "n_tup_ins", "n_tup_upd", "n_tup_del", "table_size", "total_size");
    public static final String PG_STAT_USER_TABLES_QUERY = "SELECT ts.*,  pg_relation_size(ts.relid) AS table_size, pg_total_relation_size(ts.relid) AS total_size, \n  ios.heap_blks_read, ios.heap_blks_hit, ios.idx_blks_read, ios.idx_blks_hit, \n  ios.toast_blks_read, ios.toast_blks_hit, ios.tidx_blks_read, ios.tidx_blks_hit \nFROM pg_stat_user_tables ts LEFT JOIN pg_statio_user_tables ios on ts.relid = ios.relid \nWHERE ts.relname = ?";
    public static final String PG_COUNT_ROWS = "SELECT COUNT(*) FROM ";
    public static final String PG_COUNT_ROWS_APPROX = "SELECT reltuples FROM pg_class WHERE relname = ? ";
    private ResourceContext<PostgresDatabaseComponent> resourceContext;

    public void start(ResourceContext<PostgresDatabaseComponent> context) {
        this.resourceContext = context;
    }

    public void stop() {
        this.resourceContext = null;
    }

    public String getTableName() {
        return this.resourceContext.getPluginConfiguration().getSimple("tableName").getStringValue();
    }

    public AvailabilityType getAvailability() {
        return ((PostgresDatabaseComponent)this.resourceContext.getParentResourceComponent()).getAvailability();
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        ((PostgresDatabaseComponent)this.resourceContext.getParentResourceComponent()).getConnection();
        Map results = DatabaseQueryUtility.getNumericQueryValues((DatabaseComponent)this, (String)PG_STAT_USER_TABLES_QUERY, (Object[])new Object[]{this.getTableName()});
        for (MeasurementScheduleRequest request : requests) {
            String metricName = request.getName();
            Double value = metricName.equals("rows") ? DatabaseQueryUtility.getSingleNumericQueryValue((DatabaseComponent)this, (String)(PG_COUNT_ROWS + this.getTableName()), (Object[])new Object[0]) : (metricName.equals("rows_approx") ? DatabaseQueryUtility.getSingleNumericQueryValue((DatabaseComponent)this, (String)PG_COUNT_ROWS_APPROX, (Object[])new Object[]{this.getTableName()}) : (Double)results.get(metricName));
            if (value == null) continue;
            MeasurementDataNumeric mdn = new MeasurementDataNumeric(request, value);
            report.addData(mdn);
        }
    }

    public void deleteResource() throws SQLException {
        DatabaseQueryUtility.executeUpdate((DatabaseComponent)this, (String)("DROP TABLE " + this.getTableName()), (Object[])new Object[0]);
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration config = new Configuration();
        config.put((Property)new PropertySimple("tableName", (Object)this.resourceContext.getPluginConfiguration().getSimple("tableName").getStringValue()));
        Connection connection = ((PostgresDatabaseComponent)this.resourceContext.getParentResourceComponent()).getConnection();
        DatabaseMetaData dmd = connection.getMetaData();
        ResultSet rs = dmd.getColumns("", "", this.getTableName(), "");
        PropertyList columnList = new PropertyList("columns");
        while (rs.next()) {
            PropertyMap col = new PropertyMap("columnDefinition");
            col.put((Property)new PropertySimple("columnName", (Object)rs.getString("COLUMN_NAME")));
            col.put((Property)new PropertySimple("columnType", (Object)rs.getString("TYPE_NAME")));
            col.put((Property)new PropertySimple("columnLength", (Object)rs.getInt("COLUMN_SIZE")));
            col.put((Property)new PropertySimple("columnPrecision", (Object)rs.getInt("DECIMAL_DIGITS")));
            col.put((Property)new PropertySimple("columnDefault", (Object)rs.getString("COLUMN_DEF")));
            col.put((Property)new PropertySimple("columnNullable", (Object)rs.getBoolean("IS_NULLABLE")));
            columnList.add((Property)col);
        }
        config.put((Property)columnList);
        return config;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        try {
            Configuration updatedConfiguration = report.getConfiguration();
            PropertyList updatedColumns = updatedConfiguration.getList("columns");
            Connection connection = ((PostgresDatabaseComponent)this.resourceContext.getParentResourceComponent()).getConnection();
            DatabaseMetaData dmd = connection.getMetaData();
            ResultSet rs = dmd.getColumns("", "", this.getTableName(), "");
            HashMap<String, ColumnDefinition> existingDefs = new HashMap<String, ColumnDefinition>();
            while (rs.next()) {
                ColumnDefinition def = new ColumnDefinition(rs);
                existingDefs.put(def.columnName, def);
            }
            for (Property newColumnDefinition : updatedColumns.getList()) {
                boolean columnDefaultChanged;
                boolean columnPrecisionChanged;
                PropertyMap colDef = (PropertyMap)newColumnDefinition;
                ColumnDefinition existingDef = (ColumnDefinition)existingDefs.get(colDef.getSimple("columnName").getStringValue());
                ColumnDefinition newDef = new ColumnDefinition(colDef);
                if (existingDef == null) {
                    String sql = "ALTER TABLE " + this.getTableName() + " ADD COLUMN " + newDef.getColumnSql();
                    if (DatabaseQueryUtility.executeUpdate((DatabaseComponent)this, (String)sql, (Object[])new Object[0]) == 0) continue;
                    throw new RuntimeException("Couldn't add column using SQL: " + sql);
                }
                existingDefs.remove(existingDef.columnName);
                boolean columnLengthChanged = existingDef.columnLength != null && !existingDef.columnLength.equals(newDef.columnLength) || existingDef.columnLength == null && existingDef.columnLength != null;
                boolean bl = columnPrecisionChanged = existingDef.columnPrecision != null && !existingDef.columnPrecision.equals(newDef.columnPrecision) || existingDef.columnPrecision == null && existingDef.columnPrecision != null;
                if (!existingDef.columnType.equals(newDef.columnType) || columnLengthChanged || columnPrecisionChanged) {
                    String sql = "ALTER TABLE " + this.getTableName() + " ALTER COLUMN " + newDef.columnName + " TYPE " + newDef.columnType;
                    if (newDef.columnLength != null) {
                        sql = sql + " ( " + newDef.columnLength;
                        if (newDef.columnPrecision != null && !newDef.columnType.startsWith("varchar")) {
                            sql = sql + ", " + newDef.columnPrecision;
                        }
                        sql = sql + " ) ";
                    }
                    if (DatabaseQueryUtility.executeUpdate((DatabaseComponent)this, (String)sql, (Object[])new Object[0]) != 1) {
                        throw new RuntimeException("Couldn't alter column type using SQL: " + sql);
                    }
                }
                if (!(columnDefaultChanged = existingDef.columnDefault != null && !existingDef.columnDefault.equals(newDef.columnDefault) || existingDef.columnDefault == null && newDef.columnDefault != null)) continue;
                String sql = "ALTER TABLE " + this.getTableName() + " ALTER COLUMN " + newDef.columnName;
                sql = newDef.columnDefault == null ? sql + " DROP DEFAULT" : sql + " SET DEFAULT " + newDef.columnDefault;
                if (DatabaseQueryUtility.executeUpdate((DatabaseComponent)this, (String)sql, (Object[])new Object[0]) == 1) continue;
                throw new RuntimeException("Couldn't update column default using SQL: " + sql);
            }
            for (ColumnDefinition def : existingDefs.values()) {
                DatabaseQueryUtility.executeUpdate((DatabaseComponent)this, (String)("ALTER TABLE " + this.getTableName() + " DROP COLUMN " + def.columnName), (Object[])new Object[0]);
            }
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (SQLException e) {
            report.setErrorMessageFromThrowable((Throwable)e);
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
        }
    }

    public Connection getConnection() {
        return ((PostgresDatabaseComponent)this.resourceContext.getParentResourceComponent()).getConnection();
    }

    public void removeConnection() {
        ((PostgresDatabaseComponent)this.resourceContext.getParentResourceComponent()).removeConnection();
    }

    private static class ColumnDefinition {
        String columnName;
        String columnType;
        Integer columnLength;
        Integer columnPrecision;
        String columnDefault;
        boolean columnNullable;

        public ColumnDefinition(ResultSet rs) throws SQLException {
            this.columnName = rs.getString("COLUMN_NAME");
            this.columnType = rs.getString("TYPE_NAME");
            this.columnLength = rs.getInt("COLUMN_SIZE");
            this.columnPrecision = rs.getInt("DECIMAL_DIGITS");
            this.columnDefault = rs.getString("COLUMN_DEF");
            this.columnNullable = rs.getBoolean("IS_NULLABLE");
        }

        public ColumnDefinition(PropertyMap column) {
            this.columnName = column.getSimple("columnName").getStringValue();
            this.columnType = column.getSimple("columnType").getStringValue();
            this.columnLength = column.getSimple("columnLength") == null ? null : column.getSimple("columnLength").getIntegerValue();
            this.columnPrecision = column.getSimple("columnPrecision") == null ? null : column.getSimple("columnPrecision").getIntegerValue();
            this.columnDefault = column.getSimple("columnDefault") == null ? null : column.getSimple("columnDefault").getStringValue();
            this.columnNullable = column.getSimple("columnNotNull") == null ? false : column.getSimple("columnNotNull").getBooleanValue();
        }

        public String getColumnSql() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.columnName).append(" ").append(this.columnType);
            if (this.columnLength != null) {
                buf.append("(" + this.columnLength + ")");
            }
            if (this.columnPrecision != null) {
                buf.append("(" + this.columnPrecision + ")");
            }
            if (this.columnDefault != null) {
                buf.append(" DEFAULT " + this.columnDefault);
            }
            if (this.columnNullable) {
                buf.append(" NOT NULL");
            }
            return buf.toString();
        }
    }
}

