/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postgres;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.plugins.postgres.PostgresServerComponent;

public class PostgresDatabaseDiscoveryComponent
implements ResourceDiscoveryComponent<PostgresServerComponent> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<PostgresServerComponent> context) throws Exception {
        HashSet<DiscoveredResourceDetails> databases = new HashSet<DiscoveredResourceDetails>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = ((PostgresServerComponent)context.getParentResourceComponent()).getConnection().createStatement();
            resultSet = statement.executeQuery("SELECT *, pg_database_size(datname) FROM pg_database where datistemplate = false");
            while (resultSet.next()) {
                String databaseName = resultSet.getString("datname");
                DiscoveredResourceDetails database = new DiscoveredResourceDetails(context.getResourceType(), databaseName, databaseName, null, "The " + databaseName + " Postgres Database Instance", null, null);
                database.getPluginConfiguration().put((Property)new PropertySimple("databaseName", (Object)databaseName));
                databases.add(database);
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose(statement);
            throw throwable;
        }
        JDBCUtil.safeClose((Statement)statement);
        return databases;
    }
}

