/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postgres;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.postgres.PostgresDiscoveryComponent;
import org.rhq.plugins.postgres.PostgresServerComponent;

public class PostgresDatabaseComponent
implements DatabaseComponent<PostgresServerComponent>,
MeasurementFacet,
CreateChildResourceFacet,
OperationFacet {
    private Log log = LogFactory.getLog(PostgresDatabaseComponent.class);
    private ResourceContext<PostgresServerComponent> resourceContext;
    private Connection databaseConnection;
    private String databaseName;

    public Connection getConnection() {
        this.databaseName = this.resourceContext.getPluginConfiguration().getSimple("databaseName").getStringValue();
        if (this.databaseName.equals(((PostgresServerComponent)this.resourceContext.getParentResourceComponent()).getResourceContext().getPluginConfiguration().getSimple("db").getStringValue())) {
            return ((PostgresServerComponent)this.resourceContext.getParentResourceComponent()).getConnection();
        }
        if (this.databaseConnection == null) {
            Configuration config = ((PostgresServerComponent)this.resourceContext.getParentResourceComponent()).getResourceContext().getPluginConfiguration();
            config = config.deepCopy();
            config.put((Property)new PropertySimple("db", (Object)this.databaseName));
            this.log.debug((Object)("Getting db specific connection to postgres for [" + this.databaseName + "] database"));
            this.databaseConnection = PostgresDiscoveryComponent.buildConnection(config, true);
        }
        return this.databaseConnection;
    }

    public void removeConnection() {
        try {
            if (this.databaseConnection != null && !this.databaseConnection.isClosed()) {
                this.databaseConnection.close();
            }
        }
        catch (SQLException se) {
            this.log.debug((Object)"Closing and removing postgres connection");
        }
        this.databaseConnection = null;
    }

    public void start(ResourceContext<PostgresServerComponent> context) {
        this.resourceContext = context;
    }

    public void stop() {
        this.resourceContext = null;
    }

    public AvailabilityType getAvailability() {
        return ((PostgresServerComponent)this.resourceContext.getParentResourceComponent()).getAvailability();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) {
        Statement statement = null;
        try {
            statement = ((PostgresServerComponent)this.resourceContext.getParentResourceComponent()).getConnection().prepareStatement("SELECT *, pg_database_size(datname) AS size FROM pg_stat_database where datname = ?");
            statement.setString(1, this.resourceContext.getPluginConfiguration().getSimple("databaseName").getStringValue());
            ResultSet results = statement.executeQuery();
            if (!results.next()) {
                throw new RuntimeException("Couldn't get the data");
            }
            for (MeasurementScheduleRequest request : metrics) {
                double val = results.getDouble(request.getName());
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(val)));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreateResourceReport createResource(CreateResourceReport report) {
        StringBuilder buf = new StringBuilder();
        Configuration configuration = report.getResourceConfiguration();
        String tableName = configuration.getSimple("tableName").getStringValue();
        String owner = configuration.getSimpleValue("owner", null);
        String tablespace = configuration.getSimpleValue("tablespace", null);
        PropertyList columnList = configuration.getList("columns");
        buf.append("CREATE TABLE ").append(tableName).append("(\n");
        boolean first = true;
        for (Property c : columnList.getList()) {
            if (!first) {
                buf.append(",\n");
            }
            PropertyMap column = (PropertyMap)c;
            String colName = column.getSimple("columnName").getStringValue();
            String colType = column.getSimple("columnType").getStringValue();
            PropertySimple length = column.getSimple("columnLength");
            PropertySimple precision = column.getSimple("columnPrecision");
            PropertySimple colDefault = column.getSimple("columnDefault");
            PropertySimple colNullable = column.getSimple("columnNullable");
            if (colName == null || colName.equals("")) continue;
            buf.append(colName).append(" ").append(colType);
            if (length != null && length.getIntegerValue() != null) {
                buf.append("(" + length.getIntegerValue() + ")");
            }
            if (precision != null && precision.getIntegerValue() != null) {
                buf.append("(" + precision.getIntegerValue() + ")");
            }
            if (colDefault != null && colDefault.getStringValue() != null) {
                buf.append(" DEFAULT " + colDefault.getStringValue());
            }
            if (colNullable != null && colNullable.getBooleanValue() != null && colNullable.getBooleanValue().equals(Boolean.FALSE)) {
                buf.append(" NOT NULL");
            }
            first = false;
        }
        buf.append("\n)");
        this.log.info((Object)("Creating table with: " + buf.toString()));
        PropertyList constraintList = configuration.getList("constraints");
        if (constraintList != null) {
            for (Property c : constraintList.getList()) {
                PropertyMap constraint = (PropertyMap)c;
            }
        }
        Statement statement = null;
        try {
            report.setResourceKey(tableName);
            statement = this.getConnection().createStatement();
            statement.executeUpdate(buf.toString());
            report.setStatus(CreateResourceStatus.SUCCESS);
            report.setResourceName(tableName);
        }
        catch (SQLException e) {
            try {
                report.setException((Throwable)e);
                report.setStatus(CreateResourceStatus.FAILURE);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(statement);
                throw throwable;
            }
            JDBCUtil.safeClose((Statement)statement);
        }
        JDBCUtil.safeClose((Statement)statement);
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if ("resetStatistics".equals(name)) {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.getConnection().createStatement();
                rs = stmt.executeQuery("select * from pg_stat_reset()");
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            return null;
        }
        if ("invokeSql".equals(name)) {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.getConnection().createStatement();
                String sql = parameters.getSimple("sql").getStringValue();
                OperationResult result = new OperationResult();
                if (parameters.getSimple("type").getStringValue().equals("update")) {
                    int updateCount = stmt.executeUpdate(sql);
                    result.getComplexResults().put((Property)new PropertySimple("result", (Object)("Query updated " + updateCount + " rows")));
                } else {
                    int i;
                    rs = stmt.executeQuery(parameters.getSimple("sql").getStringValue());
                    ResultSetMetaData md = rs.getMetaData();
                    StringBuilder buf = new StringBuilder();
                    int rowCount = 0;
                    buf.append("<table>");
                    buf.append("<th>");
                    for (i = 1; i <= md.getColumnCount(); ++i) {
                        buf.append("<td>");
                        buf.append(md.getColumnName(i) + " (" + md.getColumnTypeName(i) + ")");
                        buf.append("</td>");
                    }
                    buf.append("</th>");
                    while (rs.next()) {
                        ++rowCount;
                        buf.append("<tr>");
                        for (i = 1; i <= md.getColumnCount(); ++i) {
                            buf.append("<td>");
                            buf.append(rs.getString(i));
                            buf.append("</td>");
                        }
                        buf.append("</tr>");
                    }
                    buf.append("</table>");
                    result.getComplexResults().put((Property)new PropertySimple("result", (Object)("Query returned " + rowCount + " rows")));
                    result.getComplexResults().put((Property)new PropertySimple("contents", (Object)buf.toString()));
                }
                OperationResult operationResult = result;
                return operationResult;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        throw new UnsupportedOperationException("Operation [" + name + "] is not supported yet.");
    }
}

