/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postgres;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class InvokeSqlResult {
    private String[] columnHeaders;
    private int[] columnMaxLength;
    private List<String[]> rows;

    InvokeSqlResult(int columns) {
        this.columnHeaders = new String[columns];
        this.columnMaxLength = new int[columns];
        Arrays.fill(this.columnMaxLength, 0);
        this.rows = new ArrayList<String[]>(10);
    }

    int getColumnCount() {
        return this.columnHeaders.length;
    }

    String[] createRow() {
        return new String[this.columnHeaders.length];
    }

    void addRow(String[] row) {
        for (int i = 0; i < row.length; ++i) {
            int columnLength;
            String column = row[i];
            if (column == null || (columnLength = column.length()) <= this.columnMaxLength[i]) continue;
            this.columnMaxLength[i] = columnLength;
        }
        this.rows.add(row);
    }

    String getColumnHeader(int index) {
        return this.columnHeaders[index];
    }

    public void setColumnHeader(int index, String header) {
        this.columnHeaders[index] = header;
    }

    int getColumnMaxLength(int index) {
        return Math.max(this.columnHeaders[index].length(), this.columnMaxLength[index]);
    }

    List<String[]> getRows() {
        return this.rows;
    }
}

