/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postgres;

import java.util.Arrays;
import org.rhq.plugins.postgres.InvokeSqlResult;
import org.rhq.plugins.postgres.InvokeSqlResultExporter;

class InvokeSqlResultFormattedTextExporter
implements InvokeSqlResultExporter {
    private static final char SEPARATOR_CHAR = '+';

    InvokeSqlResultFormattedTextExporter() {
    }

    @Override
    public String export(InvokeSqlResult invokeSqlResult) {
        StringBuilder builder = new StringBuilder();
        this.appendSeparatorLine(builder, invokeSqlResult);
        builder.append('+');
        for (int i = 0; i < invokeSqlResult.getColumnCount(); ++i) {
            String columnHeader = invokeSqlResult.getColumnHeader(i);
            int totalSpace = 2 + invokeSqlResult.getColumnMaxLength(i) - columnHeader.length();
            int leftSpace = totalSpace / 2;
            int rightSpace = leftSpace + totalSpace % 2;
            this.appendSpace(builder, leftSpace);
            builder.append(columnHeader);
            this.appendSpace(builder, rightSpace);
            builder.append('+');
        }
        builder.append(String.format("%n", new Object[0]));
        this.appendSeparatorLine(builder, invokeSqlResult);
        for (String[] row : invokeSqlResult.getRows()) {
            builder.append('+');
            for (int i = 0; i < row.length; ++i) {
                builder.append(String.format(" %" + invokeSqlResult.getColumnMaxLength(i) + "s ", row[i]));
                builder.append('+');
            }
            builder.append(String.format("%n", new Object[0]));
        }
        this.appendSeparatorLine(builder, invokeSqlResult);
        return builder.toString();
    }

    private void appendSpace(StringBuilder builder, int length) {
        char[] chars = new char[length];
        Arrays.fill(chars, ' ');
        builder.append(chars);
    }

    private void appendSeparatorLine(StringBuilder builder, InvokeSqlResult invokeSqlResult) {
        builder.append('+');
        for (int i = 0; i < invokeSqlResult.getColumnCount(); ++i) {
            int columnSize = invokeSqlResult.getColumnMaxLength(i);
            char[] chars = new char[columnSize + 2 + 1];
            Arrays.fill(chars, '+');
            builder.append(chars);
        }
        builder.append(String.format("%n", new Object[0]));
    }
}

