/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.database.ConnectionPoolingSupport;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.database.DatabasePluginUtil;
import org.rhq.plugins.database.PooledConnectionProvider;
import org.rhq.plugins.postgres.InvokeSqlResult;
import org.rhq.plugins.postgres.InvokeSqlResultExporter;
import org.rhq.plugins.postgres.InvokeSqlResultFormattedTextExporter;
import org.rhq.plugins.postgres.InvokeSqlResultHtmlExporter;
import org.rhq.plugins.postgres.PostgresDiscoveryComponent;
import org.rhq.plugins.postgres.PostgresPooledConnectionProvider;
import org.rhq.plugins.postgres.PostgresServerComponent;

public class PostgresDatabaseComponent
implements DatabaseComponent<PostgresServerComponent<?>>,
ConnectionPoolingSupport,
MeasurementFacet,
CreateChildResourceFacet,
OperationFacet {
    private static final Log LOG = LogFactory.getLog(PostgresDatabaseComponent.class);
    private static final String QUERY_DATABASE_SIZE = "SELECT *, pg_database_size(datname) AS size FROM pg_stat_database where datname = ?";
    private ResourceContext<PostgresServerComponent<?>> resourceContext;
    private String databaseName;
    private PostgresServerComponent<?> postgresServerComponent;
    private boolean useOwnJdbcConnections;
    @Deprecated
    private Connection databaseConnection;
    private PostgresPooledConnectionProvider pooledConnectionProvider;

    public void start(ResourceContext<PostgresServerComponent<?>> context) throws Exception {
        this.resourceContext = context;
        this.databaseName = this.resourceContext.getPluginConfiguration().getSimple("databaseName").getStringValue();
        this.postgresServerComponent = (PostgresServerComponent)this.resourceContext.getParentResourceComponent();
        boolean bl = this.useOwnJdbcConnections = !this.databaseName.equals(this.postgresServerComponent.getResourceContext().getPluginConfiguration().getSimple("db").getStringValue());
        if (this.useOwnJdbcConnections) {
            this.buildDatabaseConnectionIfNeeded();
            this.pooledConnectionProvider = new PostgresPooledConnectionProvider(this.createDatabaseSpecificConfig());
        }
    }

    public void stop() {
        this.resourceContext = null;
        this.databaseName = null;
        this.postgresServerComponent = null;
        if (this.useOwnJdbcConnections) {
            DatabasePluginUtil.safeClose((Connection)this.databaseConnection);
            this.databaseConnection = null;
            this.pooledConnectionProvider.close();
            this.pooledConnectionProvider = null;
        }
    }

    public boolean supportsConnectionPooling() {
        return true;
    }

    public PooledConnectionProvider getPooledConnectionProvider() {
        return this.useOwnJdbcConnections ? this.pooledConnectionProvider : this.postgresServerComponent.getPooledConnectionProvider();
    }

    public Connection getConnection() {
        if (this.useOwnJdbcConnections) {
            return this.postgresServerComponent.getConnection();
        }
        this.buildDatabaseConnectionIfNeeded();
        return this.databaseConnection;
    }

    public void removeConnection() {
        try {
            if (this.databaseConnection != null && !this.databaseConnection.isClosed()) {
                this.databaseConnection.close();
            }
        }
        catch (SQLException e) {
            LOG.debug((Object)"Could not remove connection", (Throwable)e);
        }
        this.databaseConnection = null;
    }

    private void buildDatabaseConnectionIfNeeded() {
        block3: {
            try {
                if (this.databaseConnection == null || this.databaseConnection.isClosed()) {
                    this.databaseConnection = PostgresDiscoveryComponent.buildConnection(this.createDatabaseSpecificConfig(), true);
                }
            }
            catch (SQLException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)"Could not build shared connection", (Throwable)e);
            }
        }
    }

    private Configuration createDatabaseSpecificConfig() {
        Configuration config = this.postgresServerComponent.getResourceContext().getPluginConfiguration();
        config = config.deepCopy();
        config.put((Property)new PropertySimple("db", (Object)this.databaseName));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting db specific connection to postgres for [" + this.databaseName + "] database"));
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailabilityType getAvailability() {
        if (this.useOwnJdbcConnections) {
            Connection jdbcConnection = null;
            try {
                jdbcConnection = this.getPooledConnectionProvider().getPooledConnection();
                AvailabilityType availabilityType = jdbcConnection.isValid(1) ? AvailabilityType.UP : AvailabilityType.DOWN;
                return availabilityType;
            }
            catch (SQLException e) {
                AvailabilityType availabilityType = AvailabilityType.DOWN;
                return availabilityType;
            }
            finally {
                DatabasePluginUtil.safeClose((Connection)jdbcConnection);
            }
        }
        return this.postgresServerComponent.getAvailability();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) {
        Connection jdbcConnection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            jdbcConnection = this.getPooledConnectionProvider().getPooledConnection();
            statement = jdbcConnection.prepareStatement(QUERY_DATABASE_SIZE);
            statement.setString(1, this.resourceContext.getPluginConfiguration().getSimple("databaseName").getStringValue());
            resultSet = statement.executeQuery();
            if (!resultSet.next() && LOG.isDebugEnabled()) {
                LOG.debug((Object)"Result set is empty: SELECT *, pg_database_size(datname) AS size FROM pg_stat_database where datname = ?");
            }
            for (MeasurementScheduleRequest request : metrics) {
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(resultSet.getDouble(request.getName()))));
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DatabasePluginUtil.safeClose((Connection)jdbcConnection, statement, resultSet);
                throw throwable;
            }
        }
        DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreateResourceReport createResource(CreateResourceReport report) {
        StringBuilder buf = new StringBuilder();
        Configuration configuration = report.getResourceConfiguration();
        String tableName = configuration.getSimple("tableName").getStringValue();
        String owner = configuration.getSimpleValue("owner", null);
        String tablespace = configuration.getSimpleValue("tablespace", null);
        PropertyList columnList = configuration.getList("columns");
        buf.append("CREATE TABLE ").append(tableName).append("(\n");
        boolean first = true;
        for (Property c : columnList.getList()) {
            if (!first) {
                buf.append(",\n");
            }
            PropertyMap column = (PropertyMap)c;
            String colName = column.getSimple("columnName").getStringValue();
            String colType = column.getSimple("columnType").getStringValue();
            PropertySimple length = column.getSimple("columnLength");
            PropertySimple precision = column.getSimple("columnPrecision");
            PropertySimple colDefault = column.getSimple("columnDefault");
            PropertySimple colNullable = column.getSimple("columnNullable");
            if (colName == null || colName.equals("")) continue;
            buf.append(colName).append(" ").append(colType);
            if (!this.isArrayColumnType(colType)) {
                if (length != null && length.getIntegerValue() != null) {
                    buf.append("(").append(length.getIntegerValue()).append(")");
                }
                if (precision != null && precision.getIntegerValue() != null) {
                    buf.append("(").append(precision.getIntegerValue()).append(")");
                }
            }
            if (colDefault != null && colDefault.getStringValue() != null) {
                buf.append(" DEFAULT ").append(colDefault.getStringValue());
            }
            if (colNullable != null && colNullable.getBooleanValue() != null && colNullable.getBooleanValue().equals(Boolean.FALSE)) {
                buf.append(" NOT NULL");
            }
            first = false;
        }
        buf.append("\n)");
        String createTableSql = buf.toString();
        LOG.info((Object)("Creating table with: " + createTableSql));
        PropertyList constraintList = configuration.getList("constraints");
        if (constraintList != null) {
            for (Property c : constraintList.getList()) {
                PropertyMap constraint = (PropertyMap)c;
            }
        }
        Connection jdbcConnection = null;
        Statement statement = null;
        try {
            jdbcConnection = this.getPooledConnectionProvider().getPooledConnection();
            statement = jdbcConnection.createStatement();
            statement.executeUpdate(createTableSql);
            report.setStatus(CreateResourceStatus.SUCCESS);
            report.setResourceKey(tableName);
            report.setResourceName(tableName);
        }
        catch (SQLException e) {
            try {
                report.setException((Throwable)e);
                report.setStatus(CreateResourceStatus.FAILURE);
            }
            catch (Throwable throwable) {
                DatabasePluginUtil.safeClose((Connection)jdbcConnection, statement, null);
                throw throwable;
            }
            DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, null);
        }
        DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, null);
        return report;
    }

    private boolean isArrayColumnType(String columnType) {
        return columnType != null && columnType.trim().endsWith("[]");
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if ("resetStatistics".equals(name)) {
            return this.resetStatistics();
        }
        if ("invokeSql".equals(name)) {
            return this.invokeSql(parameters);
        }
        throw new UnsupportedOperationException("Operation [" + name + "] is not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult resetStatistics() {
        OperationResult operationResult;
        Connection jdbcConnection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            jdbcConnection = this.getPooledConnectionProvider().getPooledConnection();
            statement = jdbcConnection.createStatement();
            resultSet = statement.executeQuery("select * from pg_stat_reset()");
            operationResult = null;
        }
        catch (SQLException e) {
            OperationResult operationResult2;
            try {
                OperationResult result = new OperationResult("Failed to reset statistics");
                result.setErrorMessage(e.getMessage());
                operationResult2 = result;
            }
            catch (Throwable throwable) {
                DatabasePluginUtil.safeClose((Connection)jdbcConnection, statement, resultSet);
                throw throwable;
            }
            DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
            return operationResult2;
        }
        DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
        return operationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult invokeSql(Configuration parameters) throws SQLException {
        OperationResult operationResult;
        OperationResult result;
        String sql;
        ResultSet resultSet;
        Statement statement;
        Connection jdbcConnection;
        block8: {
            jdbcConnection = null;
            statement = null;
            resultSet = null;
            jdbcConnection = this.getPooledConnectionProvider().getPooledConnection();
            statement = jdbcConnection.createStatement();
            sql = parameters.getSimple("sql").getStringValue();
            result = new OperationResult();
            if (!"update".equals(parameters.getSimpleValue("type"))) break block8;
            int updateCount = statement.executeUpdate(sql);
            result.getComplexResults().put((Property)new PropertySimple("result", (Object)("Query updated " + updateCount + " rows")));
            OperationResult operationResult2 = result;
            DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
            return operationResult2;
        }
        try {
            resultSet = statement.executeQuery(sql);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            InvokeSqlResult invokeSqlResult = new InvokeSqlResult(resultSetMetaData.getColumnCount());
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                invokeSqlResult.setColumnHeader(i - 1, resultSetMetaData.getColumnName(i) + " (" + resultSetMetaData.getColumnTypeName(i) + ")");
            }
            while (resultSet.next()) {
                String[] row = invokeSqlResult.createRow();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    row[i - 1] = resultSet.getString(i);
                }
                invokeSqlResult.addRow(row);
            }
            InvokeSqlResultExporter exporter = "formattedText".equals(parameters.getSimpleValue("outputFormat")) ? new InvokeSqlResultFormattedTextExporter() : new InvokeSqlResultHtmlExporter();
            result.getComplexResults().put((Property)new PropertySimple("result", (Object)("Query returned " + invokeSqlResult.getRows().size() + " row(s)")));
            result.getComplexResults().put((Property)new PropertySimple("contents", (Object)exporter.export(invokeSqlResult)));
            operationResult = result;
        }
        catch (SQLException e) {
            OperationResult operationResult3;
            try {
                result = new OperationResult("Failed to invoke SQL");
                result.setErrorMessage(e.getMessage());
                operationResult3 = result;
            }
            catch (Throwable throwable) {
                DatabasePluginUtil.safeClose((Connection)jdbcConnection, statement, resultSet);
                throw throwable;
            }
            DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, resultSet);
            return operationResult3;
        }
        DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
        return operationResult;
    }
}

