/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.util.LookupUtil;

@WebServlet(urlPatterns={"/download", "/version"}, loadOnStartup=1)
public class RemoteClientServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static String SYSPROP_CLIENT_DOWNLOADS_LIMIT = "rhq.server.client-downloads-limit";
    private static int DEFAULT_CLIENT_DOWNLOADS_LIMIT = 5;
    private static final int ERROR_CODE_CLIENT_UPDATE_DISABLED = 403;
    private static final int ERROR_CODE_TOO_MANY_DOWNLOADS = 503;
    private static int numActiveDownloads = 0;
    private Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.disableBrowserCache(resp);
        String servletPath = req.getServletPath();
        if (servletPath != null) {
            if (this.isServerAcceptingRequests()) {
                if (servletPath.endsWith("version")) {
                    this.getVersion(req, resp);
                } else if (servletPath.endsWith("download")) {
                    try {
                        ++numActiveDownloads;
                        this.getDownload(req, resp);
                    }
                    finally {
                        --numActiveDownloads;
                    }
                } else {
                    resp.sendError(400, "Invalid servlet path [" + servletPath + "] - please contact administrator");
                }
            } else {
                this.sendErrorServerNotAcceptingRequests(resp);
            }
        } else {
            resp.sendError(400, "Invalid servlet path - please contact administrator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDownload(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int limit = this.getDownloadLimit();
        if (limit <= 0) {
            this.sendErrorDownloadDisabled(resp);
            return;
        }
        if (limit < numActiveDownloads) {
            this.sendErrorTooManyDownloads(resp);
            return;
        }
        try {
            File zip = LookupUtil.getRemoteClientManager().getRemoteClientBinaryFile();
            if (!zip.exists()) {
                this.disableBrowserCache(resp);
                resp.sendError(404, "Remote Client binary does not exist: " + zip.getName());
                return;
            }
            resp.setContentType("application/octet-stream");
            resp.setHeader("Content-Disposition", "attachment; filename=" + zip.getName());
            resp.setContentLength((int)zip.length());
            resp.setDateHeader("Last-Modified", zip.lastModified());
            FileInputStream zipStream = new FileInputStream(zip);
            try {
                StreamUtil.copy((InputStream)zipStream, (OutputStream)resp.getOutputStream(), (boolean)false);
            }
            finally {
                zipStream.close();
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"Failed to stream remote client zip.", t);
            this.disableBrowserCache(resp);
            resp.sendError(500, "Failed to stream remote client zip");
        }
    }

    private void getVersion(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            File versionFile = LookupUtil.getRemoteClientManager().getRemoteClientVersionFile();
            resp.setContentType("text/plain");
            resp.setDateHeader("Last-Modified", versionFile.lastModified());
            FileInputStream stream = new FileInputStream(versionFile);
            byte[] versionData = StreamUtil.slurp((InputStream)stream);
            resp.getOutputStream().write(versionData);
        }
        catch (Throwable t) {
            this.log.error((Object)"Failed to stream version info.", t);
            this.disableBrowserCache(resp);
            resp.sendError(500, "Failed to stream version info");
        }
    }

    private int getDownloadLimit() {
        int limit;
        String limitStr = System.getProperty(SYSPROP_CLIENT_DOWNLOADS_LIMIT);
        try {
            limit = Integer.parseInt(limitStr);
        }
        catch (Exception e) {
            limit = DEFAULT_CLIENT_DOWNLOADS_LIMIT;
            this.log.warn((Object)("Remote Client downloads limit system property [" + SYSPROP_CLIENT_DOWNLOADS_LIMIT + "] is either not set or invalid [" + limitStr + "] - limit will be [" + limit + "]."));
        }
        return limit;
    }

    private void disableBrowserCache(HttpServletResponse resp) {
        resp.setHeader("Cache-Control", "no-cache, no-store");
        resp.setHeader("Expires", "-1");
        resp.setHeader("Pragma", "no-cache");
    }

    private void sendErrorServerNotAcceptingRequests(HttpServletResponse resp) throws IOException {
        this.disableBrowserCache(resp);
        resp.sendError(403, "Server Is Down For Maintenance");
    }

    private void sendErrorDownloadDisabled(HttpServletResponse resp) throws IOException {
        this.disableBrowserCache(resp);
        resp.sendError(403, "Client Download Has Been Disabled");
    }

    private void sendErrorTooManyDownloads(HttpServletResponse resp) throws IOException {
        this.disableBrowserCache(resp);
        resp.setHeader("Retry-After", "30");
        resp.sendError(503, "Maximum limit exceeded - download client later");
    }

    private boolean isServerAcceptingRequests() {
        try {
            Server.OperationMode mode = LookupUtil.getServerManager().getServer().getOperationMode();
            return mode == Server.OperationMode.NORMAL;
        }
        catch (Exception e) {
            return false;
        }
    }
}

