/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client.commands;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.util.Properties;
import java.util.jar.Attributes;
import org.rhq.enterprise.client.ClientMain;
import org.rhq.enterprise.client.Version;
import org.rhq.enterprise.client.commands.ClientCommand;
import org.rhq.enterprise.client.script.CommandLineParseException;

public class VersionCommand
implements ClientCommand {
    @Override
    public String getPromptCommandString() {
        return "version";
    }

    @Override
    public boolean execute(ClientMain client, String[] args) {
        VersionArgs versionArgs = this.parseArgs(args);
        if (versionArgs.verbose) {
            client.getPrintWriter().println(Version.getVersionPropertiesAsString());
        } else {
            Properties props = Version.getVersionProperties();
            String version = props.getProperty(Attributes.Name.IMPLEMENTATION_VERSION.toString());
            client.getPrintWriter().println(version);
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return this.getPromptCommandString() + " [-v | --verbose]";
    }

    @Override
    public String getHelp() {
        return "Show CLI version information";
    }

    @Override
    public String getDetailedHelp() {
        return this.getHelp() + ". If no arguments are specified, the CLI's version is printed. If the verbose option is " + "specified, the values of the main attributes from the CLI jar's MANIFEST.MF are printed.";
    }

    private VersionArgs parseArgs(String[] args) {
        String shortOpts = "-:v";
        LongOpt[] longOpts = new LongOpt[]{new LongOpt("verbose", 2, null, 118)};
        Getopt getopt = new Getopt(this.getPromptCommandString(), args, shortOpts, longOpts);
        getopt.setOpterr(false);
        VersionArgs versionArgs = new VersionArgs();
        int code = getopt.getopt();
        while (code != -1) {
            switch (code) {
                case 58: {
                    throw new CommandLineParseException("Invalid option");
                }
                case 118: {
                    versionArgs.verbose = true;
                }
            }
            code = getopt.getopt();
        }
        return versionArgs;
    }

    private static class VersionArgs {
        boolean verbose;

        private VersionArgs() {
        }
    }
}

