/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client.utility;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public class ReflectionUtility {
    public static String getSimpleTypeString(Type type) {
        return ReflectionUtility.getTypeString(type, false);
    }

    public static String getTypeString(Type type, boolean fullNames) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type[] typeArguments = pType.getActualTypeArguments();
            String typeArgString = "";
            for (Type typeArgument : typeArguments) {
                if (typeArgString.length() > 0) {
                    typeArgString = typeArgString + ",";
                }
                typeArgString = typeArgString + ReflectionUtility.getTypeString(typeArgument, fullNames);
            }
            return ReflectionUtility.getTypeString(pType.getRawType(), fullNames) + "<" + typeArgString + ">";
        }
        if (type instanceof TypeVariable) {
            TypeVariable vType = (TypeVariable)type;
            return ReflectionUtility.getName(vType.getClass(), fullNames);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType aType = (GenericArrayType)type;
            return ReflectionUtility.getName(aType.getClass(), fullNames) + "[" + ReflectionUtility.getTypeString(aType.getGenericComponentType(), fullNames) + "]";
        }
        if (type instanceof WildcardType) {
            return ((WildcardType)type).toString();
        }
        if (type == null) {
            return "";
        }
        return ReflectionUtility.getName((Class)type, fullNames);
    }

    private static String getName(Class<?> cls, boolean fullName) {
        return fullName ? cls.getName() : cls.getSimpleName();
    }
}

