/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.script;

import java.util.ArrayList;
import java.util.List;

public final class ScriptArgumentParser {
    private ScriptArgumentParser() {
    }

    public static String[] parse(String args, char escape) {
        State state = State.SPACE;
        ArrayList<String> parsedArgs = new ArrayList<String>();
        int i = 0;
        int len = args.length();
        StringBuilder arg = new StringBuilder();
        while (i < len) {
            char c = args.charAt(i++);
            switch (state) {
                case SPACE: {
                    boolean isNotWhitespace = false;
                    if (!Character.isWhitespace(c)) {
                        ScriptArgumentParser.insertArg(arg, parsedArgs);
                        isNotWhitespace = true;
                    }
                    if (c == escape) {
                        state = State.ESCAPE;
                        break;
                    }
                    if (c == '\"') {
                        state = State.DOUBLE_QUOTE;
                        break;
                    }
                    if (c == '\'') {
                        state = State.SINGLE_QUOTE;
                        break;
                    }
                    if (!isNotWhitespace) break;
                    arg.append(c);
                    state = State.ARG;
                    break;
                }
                case ESCAPE: {
                    arg.append(c);
                    state = State.ARG;
                    break;
                }
                case ARG: {
                    if (c == escape) {
                        state = State.ESCAPE;
                        break;
                    }
                    if (c == '\"') {
                        state = State.DOUBLE_QUOTE;
                        break;
                    }
                    if (c == '\'') {
                        state = State.SINGLE_QUOTE;
                        break;
                    }
                    if (!Character.isWhitespace(c)) {
                        arg.append(c);
                        break;
                    }
                    state = State.SPACE;
                    break;
                }
                case DOUBLE_QUOTE: {
                    if (c == '\"') {
                        state = State.ARG;
                        break;
                    }
                    if (c == escape) {
                        state = State.DOUBLE_QUOTE_ESCAPE;
                        break;
                    }
                    arg.append(c);
                    break;
                }
                case DOUBLE_QUOTE_ESCAPE: {
                    if (c != '\"' && c != escape) {
                        arg.append(escape);
                    }
                    arg.append(c);
                    state = State.DOUBLE_QUOTE;
                    break;
                }
                case SINGLE_QUOTE: {
                    if (c == '\'') {
                        state = State.ARG;
                        break;
                    }
                    arg.append(c);
                }
            }
        }
        if (arg.length() > 0) {
            parsedArgs.add(arg.toString());
        }
        return parsedArgs.toArray(new String[parsedArgs.size()]);
    }

    private static void insertArg(StringBuilder bld, List<String> args) {
        if (bld.length() > 0) {
            args.add(bld.toString());
            bld.delete(0, bld.length());
        }
    }

    private static enum State {
        SPACE,
        ESCAPE,
        ARG,
        DOUBLE_QUOTE,
        DOUBLE_QUOTE_ESCAPE,
        SINGLE_QUOTE;

    }
}

