/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.scripting.javascript.util;

import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import org.mozilla.javascript.commonjs.module.provider.ModuleSource;
import org.mozilla.javascript.commonjs.module.provider.ModuleSourceProviderBase;
import org.rhq.scripting.ScriptSourceProvider;

public class ScriptSourceToModuleSourceProviderAdapter
extends ModuleSourceProviderBase {
    private static final long serialVersionUID = 1L;
    private static final String SUFFIX = ".js";
    private ScriptSourceProvider scriptSourceProvider;

    public ScriptSourceToModuleSourceProviderAdapter(ScriptSourceProvider provider) {
        this.scriptSourceProvider = provider;
    }

    @Override
    protected ModuleSource loadFromPrivilegedLocations(String moduleId, Object validator) throws IOException, URISyntaxException {
        URI uri = new URI(moduleId);
        if (!uri.isAbsolute()) {
            return null;
        }
        return this.loadFromUri(uri, null, validator);
    }

    @Override
    protected ModuleSource loadFromUri(URI uri, URI base, Object validator) throws IOException, URISyntaxException {
        Reader sourceReader;
        URI fullUri = uri;
        if (base != null) {
            fullUri = base.resolve(uri);
        }
        if (!fullUri.getSchemeSpecificPart().endsWith(SUFFIX)) {
            fullUri = new URI(fullUri.getScheme(), fullUri.getAuthority(), fullUri.getPath() + SUFFIX, fullUri.getQuery(), fullUri.getFragment());
        }
        if ((sourceReader = this.scriptSourceProvider.getScriptSource(fullUri)) == null) {
            return null;
        }
        return new ModuleSource(sourceReader, null, uri, base, validator);
    }
}

