/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.control;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.server.control.RHQControlException;

public abstract class ControlCommand {
    public static final String SERVER_OPTION = "server";
    public static final String STORAGE_OPTION = "storage";
    public static final String AGENT_OPTION = "agent";
    public static final String RHQ_AGENT_BASEDIR_PROP = "rhq.agent.basedir";
    protected static final String STORAGE_BASEDIR_NAME = "rhq-storage";
    protected static final String AGENT_BASEDIR_NAME = "rhq-agent";
    private final File defaultStorageBasedir;
    private final File defaultAgentBasedir;
    protected final Log log = LogFactory.getLog((String)this.getClass().getName());
    private File basedir;
    private File binDir;
    private PropertiesConfiguration rhqctlConfig = null;
    private ArrayList<Runnable> undoTasks = new ArrayList();

    protected void undo() {
        Collections.reverse(this.undoTasks);
        for (Runnable undoTask : this.undoTasks) {
            try {
                undoTask.run();
            }
            catch (Throwable t) {
                this.log.error((Object)("Failed to invoke undo task [" + undoTask + "], will keep going but system may be in an indeterminate state"));
            }
        }
    }

    protected void addUndoTask(UndoTask r) {
        this.undoTasks.add(r);
    }

    public ControlCommand() {
        this.basedir = new File(System.getProperty("rhq.server.basedir"));
        this.binDir = new File(this.basedir, "bin/internal");
        File rhqctlPropertiesFile = this.getRhqCtlProperties();
        if (rhqctlPropertiesFile != null) {
            try {
                this.rhqctlConfig = new PropertiesConfiguration(rhqctlPropertiesFile);
            }
            catch (ConfigurationException e) {
                throw new RHQControlException("Failed to load configuration", e);
            }
        }
        this.defaultStorageBasedir = new File(this.getBaseDir(), STORAGE_BASEDIR_NAME);
        this.defaultAgentBasedir = new File(this.getBaseDir().getParent(), AGENT_BASEDIR_NAME);
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract Options getOptions();

    protected abstract int exec(org.apache.commons.cli.CommandLine var1);

    public int exec(String[] args) {
        Options options = this.getOptions();
        int rValue = 0;
        try {
            PosixParser parser = new PosixParser();
            org.apache.commons.cli.CommandLine cmdLine = parser.parse(options, args);
            rValue = this.exec(cmdLine);
            if (this.rhqctlConfig != null) {
                this.rhqctlConfig.save();
            }
        }
        catch (ParseException e) {
            this.printUsage();
            rValue = 2;
        }
        catch (ConfigurationException e) {
            throw new RHQControlException("Failed to update " + this.getRhqCtlProperties(), e);
        }
        return rValue;
    }

    public void printUsage() {
        Options options = this.getOptions();
        HelpFormatter helpFormatter = new HelpFormatter();
        String header = "\n" + this.getDescription() + "\n\n";
        String syntax = options.getOptions().isEmpty() ? "rhqctl " + this.getName() : "rhqctl " + this.getName() + " [options]";
        helpFormatter.setNewLine("\n");
        helpFormatter.printHelp(syntax, header, options, null);
        String readmeContent = this.getReadmeContent();
        if (readmeContent != null) {
            System.out.println(readmeContent);
        }
    }

    protected abstract String getReadmeFilename();

    protected String getReadmeContent() {
        String readmeFilename = this.getReadmeFilename();
        if (readmeFilename == null) {
            return null;
        }
        File readmeFile = new File(this.getBaseDir(), readmeFilename);
        if (!readmeFile.canRead()) {
            return null;
        }
        try {
            FileReader fileReader = new FileReader(readmeFile);
            String readmeContent = StreamUtil.slurp((Reader)fileReader);
            return readmeContent;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected List<Integer> toIntList(String s) {
        String[] args = s.split(",");
        ArrayList<Integer> list = new ArrayList<Integer>(args.length);
        for (String arg : args) {
            list.add(Integer.parseInt(arg));
        }
        return list;
    }

    protected File getBaseDir() {
        return this.basedir;
    }

    protected File getBinDir() {
        return this.binDir;
    }

    protected File getLogDir() {
        return new File(this.getBaseDir(), "logs");
    }

    protected File getStorageBasedir() {
        return this.defaultStorageBasedir;
    }

    protected File getAgentBasedir() {
        String agentBasedirProperty = this.getProperty(RHQ_AGENT_BASEDIR_PROP, null);
        File retval = agentBasedirProperty == null ? this.defaultAgentBasedir : new File(agentBasedirProperty);
        return retval;
    }

    protected void setAgentBasedir(File agentBasedir) {
        if (agentBasedir != null && !agentBasedir.equals(this.defaultAgentBasedir)) {
            this.putProperty(RHQ_AGENT_BASEDIR_PROP, agentBasedir.getAbsolutePath());
        }
    }

    protected boolean isServerInstalled() {
        return this.isServerInstalled(this.getBaseDir());
    }

    protected File getServerInstalledMarkerFile(File baseDir) {
        return new File(baseDir, "jbossas/standalone/data/rhq.installed");
    }

    protected File getServerPropertiesFile() {
        return new File(this.getBaseDir(), "bin/rhq-server.properties");
    }

    protected boolean isServerInstalled(File baseDir) {
        File markerFile = this.getServerInstalledMarkerFile(baseDir);
        return markerFile.exists();
    }

    protected boolean isAgentInstalled() {
        return this.getAgentBasedir().exists();
    }

    protected boolean isStorageInstalled() {
        return this.getStorageBasedir().exists();
    }

    protected File getStoragePidFile() {
        File storageBasedir = this.getStorageBasedir();
        File storageBinDir = new File(storageBasedir, "bin");
        File pidFile = new File(storageBinDir, "cassandra.pid");
        return pidFile;
    }

    protected String getStoragePid() throws IOException {
        File pidFile = this.getStoragePidFile();
        if (pidFile.exists()) {
            return StreamUtil.slurp((Reader)new FileReader(pidFile));
        }
        return null;
    }

    protected String getServerPid() throws IOException {
        File pidFile = new File(this.binDir, "rhq-server.pid");
        if (pidFile.exists()) {
            return StreamUtil.slurp((Reader)new FileReader(pidFile));
        }
        return null;
    }

    protected String getAgentPid() throws IOException {
        File agentBinDir = new File(this.getAgentBasedir(), "bin");
        File pidFile = new File(agentBinDir, "rhq-agent.pid");
        if (pidFile.exists()) {
            return StreamUtil.slurp((Reader)new FileReader(pidFile));
        }
        return null;
    }

    private String getProperty(String key, String defaultValue) {
        return this.rhqctlConfig != null ? this.rhqctlConfig.getString(key, defaultValue) : defaultValue;
    }

    private void putProperty(String key, String value) {
        if (this.rhqctlConfig == null) {
            this.rhqctlConfig = new PropertiesConfiguration();
            this.rhqctlConfig.setPath(this.getRhqCtlPropertiesPath());
        }
        this.rhqctlConfig.setProperty(key, (Object)value);
    }

    protected File getRhqCtlProperties() {
        String filename = this.getRhqCtlPropertiesPath();
        File file = new File(filename);
        if (!file.isFile()) {
            file = null;
        }
        return file;
    }

    protected String getRhqCtlPropertiesPath() {
        String sysprop = System.getProperty("rhqctl.properties-file");
        if (sysprop == null) {
            throw new RuntimeException("The required system property [rhqctl.properties-file] is not defined.");
        }
        return sysprop;
    }

    protected CommandLine getCommandLine(String scriptName, String ... args) {
        return this.getCommandLine(true, scriptName, args);
    }

    protected CommandLine getCommandLine(boolean addShExt, String scriptName, String ... args) {
        CommandLine result;
        if (this.isWindows()) {
            result = new CommandLine("cmd.exe");
            result.addArgument("/C");
            result.addArgument(scriptName.replace('/', '\\') + ".bat");
        } else {
            result = new CommandLine("./" + (addShExt ? scriptName + ".sh" : scriptName));
        }
        for (String arg : args) {
            result.addArgument(arg);
        }
        return result;
    }

    protected String getScript(String scriptName) {
        if (this.isWindows()) {
            return scriptName.replace('/', '\\') + ".bat";
        }
        return "./" + scriptName + ".sh";
    }

    protected boolean isWindows() {
        String operatingSystem = System.getProperty("os.name").toLowerCase(Locale.US);
        return operatingSystem.contains("windows");
    }

    protected boolean isPortInUse(String host, int port) {
        boolean inUse;
        try {
            Socket testSocket = new Socket(host, port);
            try {
                testSocket.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            inUse = true;
        }
        catch (Exception expected) {
            inUse = false;
        }
        return inUse;
    }

    protected void waitForProcessToStop(String pid) throws Exception {
        if (this.isWindows() || pid == null) {
            Thread.sleep(10000L);
        } else {
            int tries;
            for (tries = 5; tries > 0; --tries) {
                this.log.debug((Object)".");
                if (!this.isUnixPidRunning(pid)) break;
                Thread.sleep(2000L);
            }
            if (tries == 0) {
                throw new RHQControlException("Process [" + pid + "] did not finish yet. Terminate it manually and retry.");
            }
        }
    }

    protected void killPid(String pid) throws IOException {
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(this.getBinDir());
        PumpStreamHandler streamHandler = new PumpStreamHandler(this.createNullOutputStream(), this.createNullOutputStream());
        executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
        CommandLine commandLine = new CommandLine("kill").addArgument(pid);
        executor.execute(commandLine);
    }

    protected boolean isUnixPidRunning(String pid) {
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(this.getBinDir());
        PumpStreamHandler streamHandler = new PumpStreamHandler(this.createNullOutputStream(), this.createNullOutputStream());
        executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
        CommandLine commandLine = new CommandLine("kill").addArgument("-0").addArgument(pid);
        try {
            int code = executor.execute(commandLine);
            if (code != 0) {
                return false;
            }
        }
        catch (ExecuteException ee) {
            if (ee.getExitValue() == 1) {
                return false;
            }
        }
        catch (IOException e) {
            this.log.error((Object)("Checking for running process failed: " + e.getMessage()));
        }
        return true;
    }

    protected boolean isStorageRunning() throws IOException {
        String pid = this.getStoragePid();
        if (pid == null) {
            return false;
        }
        if (pid != null && !this.isUnixPidRunning(pid)) {
            File pidFile = this.getStoragePidFile();
            if (!pidFile.delete()) {
                throw new RHQControlException("Could not delete storage pidfile " + pidFile.getAbsolutePath());
            }
            return false;
        }
        return true;
    }

    protected OutputStream createNullOutputStream() {
        return new NullOutputStream();
    }

    private class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }
    }

    protected abstract class UndoTask
    implements Runnable {
        private final String message;

        public UndoTask() {
            this(null);
        }

        public UndoTask(String msg) {
            this.message = msg;
        }

        @Override
        public void run() {
            if (this.message != null) {
                ControlCommand.this.log.warn((Object)("UNDO: " + this.message));
            }
            try {
                this.performUndoWork();
            }
            catch (Exception e) {
                throw new RuntimeException("Undo task failed: " + (this.message == null ? "" : this.message), e);
            }
        }

        protected abstract void performUndoWork() throws Exception;
    }
}

