/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.control.command;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import java.util.prefs.Preferences;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.jboss.as.controller.client.ModelControllerClient;
import org.rhq.common.jbossas.client.controller.DeploymentJBossASClient;
import org.rhq.common.jbossas.client.controller.MCCHelper;
import org.rhq.core.util.PropertiesFileUpdate;
import org.rhq.core.util.file.FileReverter;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.server.control.ControlCommand;
import org.rhq.server.control.RHQControlException;
import org.rhq.server.control.command.Stop;

public abstract class AbstractInstall
extends ControlCommand {
    protected final String AGENT_CONFIG_OPTION = "agent-config";
    protected final String START_OPTION = "start";
    protected final String AGENT_PREFERENCE = "agent-preference";
    protected final String STORAGE_DATA_ROOT_DIR = "storage-data-root-dir";
    private static final String PREF_RHQ_AGENT_CONFIGURATION_SETUP_FLAG = "rhq.agent.configuration-setup-flag";
    private static final String PREF_RHQ_AGENT_AUTO_UPDATE_FLAG = "rhq.agent.agent-update.enabled";
    private static final String PREF_RHQ_AGENT_SECURITY_TOKEN = "rhq.agent.security-token";
    private static final String PREF_RHQ_AGENT_SERVER_TRANSPORT = "rhq.agent.server.transport";
    private static final String PREF_RHQ_AGENT_SERVER_BINDADDRESS = "rhq.agent.server.bind-address";
    private static final String PREF_RHQ_AGENT_SERVER_BINDPORT = "rhq.agent.server.bind-port";
    private static final String PREF_RHQ_AGENT_SERVER_TRANSPORTPARAMS = "rhq.agent.server.transport-params";

    protected int installWindowsService(File workingDir, String batFile, boolean replaceExistingService, boolean start) throws Exception {
        CommandLine commandLine;
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(workingDir);
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        int rValue = 0;
        if (replaceExistingService) {
            commandLine = this.getCommandLine(batFile, "stop");
            rValue = Math.max(rValue, executor.execute(commandLine));
            commandLine = this.getCommandLine(batFile, "remove");
            rValue = Math.max(rValue, executor.execute(commandLine));
        }
        commandLine = this.getCommandLine(batFile, "install");
        rValue = Math.max(rValue, executor.execute(commandLine));
        if (start) {
            commandLine = this.getCommandLine(batFile, "start");
            rValue = Math.max(rValue, executor.execute(commandLine));
        }
        return rValue;
    }

    protected void validateCustomStorageDataDirectories(org.apache.commons.cli.CommandLine commandLine, List<String> errors) {
        StorageDataDirectories customDataDirs = this.getCustomStorageDataDirectories(commandLine);
        if (customDataDirs != null) {
            if (customDataDirs.basedir.isAbsolute()) {
                if (!this.isDirectoryEmpty(customDataDirs.dataDir)) {
                    errors.add("Storage data directory [" + customDataDirs.dataDir + "] is not empty.");
                }
                if (!this.isDirectoryEmpty(customDataDirs.commitlogDir)) {
                    errors.add("Storage commitlog directory [" + customDataDirs.commitlogDir + "] is not empty.");
                }
                if (!this.isDirectoryEmpty(customDataDirs.savedcachesDir)) {
                    errors.add("Storage saved-caches directory [" + customDataDirs.savedcachesDir + "] is not empty.");
                }
            } else {
                errors.add("The storage root directory [" + customDataDirs.basedir + "] must be specified with an absolute path and should be outside of the main install directory.");
            }
        }
    }

    private boolean isDirectoryEmpty(File dir) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            return files == null || files.length == 0;
        }
        return true;
    }

    @Override
    protected void waitForProcessToStop(String pid) throws Exception {
        if (this.isWindows() || pid == null) {
            Thread.sleep(10000L);
        } else {
            int tries;
            for (tries = 5; tries > 0; --tries) {
                this.log.debug((Object)".");
                if (!this.isUnixPidRunning(pid)) break;
                Thread.sleep(2000L);
            }
            if (tries == 0) {
                throw new RHQControlException("Process [" + pid + "] did not finish yet. Terminate it manually and retry.");
            }
        }
    }

    protected void waitForRHQServerToInitialize() throws Exception {
        try {
            long timerStart;
            long messageInterval = 30000L;
            long problemMessageInterval = 120000L;
            long intervalStart = timerStart = System.currentTimeMillis();
            while (!this.isRHQServerInitialized()) {
                Long now = System.currentTimeMillis();
                if (now - intervalStart > 30000L) {
                    long totalWait = now - timerStart;
                    if (totalWait < 120000L) {
                        this.log.info((Object)"Still waiting for server to start...");
                    } else {
                        long minutes = totalWait / 60000L;
                        this.log.info((Object)("It has been over [" + minutes + "] minutes - you may want to ensure your server startup is proceeding as expected. You can check the log at [" + new File(this.getBaseDir(), "logs/server.log").getPath() + "]."));
                        timerStart = now;
                    }
                    intervalStart = now;
                }
                Thread.sleep(5000L);
            }
        }
        catch (IOException e) {
            this.log.error((Object)("An error occurred while checking to see if the server is initialized: " + e.getMessage()));
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isRHQServerInitialized() throws IOException {
        reader = null;
        mcc = null;
        props = new Properties();
        try {
            propsFile = this.getServerPropertiesFile();
            reader = new BufferedReader(new FileReader(propsFile));
            props.load(reader);
            host = (String)props.get("jboss.bind.address.management");
            port = Integer.valueOf((String)props.get("jboss.management.native.port"));
            mcc = MCCHelper.createModelControllerClient((String)host, (int)port);
            client = new DeploymentJBossASClient(mcc);
            var9_16 = isDeployed = client.isDeployment("rhq.ear");
            ** GOTO lbl35
        }
        catch (Throwable t) {
            block15: {
                try {
                    this.log.debug((Object)"Falling back to logfile check due to: ", t);
                    logDir = new File(this.getBaseDir(), "logs");
                    reader = new BufferedReader(new FileReader(new File(logDir, "server.log")));
                    line = reader.readLine();
lbl20:
                    // 2 sources

                    while (line != null) {
                        if (line.contains("Server initialized")) {
                            var7_11 = true;
                            break block15;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl54
                }
                catch (Throwable var11_18) {
                    MCCHelper.safeClose(mcc);
                    if (null == reader) throw var11_18;
                    try {
                        reader.close();
                        throw var11_18;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw var11_18;
                }
lbl35:
                // 1 sources

                MCCHelper.safeClose((ModelControllerClient)mcc);
                if (null == reader) return var9_16;
                try {
                    reader.close();
                    return var9_16;
                }
                catch (Exception e) {
                    // empty catch block
                }
                return var9_16;
            }
            MCCHelper.safeClose((ModelControllerClient)mcc);
            if (null == reader) return var7_11;
            try {
                reader.close();
                return var7_11;
            }
            catch (Exception e) {
                // empty catch block
            }
            return var7_11;
lbl-1000:
            // 1 sources

            {
                line = reader.readLine();
                ** GOTO lbl20
lbl54:
                // 1 sources

                var7_12 = false;
            }
            MCCHelper.safeClose((ModelControllerClient)mcc);
            if (null == reader) return var7_12;
            try {
                reader.close();
                return var7_12;
            }
            catch (Exception e) {
                // empty catch block
            }
            return var7_12;
        }
    }

    protected int updateWindowsAgentService(File agentBasedir) throws Exception {
        if (!this.isWindows()) {
            return 0;
        }
        int rValue = 0;
        try {
            File agentBinDir = new File(agentBasedir, "bin");
            if (!agentBinDir.exists()) {
                throw new IllegalArgumentException("No Agent found for base directory [" + agentBasedir.getPath() + "]");
            }
            this.log.info((Object)"Updating RHQ Agent Service...");
            DefaultExecutor executor = new DefaultExecutor();
            executor.setWorkingDirectory(agentBinDir);
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
            CommandLine commandLine = this.getCommandLine("rhq-agent-wrapper", "stop");
            try {
                rValue = executor.execute(commandLine);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to stop agent service", (Throwable)e);
            }
            commandLine = this.getCommandLine("rhq-agent-wrapper", "remove");
            try {
                rValue = Math.max(rValue, executor.execute(commandLine));
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to uninstall agent service", (Throwable)e);
            }
            commandLine = this.getCommandLine("rhq-agent-wrapper", "install");
            rValue = Math.max(rValue, executor.execute(commandLine));
        }
        catch (IOException e) {
            this.log.error((Object)("An error occurred while updating the agent service: " + e.getMessage()));
            throw e;
        }
        return rValue;
    }

    protected int startAgent(final File agentBasedir) throws Exception {
        int rValue;
        try {
            File agentBinDir = new File(agentBasedir, "bin");
            if (!agentBinDir.exists()) {
                throw new IllegalArgumentException("No Agent found for base directory [" + agentBasedir.getPath() + "]");
            }
            this.log.info((Object)"Starting RHQ agent...");
            DefaultExecutor executor = new DefaultExecutor();
            executor.setWorkingDirectory(agentBinDir);
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
            CommandLine commandLine = this.getCommandLine("rhq-agent-wrapper", "start");
            rValue = executor.execute(commandLine);
            this.addUndoTask(new ControlCommand.UndoTask("Stopping agent"){

                @Override
                public void performUndoWork() throws Exception {
                    AbstractInstall.this.killAgent(agentBasedir);
                }
            });
            this.log.info((Object)"The agent has started up");
        }
        catch (IOException e) {
            this.log.error((Object)("An error occurred while starting the agent: " + e.getMessage()));
            throw e;
        }
        return rValue;
    }

    protected int killAgent(File agentBasedir) throws Exception {
        File agentBinDir = new File(agentBasedir, "bin");
        if (!agentBinDir.exists()) {
            throw new IllegalArgumentException("No Agent found for base directory [" + agentBasedir.getPath() + "]");
        }
        this.log.debug((Object)"Stopping RHQ agent...");
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(agentBinDir);
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        int rValue = 0;
        if (this.isWindows()) {
            try {
                CommandLine commandLine = this.getCommandLine("rhq-agent-wrapper", "stop");
                rValue = executor.execute(commandLine);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to stop agent service", (Throwable)e);
                rValue = 1;
            }
        } else {
            String pid = this.getAgentPid();
            if (pid != null) {
                CommandLine commandLine = this.getCommandLine("rhq-agent-wrapper", "kill");
                rValue = executor.execute(commandLine);
            } else {
                rValue = 0;
            }
        }
        return rValue;
    }

    protected int stopServer() throws Exception {
        int rValue;
        File serverBinDir = this.getBinDir();
        if (!serverBinDir.exists()) {
            throw new IllegalArgumentException("No Server found for base directory [" + this.getBaseDir().getPath() + "]");
        }
        this.log.debug((Object)"Stopping RHQ server...");
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(serverBinDir);
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        CommandLine commandLine = this.getCommandLine("rhq-server", "stop");
        if (this.isWindows()) {
            try {
                rValue = executor.execute(commandLine);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to stop server service", (Throwable)e);
                rValue = 1;
            }
        } else {
            rValue = executor.execute(commandLine);
        }
        return rValue;
    }

    protected void startRHQServerForInstallation() throws IOException {
        try {
            CommandLine commandLine;
            this.log.info((Object)"The RHQ Server must be started to complete its installation. Starting the RHQ server in preparation of running the server installer...");
            if (this.isPortInUse("127.0.0.1", 9999)) {
                throw new IOException("Something is already listening to port 9999 - shut it down before installing the server.");
            }
            DefaultExecutor executor = new DefaultExecutor();
            executor.setWorkingDirectory(this.getBinDir());
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
            if (this.isWindows()) {
                commandLine = this.getCommandLine("rhq-server", "stop");
                executor.execute(commandLine);
                commandLine = this.getCommandLine("rhq-server", "remove");
                executor.execute(commandLine);
                commandLine = this.getCommandLine("rhq-server", "install");
                executor.execute(commandLine);
                commandLine = this.getCommandLine("rhq-server", "start");
                executor.execute(commandLine);
            } else {
                commandLine = this.getCommandLine("rhq-server", "start");
                executor.execute(commandLine, (ExecuteResultHandler)new DefaultExecuteResultHandler());
            }
            this.addUndoTaskToStopComponent("--server");
            this.log.info((Object)"Waiting for the RHQ Server to start in preparation of running the server installer...");
            commandLine = this.getCommandLine("rhq-installer", "--test");
            DefaultExecutor installerExecutor = new DefaultExecutor();
            installerExecutor.setWorkingDirectory(this.getBinDir());
            installerExecutor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
            int exitCode = 0;
            int numTries = 0;
            int maxTries = 30;
            do {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (numTries++ > maxTries) {
                    throw new IOException("Failed to detect server initialization, max tries exceeded. Aborting...");
                }
                if (numTries <= 1) continue;
                this.log.info((Object)"Still waiting to run the server installer...");
            } while ((exitCode = installerExecutor.execute(commandLine)) != 0);
            this.log.info((Object)"The RHQ Server is ready to be upgraded by the server installer.");
        }
        catch (IOException e) {
            this.log.error((Object)("An error occurred while starting the RHQ server: " + e.getMessage()));
            throw e;
        }
    }

    protected int runRHQServerInstaller() throws IOException {
        try {
            this.log.info((Object)"Installing RHQ server");
            File mgmtUserPropertiesFile = new File(this.getBaseDir(), "jbossas/standalone/configuration/mgmt-users.properties");
            final FileReverter mgmtUserPropertiesReverter = new FileReverter(mgmtUserPropertiesFile);
            this.addUndoTask(new ControlCommand.UndoTask("Removing server-installed marker file and management user"){

                @Override
                public void performUndoWork() throws Exception {
                    AbstractInstall.this.getServerInstalledMarkerFile(AbstractInstall.this.getBaseDir()).delete();
                    mgmtUserPropertiesReverter.revert();
                }
            });
            CommandLine commandLine = this.getCommandLine("rhq-installer", new String[0]);
            DefaultExecutor executor = new DefaultExecutor();
            executor.setWorkingDirectory(this.getBinDir());
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
            DefaultExecuteResultHandler executeHandler = new DefaultExecuteResultHandler();
            executor.execute(commandLine, (ExecuteResultHandler)executeHandler);
            this.log.info((Object)"The server installer is running");
            if (executeHandler.hasResult()) {
                return executeHandler.getExitValue();
            }
            return 0;
        }
        catch (Exception e) {
            this.log.error((Object)("An error occurred while starting the server installer: " + e.getMessage()));
            return 5;
        }
    }

    private StorageDataDirectories getCustomStorageDataDirectories(org.apache.commons.cli.CommandLine commandLine) {
        StorageDataDirectories storageDataDirs = null;
        if (commandLine.hasOption("storage-data-root-dir")) {
            storageDataDirs = new StorageDataDirectories();
            storageDataDirs.basedir = new File(commandLine.getOptionValue("storage-data-root-dir"));
            storageDataDirs.dataDir = new File(storageDataDirs.basedir, "data");
            storageDataDirs.commitlogDir = new File(storageDataDirs.basedir, "commit_log");
            storageDataDirs.savedcachesDir = new File(storageDataDirs.basedir, "saved_caches");
        }
        return storageDataDirs;
    }

    private StorageDataDirectories getStorageDataDirectoriesFromProperties(Properties storageProperties) {
        File basedirForData = new File(this.getBaseDir().getParentFile(), "rhq-data");
        File dataDirProp = new File(storageProperties.getProperty("rhq.storage.data", "data"));
        File commitlogDirProp = new File(storageProperties.getProperty("rhq.storage.commitlog", "commit_log"));
        File savedcachesDirProp = new File(storageProperties.getProperty("rhq.storage.saved-caches", "saved_caches"));
        if (!dataDirProp.isAbsolute()) {
            dataDirProp = new File(basedirForData, dataDirProp.getPath());
        }
        if (!commitlogDirProp.isAbsolute()) {
            commitlogDirProp = new File(basedirForData, commitlogDirProp.getPath());
        }
        if (!savedcachesDirProp.isAbsolute()) {
            savedcachesDirProp = new File(basedirForData, savedcachesDirProp.getPath());
        }
        StorageDataDirectories storageDataDirs = new StorageDataDirectories();
        storageDataDirs.basedir = basedirForData;
        storageDataDirs.dataDir = dataDirProp;
        storageDataDirs.commitlogDir = commitlogDirProp;
        storageDataDirs.savedcachesDir = savedcachesDirProp;
        return storageDataDirs;
    }

    protected int installStorageNode(final File storageBasedir, org.apache.commons.cli.CommandLine rhqctlCommandLine, boolean start) throws Exception {
        try {
            this.log.info((Object)"Preparing to install RHQ storage node.");
            final Properties storageProperties = this.loadStorageProperties();
            CommandLine commandLine = this.getCommandLine("rhq-storage-installer", "--dir", storageBasedir.getAbsolutePath(), "--start", Boolean.valueOf(start).toString());
            if (rhqctlCommandLine.hasOption("storage-data-root-dir")) {
                StorageDataDirectories dataDirs = this.getCustomStorageDataDirectories(rhqctlCommandLine);
                storageProperties.setProperty("rhq.storage.data", dataDirs.dataDir.getAbsolutePath());
                storageProperties.setProperty("rhq.storage.commitlog", dataDirs.commitlogDir.getAbsolutePath());
                storageProperties.setProperty("rhq.storage.saved-caches", dataDirs.savedcachesDir.getAbsolutePath());
            }
            String[] args = this.toArray(storageProperties);
            commandLine.addArguments(args);
            this.addUndoTask(new ControlCommand.UndoTask("Removing storage node data and install directories"){

                @Override
                public void performUndoWork() {
                    StorageDataDirectories dataDirs = AbstractInstall.this.getStorageDataDirectoriesFromProperties(storageProperties);
                    FileUtil.purge((File)dataDirs.dataDir, (boolean)true);
                    FileUtil.purge((File)dataDirs.commitlogDir, (boolean)true);
                    FileUtil.purge((File)dataDirs.savedcachesDir, (boolean)true);
                    FileUtil.purge((File)storageBasedir, (boolean)true);
                }
            });
            DefaultExecutor executor = new DefaultExecutor();
            executor.setWorkingDirectory(this.getBinDir());
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
            int exitCode = executor.execute(commandLine);
            this.log.info((Object)("The storage node installer has finished with an exit value of " + exitCode));
            this.addUndoTaskToStopComponent("--storage");
            return exitCode;
        }
        catch (Exception e) {
            this.log.error((Object)("An error occurred while running the storage installer: " + e.getMessage()));
            if (e.getMessage().toLowerCase().contains("exit value: 3")) {
                this.log.error((Object)"Try to point your root data directory via --storage-data-root-dir to a directory where you have read and write permissions.");
            }
            throw e;
        }
    }

    protected int installAgent(File agentBasedir, org.apache.commons.cli.CommandLine commandLine) throws Exception {
        this.clearAgentPreferences();
        int rValue = this.installAgent(agentBasedir);
        this.configureAgent(agentBasedir, commandLine);
        return rValue;
    }

    private int installAgent(final File agentBasedir) throws Exception {
        try {
            this.log.info((Object)"Installing RHQ agent");
            File agentInstallerJar = this.getAgentInstaller();
            this.setAgentBasedir(agentBasedir);
            this.addUndoTask(new ControlCommand.UndoTask("Removing agent install directory"){

                @Override
                public void performUndoWork() {
                    FileUtil.purge((File)agentBasedir, (boolean)true);
                }
            });
            String javaExeFilePath = System.getProperty("rhq.java-exe-file-path");
            CommandLine commandLine = new CommandLine(javaExeFilePath).addArgument("-jar").addArgument(agentInstallerJar.getAbsolutePath()).addArgument("--install=" + agentBasedir.getParentFile().getAbsolutePath()).addArgument("--log=" + new File(this.getLogDir(), "rhq-agent-update.log"));
            DefaultExecutor executor = new DefaultExecutor();
            executor.setWorkingDirectory(this.getBaseDir());
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
            int exitValue = executor.execute(commandLine);
            this.log.info((Object)("The agent installer finished running with exit value " + exitValue));
            return exitValue;
        }
        catch (Exception e) {
            this.log.error((Object)("An error occurred while running the agent installer: " + e.getMessage()));
            throw e;
        }
    }

    private File getAgentInstaller() {
        File agentDownloadDir = new File(this.getBaseDir(), "modules/org/rhq/server-startup/main/deployments/rhq.ear/rhq-downloads/rhq-agent");
        return agentDownloadDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().contains("rhq-enterprise-agent");
            }
        })[0];
    }

    private void clearAgentPreferences() throws Exception {
        this.log.info((Object)"Removing any existing agent preferences from default preference node");
        Preferences agentPrefs = this.getAgentPreferences();
        String[] prefKeys = null;
        try {
            prefKeys = agentPrefs.keys();
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to get agent preferences - cannot clear them: " + e));
        }
        if (prefKeys != null && prefKeys.length > 0) {
            for (String prefKey : prefKeys) {
                if (prefKey.equals(PREF_RHQ_AGENT_SECURITY_TOKEN)) continue;
                agentPrefs.remove(prefKey);
            }
            agentPrefs.flush();
            Preferences.userRoot().sync();
        }
    }

    private Preferences getAgentPreferences() {
        Preferences agentPrefs = Preferences.userRoot().node("rhq-agent/default");
        return agentPrefs;
    }

    private void configureAgent(File agentBasedir, org.apache.commons.cli.CommandLine commandLine) throws Exception {
        try {
            File agentConfDir = new File(agentBasedir, "conf");
            File agentConfigFile = new File(agentConfDir, "agent-configuration.xml");
            if (commandLine.hasOption("agent-config")) {
                this.log.info((Object)("Configuring the RHQ agent with custom configuration file: " + commandLine.getOptionValue("agent-config")));
                this.replaceAgentConfigIfNecessary(commandLine);
            } else {
                this.log.info((Object)("Configuring the RHQ agent with default configuration file: " + agentConfigFile));
            }
            Preferences preferencesNode = this.getAgentPreferences();
            String securityToken = preferencesNode.get(PREF_RHQ_AGENT_SECURITY_TOKEN, null);
            ByteArrayOutputStream rawConfigFileData = new ByteArrayOutputStream();
            StreamUtil.copy((InputStream)new FileInputStream(agentConfigFile), (OutputStream)rawConfigFileData, (boolean)true);
            String newConfig = rawConfigFileData.toString().replace("${rhq.agent.preferences-node}", "default");
            ByteArrayInputStream newConfigInputStream = new ByteArrayInputStream(newConfig.getBytes());
            Preferences.importPreferences(newConfigInputStream);
            if (securityToken != null) {
                preferencesNode.put(PREF_RHQ_AGENT_SECURITY_TOKEN, securityToken);
            }
            Properties serverEndpoint = this.getAgentServerEndpoint();
            String endpointTransport = serverEndpoint.getProperty(PREF_RHQ_AGENT_SERVER_TRANSPORT);
            String endpointAddress = serverEndpoint.getProperty(PREF_RHQ_AGENT_SERVER_BINDADDRESS);
            String endpointPort = serverEndpoint.getProperty(PREF_RHQ_AGENT_SERVER_BINDPORT);
            String endpointParams = serverEndpoint.getProperty(PREF_RHQ_AGENT_SERVER_TRANSPORTPARAMS);
            if (endpointTransport != null) {
                preferencesNode.put(PREF_RHQ_AGENT_SERVER_TRANSPORT, endpointTransport);
            }
            if (endpointAddress != null) {
                preferencesNode.put(PREF_RHQ_AGENT_SERVER_BINDADDRESS, endpointAddress);
            }
            if (endpointPort != null) {
                preferencesNode.put(PREF_RHQ_AGENT_SERVER_BINDPORT, endpointPort);
            }
            if (endpointParams != null) {
                preferencesNode.put(PREF_RHQ_AGENT_SERVER_TRANSPORTPARAMS, endpointParams);
            }
            this.overrideAgentPreferences(commandLine, preferencesNode);
            String agentUpdateEnabledPref = PREF_RHQ_AGENT_AUTO_UPDATE_FLAG;
            preferencesNode.putBoolean(agentUpdateEnabledPref, false);
            String setupPref = PREF_RHQ_AGENT_CONFIGURATION_SETUP_FLAG;
            preferencesNode.putBoolean(setupPref, true);
            preferencesNode.flush();
            preferencesNode.sync();
            this.log.info((Object)"Finished configuring the agent");
        }
        catch (Exception e) {
            this.log.error((Object)("An error occurred while configuring the agent: " + e.getMessage()));
            throw e;
        }
    }

    private Properties getAgentServerEndpoint() throws Exception {
        String port;
        Properties endpointData = new Properties();
        File serverPropsFile = this.getServerPropertiesFile();
        Properties serverProps = new PropertiesFileUpdate(serverPropsFile).loadExistingProperties();
        String transport = serverProps.getProperty("rhq.communications.connector.transport", "servlet");
        endpointData.put(PREF_RHQ_AGENT_SERVER_TRANSPORT, transport);
        String params = serverProps.getProperty("rhq.communications.connector.transport-params");
        if (params != null && params.trim().length() > 0) {
            endpointData.setProperty(PREF_RHQ_AGENT_SERVER_TRANSPORTPARAMS, params.trim());
        }
        if (transport.contains("servlet")) {
            String address;
            port = transport.contains("ssl") ? serverProps.getProperty("rhq.server.socket.binding.port.https") : serverProps.getProperty("rhq.server.socket.binding.port.http");
            if (port != null && port.trim().length() > 0) {
                endpointData.setProperty(PREF_RHQ_AGENT_SERVER_BINDPORT, port.trim());
            }
            if ((address = serverProps.getProperty("jboss.bind.address")) != null && address.trim().length() > 0) {
                endpointData.setProperty(PREF_RHQ_AGENT_SERVER_BINDADDRESS, address.trim());
            }
        } else {
            String address;
            port = serverProps.getProperty("rhq.communications.connector.bind-port");
            if (port != null && port.trim().length() > 0) {
                endpointData.setProperty(PREF_RHQ_AGENT_SERVER_BINDPORT, port.trim());
            }
            if ((address = serverProps.getProperty("rhq.communications.connector.bind-address")) != null && address.trim().length() > 0) {
                endpointData.setProperty(PREF_RHQ_AGENT_SERVER_BINDADDRESS, address.trim());
            }
        }
        String publicEndpoint = serverProps.getProperty("rhq.autoinstall.public-endpoint-address");
        if (publicEndpoint != null && publicEndpoint.trim().length() > 0) {
            endpointData.setProperty(PREF_RHQ_AGENT_SERVER_BINDADDRESS, publicEndpoint.trim());
        }
        return endpointData;
    }

    private void overrideAgentPreferences(org.apache.commons.cli.CommandLine commandLine, Preferences preferencesNode) {
        String[] customPrefs = commandLine.getOptionValues("agent-preference");
        if (customPrefs != null && customPrefs.length > 0) {
            for (String nameValuePairString : customPrefs) {
                String[] nameValuePairArray = nameValuePairString.split("=", 2);
                String prefName = nameValuePairArray[0];
                String prefValue = nameValuePairArray.length == 1 ? "true" : nameValuePairArray[1];
                this.log.info((Object)("Overriding agent preference: " + prefName + "=" + prefValue));
                preferencesNode.put(prefName, prefValue);
            }
        }
    }

    private void replaceAgentConfigIfNecessary(org.apache.commons.cli.CommandLine commandLine) {
        if (!commandLine.hasOption("agent-config")) {
            return;
        }
        File newConfigFile = new File(commandLine.getOptionValue("agent-config"));
        File confDir = new File(this.getAgentBasedir(), "conf");
        File defaultConfigFile = new File(confDir, "agent-configuration.xml");
        defaultConfigFile.delete();
        try {
            StreamUtil.copy((Reader)new FileReader(newConfigFile), (Writer)new FileWriter(defaultConfigFile));
        }
        catch (IOException e) {
            throw new RHQControlException("Failed to replace " + defaultConfigFile + " with " + newConfigFile);
        }
    }

    protected void addUndoTaskToStopComponent(final String componentArgument) {
        this.addUndoTask(new ControlCommand.UndoTask("Stopping component: " + componentArgument){

            @Override
            public void performUndoWork() throws Exception {
                Stop stopCommand = new Stop();
                PosixParser parser = new PosixParser();
                org.apache.commons.cli.CommandLine cmdLine = parser.parse(stopCommand.getOptions(), new String[]{componentArgument});
                stopCommand.exec(cmdLine);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadStorageProperties() throws IOException {
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File("bin/rhq-storage.properties"));
            properties.load(fis);
        }
        finally {
            if (null != fis) {
                fis.close();
            }
        }
        return properties;
    }

    private String[] toArray(Properties properties) {
        String[] array = new String[properties.size() * 2];
        int i = 0;
        for (Object key : properties.keySet()) {
            array[i++] = "--" + (String)key;
            array[i++] = properties.getProperty((String)key);
        }
        return array;
    }

    private class StorageDataDirectories {
        public File basedir;
        public File dataDir;
        public File commitlogDir;
        public File savedcachesDir;

        private StorageDataDirectories() {
        }
    }
}

