/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.control;

import java.io.Console;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.util.PropertiesFileUpdate;
import org.rhq.core.util.StringUtil;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.obfuscation.Obfuscator;
import org.rhq.enterprise.server.installer.ServerProperties;
import org.rhq.server.control.Commands;
import org.rhq.server.control.ControlCommand;
import org.rhq.server.control.RHQControlException;
import org.rhq.server.control.UsageException;
import org.rhq.storage.installer.StorageProperty;

public class RHQControl {
    private final Log log = LogFactory.getLog(RHQControl.class);
    public static final int EXIT_CODE_OK = 0;
    public static final int EXIT_CODE_STATUS_NOT_RUNNING = 3;
    public static final int EXIT_CODE_STATUS_UNKNOWN = 4;
    public static final int EXIT_CODE_OPERATION_FAILED = 1;
    public static final int EXIT_CODE_INVALID_ARGUMENT = 2;
    public static final int EXIT_CODE_NOT_INSTALLED = 5;
    private Commands commands = new Commands();

    public void printUsage() {
        HelpFormatter helpFormatter = new HelpFormatter();
        String syntax = "rhqctl <cmd> [options]";
        String header = "\nwhere <cmd> is one of:";
        String footer = "\n* For help on a specific command: rhqctl <cmd> --help\n\n* Limit commands to a single component with one of: --storage, --server, --agent";
        helpFormatter.setOptPrefix("");
        helpFormatter.printHelp(syntax, header, this.commands.getOptions(), footer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exec(String[] args) {
        int rValue = 0;
        ControlCommand command = null;
        boolean undo = false;
        AbortHook abortHook = new AbortHook();
        try {
            if (args.length == 0) {
                this.printUsage();
                rValue = 2;
            } else {
                String commandName = this.findCommand(this.commands, args);
                command = this.commands.get(commandName);
                if (!this.isHelp(args)) {
                    this.logWarningIfAgentRPMIsInstalled(command);
                }
                this.validateInstallCommand(command, args);
                abortHook.setCommand(command);
                Runtime.getRuntime().addShutdownHook(abortHook);
                rValue = command.exec(this.getCommandLine(commandName, args));
            }
        }
        catch (UsageException e) {
            this.printUsage();
            rValue = 2;
        }
        catch (RHQControlException e) {
            undo = true;
            Throwable rootCause = ThrowableUtil.getRootCause((Throwable)e);
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)rootCause.getMessage(), rootCause);
            } else {
                this.log.error((Object)rootCause.getMessage());
            }
            rValue = 1;
        }
        catch (Throwable t) {
            undo = true;
            this.log.error((Object)t);
            rValue = 1;
        }
        finally {
            abortHook.setCommand(null);
            Runtime.getRuntime().removeShutdownHook(abortHook);
        }
        if (undo && command != null) {
            try {
                if (Boolean.getBoolean("rhqctl.skip.undo")) {
                    throw new Exception("Was told by user to skip clean up attempt.");
                }
                command.undo();
            }
            catch (Throwable t) {
                this.log.warn((Object)"Failed to clean up after the failed installation attempt. You may have to clean up some things before attempting to install again", t);
                rValue = 1;
            }
        }
        return rValue;
    }

    private void logWarningIfAgentRPMIsInstalled(ControlCommand command) {
        boolean rpmInstalled;
        if (!"install".equalsIgnoreCase(command.getName()) && !"upgrade".equalsIgnoreCase(command.getName())) {
            return;
        }
        File rpmParentLocation = new File("/usr/share");
        File[] rpms = rpmParentLocation.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.startsWith("jboss-on-")) {
                    File jonDir = new File(dir, name);
                    RHQControl.this.log.warn((Object)("An agent RPM installation was found in [" + jonDir + "]!!! You will not be able to successfully run this older agent anymore. You should consult the " + "install documentation about manually removing and/or merging the old and new agent."));
                    return true;
                }
                return false;
            }
        });
        boolean bl = rpmInstalled = rpms != null && rpms.length > 0;
        if (rpmInstalled) {
            try {
                this.log.warn((Object)("Please read the above warnings about the existence of agent RPM installations. This " + command.getName() + " will resume in a few seconds."));
                Thread.sleep(30000L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void validateInstallCommand(ControlCommand command, String[] args) {
        boolean validateStorage;
        if (!"install".equalsIgnoreCase(command.getName()) || this.isHelp(args)) {
            return;
        }
        List<String> argsList = Arrays.asList(args);
        boolean validateServer = argsList.contains("--server") || !argsList.contains("--storage") && !argsList.contains("--agent");
        boolean bl = validateStorage = argsList.contains("--storage") || !argsList.contains("--server") && !argsList.contains("--agent");
        if (validateServer) {
            File serverPropertiesFile = new File("bin/rhq-server.properties");
            if (validateServer && !serverPropertiesFile.isFile()) {
                throw new RHQControlException("The required rhq-server.properties file can not be found in the expected location [" + serverPropertiesFile.getAbsolutePath() + "]. Installation is canceled.");
            }
            try {
                PropertiesFileUpdate pfu = new PropertiesFileUpdate(serverPropertiesFile);
                Properties props = pfu.loadExistingProperties();
                this.promptForProperty(pfu, props, serverPropertiesFile.getName(), "jboss.bind.address", false);
                this.promptForProperty(pfu, props, serverPropertiesFile.getName(), "rhq.server.database.password", true);
            }
            catch (Throwable t) {
                throw new RHQControlException("The rhq-server.properties file is not valid. Installation is canceled: " + t.getMessage());
            }
            try {
                ServerProperties.validate((File)serverPropertiesFile);
            }
            catch (Throwable t) {
                throw new RHQControlException("The rhq-server.properties file is not valid. Installation is canceled: " + t.getMessage());
            }
        }
        if (validateStorage) {
            try {
                File storagePropertiesFile = new File("bin/rhq-storage.properties");
                if (validateStorage && !storagePropertiesFile.isFile()) {
                    throw new RHQControlException("The required rhq-storage.properties file can not be found in the expected location [" + storagePropertiesFile.getAbsolutePath() + "]. Installation is canceled.");
                }
                StorageProperty.validate((File)storagePropertiesFile);
            }
            catch (Throwable t) {
                throw new RHQControlException("The rhq-storage.properties file is not valid. Installation is canceled: " + t.getMessage());
            }
        }
    }

    private void promptForProperty(PropertiesFileUpdate pfu, Properties props, String propertiesFileName, String propertyName, boolean encode) throws Exception {
        String propertyValue = props.getProperty(propertyName);
        if (StringUtil.isBlank((String)propertyValue)) {
            Console console = System.console();
            console.format("\nThe [%s] property is required but not set in [%s].\n", propertyName, propertiesFileName);
            console.format("Do you want to set [%s] value now?\n", propertyName);
            String response = "";
            while (!response.startsWith("n") && !response.startsWith("y")) {
                response = String.valueOf(console.readLine("%s", "yes|no: ")).toLowerCase();
            }
            if (response.startsWith("n")) {
                throw new RHQControlException("Please update the [" + propertiesFileName + "] file as required.");
            }
            do {
                propertyValue = "";
                while (StringUtil.isBlank((String)propertyValue)) {
                    propertyValue = String.valueOf(console.readLine("%s", propertyName + (encode ? " (enter as plain text): " : ": ")));
                }
                console.format("Is [" + propertyValue + "] correct?\n", new Object[0]);
                response = "";
                while (!response.startsWith("n") && !response.startsWith("y")) {
                    response = String.valueOf(console.readLine("%s", "yes|no: ")).toLowerCase();
                }
            } while (response.startsWith("n"));
            props.setProperty(propertyName, encode ? Obfuscator.encode((String)propertyValue) : propertyValue);
            pfu.update(props);
        }
    }

    private String findCommand(Commands commands, String[] args) throws RHQControlException {
        LinkedList<String> commandNames = new LinkedList<String>();
        for (String arg : args) {
            if (!commands.contains(arg)) continue;
            commandNames.add(arg);
        }
        if (commandNames.size() != 1) {
            throw new UsageException();
        }
        return (String)commandNames.get(0);
    }

    private boolean isHelp(String[] args) {
        for (String arg : args) {
            if (!"--help".equals(arg) && !"-h".equals(arg)) continue;
            return true;
        }
        return false;
    }

    private String[] getCommandLine(String cmd, String[] args) {
        String[] cmdLine = new String[args.length - 1];
        int i = 0;
        for (String arg : args) {
            if (arg.equals(cmd)) continue;
            cmdLine[i++] = arg;
        }
        return cmdLine;
    }

    public static void main(String[] args) throws Exception {
        int rValue;
        RHQControl control = new RHQControl();
        try {
            rValue = control.exec(args);
        }
        catch (RHQControlException e) {
            Throwable rootCause = ThrowableUtil.getRootCause((Throwable)e);
            if (control.log.isDebugEnabled()) {
                control.log.error((Object)("There was an unexpected error: " + rootCause.getMessage()), rootCause);
            } else {
                control.log.error((Object)("There was an unexpected error: " + rootCause.getMessage()));
            }
            rValue = 1;
        }
        System.exit(rValue);
    }

    private class AbortHook
    extends Thread {
        private ControlCommand command;

        public AbortHook() {
            super("Controller Abort Hook");
            this.command = null;
        }

        public void setCommand(ControlCommand cmd) {
            this.command = cmd;
        }

        @Override
        public void run() {
            try {
                if (this.command != null) {
                    this.command.undo();
                }
            }
            catch (Throwable t) {
                RHQControl.this.log.warn((Object)"An attempt to clean up after an aborted installation was unsuccessful. You may have to clean up some things before attempting to install again", t);
            }
        }
    }
}

