/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.control.command;

import java.io.File;
import java.util.HashMap;
import org.apache.commons.cli.Options;
import org.apache.commons.exec.CommandLine;
import org.rhq.server.control.ControlCommand;
import org.rhq.server.control.RHQControlException;
import org.rhq.server.control.util.ExecutorAssist;

public class Start
extends ControlCommand {
    private Options options = new Options().addOption(null, "storage", false, "Start RHQ storage node").addOption(null, "server", false, "Start RHQ server").addOption(null, "agent", false, "Start RHQ agent");

    @Override
    public String getName() {
        return "start";
    }

    @Override
    public String getDescription() {
        return "Starts RHQ services.";
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    protected String getReadmeFilename() {
        return "START_README.txt";
    }

    @Override
    protected int exec(org.apache.commons.cli.CommandLine commandLine) {
        int rValue = 0;
        try {
            if (commandLine.getOptions().length == 0) {
                boolean storageInstalled = this.isStorageInstalled();
                boolean serverInstalled = this.isServerInstalled();
                boolean agentInstalled = this.isAgentInstalled();
                if (!(storageInstalled || serverInstalled || agentInstalled)) {
                    this.log.warn((Object)"Nothing to start. No RHQ services are installed.");
                    rValue = 5;
                } else {
                    if (storageInstalled) {
                        rValue = Math.max(rValue, this.startStorage());
                    }
                    if (serverInstalled) {
                        rValue = Math.max(rValue, this.startRHQServer());
                    }
                    if (agentInstalled) {
                        rValue = Math.max(rValue, this.startAgent());
                    }
                }
            } else {
                if (commandLine.hasOption("storage")) {
                    if (this.isStorageInstalled()) {
                        rValue = Math.max(rValue, this.startStorage());
                    } else {
                        this.log.warn((Object)"It appears that the storage node is not installed. The --storage option will be ignored.");
                        rValue = 5;
                    }
                }
                if (commandLine.hasOption("server")) {
                    if (this.isServerInstalled()) {
                        rValue = Math.max(rValue, this.startRHQServer());
                    } else {
                        this.log.warn((Object)"It appears that the server is not installed. The --server option will be ignored.");
                        rValue = 5;
                    }
                }
                if (commandLine.hasOption("agent")) {
                    if (this.isAgentInstalled()) {
                        rValue = Math.max(rValue, this.startAgent());
                    } else {
                        this.log.warn((Object)"It appears that the agent is not installed. The --agent option will be ignored.");
                        rValue = 5;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RHQControlException("Failed to start services", e);
        }
        return rValue;
    }

    private int startStorage() throws Exception {
        int rValue;
        this.log.debug((Object)"Starting RHQ storage node");
        String javaExeFilePath = System.getProperty("rhq.java-exe-file-path");
        String javaHome = javaExeFilePath.replace('\\', '/').replace("/bin/java", "");
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        env.put("JAVA_HOME", javaHome);
        if (this.isWindows()) {
            CommandLine commandLine = this.getCommandLine("rhq-storage", "start");
            rValue = ExecutorAssist.execute(this.getBinDir(), commandLine, env);
            if (rValue != 0) {
                this.log.debug((Object)("Failed to start storage service, return value" + rValue));
            }
        } else {
            File storageBinDir = new File(this.getStorageBasedir(), "bin");
            File pidFile = this.getStoragePidFile();
            if (this.isStorageRunning()) {
                String pid = this.getStoragePid();
                System.out.println("RHQ storage node (pid " + pid + ") is running");
                rValue = 0;
            } else {
                CommandLine commandLine = this.getCommandLine(false, "cassandra", "-p", pidFile.getAbsolutePath());
                rValue = ExecutorAssist.execute(storageBinDir, commandLine, env);
            }
        }
        return rValue;
    }

    private int startRHQServer() throws Exception {
        int rValue;
        this.log.debug((Object)"Starting RHQ server");
        CommandLine commandLine = this.getCommandLine("rhq-server", "start");
        if (this.isWindows()) {
            try {
                rValue = ExecutorAssist.execute(this.getBinDir(), commandLine);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to start server service", (Throwable)e);
                rValue = 1;
            }
        } else {
            rValue = ExecutorAssist.execute(this.getBinDir(), commandLine);
        }
        return rValue;
    }

    private int startAgent() throws Exception {
        int rValue;
        this.log.debug((Object)"Starting RHQ agent");
        File agentBinDir = new File(this.getAgentBasedir(), "bin");
        CommandLine commandLine = this.getCommandLine("rhq-agent-wrapper", "start");
        if (this.isWindows()) {
            try {
                rValue = ExecutorAssist.execute(agentBinDir, commandLine);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to start agent service", (Throwable)e);
                rValue = 1;
            }
        } else {
            rValue = ExecutorAssist.execute(agentBinDir, commandLine);
        }
        return rValue;
    }
}

