/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.control.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Future;
import org.apache.commons.cli.Options;
import org.apache.commons.exec.CommandLine;
import org.rhq.server.control.ControlCommand;
import org.rhq.server.control.RHQControlException;
import org.rhq.server.control.util.ExecutorAssist;

public class Console
extends ControlCommand {
    private Options options = new Options().addOption(null, "storage", false, "Start the RHQ storage node in the foreground").addOption(null, "server", false, "Start the RHQ server in the foreground");

    @Override
    public String getName() {
        return "console";
    }

    @Override
    public String getDescription() {
        return "Starts an RHQ service in the foreground. Only --server or --storage is supported. To start the agent in the foreground, use the <RHQ_AGENT_HOME>/bin/rhq-agent.(sh|bat) script.";
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    protected String getReadmeFilename() {
        return "CONSOLE_README.txt";
    }

    @Override
    protected int exec(org.apache.commons.cli.CommandLine commandLine) {
        int rValue;
        block13: {
            rValue = 0;
            if (commandLine.getOptions().length != 1) {
                this.printUsage();
                rValue = 2;
            } else {
                String option = commandLine.getOptions()[0].getLongOpt();
                try {
                    if (option.equals("storage")) {
                        if (this.isStorageInstalled()) {
                            rValue = Math.max(rValue, this.startStorageInForeground());
                        } else {
                            this.log.warn((Object)"It appears that the storage node is not installed. The --storage option will be ignored.");
                            rValue = 2;
                        }
                        break block13;
                    }
                    if (option.equals("server")) {
                        if (this.isServerInstalled()) {
                            rValue = Math.max(rValue, this.startServerInForeground());
                        } else {
                            this.log.warn((Object)"It appears that the server is not installed. The --server option will be ignored.");
                            rValue = 2;
                        }
                        break block13;
                    }
                    if (option.equals("agent")) {
                        if (this.isAgentInstalled()) {
                            rValue = Math.max(rValue, this.startAgentInForeground());
                        } else {
                            this.log.warn((Object)"It appears that the agent is not installed. The --agent option will be ignored.");
                            rValue = 2;
                        }
                        break block13;
                    }
                    throw new IllegalArgumentException(option + " is not a supported option");
                }
                catch (Exception e) {
                    throw new RHQControlException("Failed to execute console command", e);
                }
            }
        }
        return rValue;
    }

    private int startStorageInForeground() throws Exception {
        this.log.debug((Object)"Starting RHQ storage node in foreground");
        File storageBinDir = new File(this.getStorageBasedir(), "bin");
        if (this.isWindows()) {
            return this.startInWindowsForeground(storageBinDir, "cassandra", "-f");
        }
        CommandLine commandLine = new CommandLine(this.getCommandLine(false, "cassandra", "-f"));
        return ExecutorAssist.execute(storageBinDir, commandLine);
    }

    private int startServerInForeground() throws Exception {
        this.log.debug((Object)"Starting RHQ server in foreground");
        this.validateServerPropertiesFile();
        File binDir = this.getBinDir();
        if (this.isWindows()) {
            return this.startInWindowsForeground(binDir, "rhq-server", "console");
        }
        CommandLine commandLine = this.getCommandLine("rhq-server", "console");
        return ExecutorAssist.execute(binDir, commandLine);
    }

    private int startAgentInForeground() throws Exception {
        this.log.info((Object)"Starting RHQ agent in foreground");
        File agentHomeDir = this.getAgentBasedir();
        File agentBinDir = new File(agentHomeDir, "bin");
        File confDir = new File(agentHomeDir, "conf");
        File agentConfigFile = new File(confDir, "agent-configuration.xml");
        Process process = new ProcessBuilder(this.getScript("rhq-agent"), "-c", agentConfigFile.getPath()).directory(agentBinDir).start();
        AgentInputStreamPipe pipe = new AgentInputStreamPipe(process.getInputStream());
        pipe.start();
        pipe.join();
        return 0;
    }

    private int startInWindowsForeground(File binDir, String script, String ... scriptArgs) throws Exception {
        CommandLine commandLine = this.getConsoleCommandLine(script, scriptArgs);
        Future<Integer> f = ExecutorAssist.executeAsync(binDir, commandLine, null);
        for (int i = 0; i < 3 && !f.isDone(); ++i) {
            Thread.sleep(1000L);
        }
        return f.isDone() ? f.get() : 0;
    }

    private class AgentInputStreamPipe
    extends Thread {
        private InputStream inputStream;

        public AgentInputStreamPipe(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public void run() {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));
            try {
                boolean running = true;
                while (running) {
                    String line = reader.readLine();
                    System.out.println(line);
                    running = line == null || !line.equals("quit");
                }
            }
            catch (IOException e) {
                Console.this.log.error((Object)"An error occurred processing input from the agent prompt", (Throwable)e);
            }
        }
    }
}

