/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.control.command;

import java.io.File;
import org.apache.commons.cli.Options;
import org.apache.commons.exec.CommandLine;
import org.rhq.server.control.ControlCommand;
import org.rhq.server.control.RHQControlException;
import org.rhq.server.control.util.ExecutorAssist;

public class Status
extends ControlCommand {
    private Options options = new Options().addOption(null, "storage", false, "Check status of RHQ storage node").addOption(null, "server", false, "Check status of RHQ server").addOption(null, "agent", false, "Check status of RHQ agent");

    @Override
    public String getName() {
        return "status";
    }

    @Override
    public String getDescription() {
        return "Check status of RHQ services";
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    protected String getReadmeFilename() {
        return "STATUS_README.txt";
    }

    @Override
    protected int exec(org.apache.commons.cli.CommandLine commandLine) {
        int rValue = 0;
        try {
            boolean isColorSupported = Boolean.parseBoolean(System.getProperty("color"));
            if (commandLine.getOptions().length == 0) {
                boolean servicesInstalled = false;
                if (this.isStorageInstalled()) {
                    servicesInstalled = true;
                    rValue = Math.max(rValue, this.checkStorageStatus(isColorSupported));
                }
                if (this.isServerInstalled()) {
                    servicesInstalled = true;
                    rValue = Math.max(rValue, this.checkServerStatus());
                }
                if (this.isAgentInstalled()) {
                    servicesInstalled = true;
                    rValue = Math.max(rValue, this.checkAgentStatus());
                }
                if (!servicesInstalled) {
                    this.log.warn((Object)"No services installed. Please install the server, agent, or storage node and then re-run the command.");
                }
            } else {
                if (commandLine.hasOption("storage")) {
                    if (this.isStorageInstalled()) {
                        rValue = Math.max(rValue, this.checkStorageStatus(isColorSupported));
                    } else {
                        this.log.warn((Object)"It appears that the storage node is not installed. The --storage option will be ignored.");
                    }
                }
                if (commandLine.hasOption("server")) {
                    if (this.isServerInstalled()) {
                        rValue = Math.max(rValue, this.checkServerStatus());
                    } else {
                        this.log.warn((Object)"It appears that the server is not installed. The --server option will be ignored.");
                    }
                }
                if (commandLine.hasOption("agent")) {
                    if (this.isAgentInstalled()) {
                        rValue = Math.max(rValue, this.checkAgentStatus());
                    } else {
                        this.log.warn((Object)"It appears that the agent is not installed. The --agent option will be ignored.");
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RHQControlException("Failed to check statuses", e);
        }
        return rValue;
    }

    private int checkStorageStatus(boolean isColorSupported) throws Exception {
        this.log.debug((Object)"Checking RHQ storage node status");
        int rValue = 0;
        if (this.isWindows()) {
            CommandLine commandLine = this.getCommandLine("rhq-storage", "status");
            rValue = ExecutorAssist.execute(this.getBinDir(), commandLine);
        } else {
            String ANSI_RED = "\u001b[31m";
            String ANSI_GREEN = "\u001b[32m";
            String ANSI_RESET = "\u001b[0m";
            if (this.isStorageRunning()) {
                System.out.println(String.format("%-30s", "RHQ Storage Node") + " (pid " + String.format("%-7s", this.getStoragePid()) + ") is " + (isColorSupported ? "\u001b[32m" : "") + "\u2714running" + (isColorSupported ? "\u001b[0m" : ""));
            } else {
                System.out.println(String.format("%-30s", "RHQ Storage Node") + " (no pid file) is " + (isColorSupported ? "\u001b[31m" : "") + "\u2718down" + (isColorSupported ? "\u001b[0m" : ""));
                rValue = 3;
            }
        }
        return rValue;
    }

    private int checkServerStatus() throws Exception {
        this.log.debug((Object)"Checking RHQ server status");
        CommandLine commandLine = this.getCommandLine("rhq-server", "status");
        return ExecutorAssist.execute(this.getBinDir(), commandLine);
    }

    private int checkAgentStatus() throws Exception {
        this.log.debug((Object)"Checking RHQ agent status");
        File agentBinDir = new File(this.getAgentBasedir(), "bin");
        CommandLine commandLine = this.getCommandLine("rhq-agent-wrapper", "status");
        int rValue = ExecutorAssist.execute(agentBinDir, commandLine);
        if (!this.isWindows() && rValue > 1 && rValue != 3) {
            throw new RHQControlException("rhq-agent-wrapper exited with return value " + rValue);
        }
        return rValue;
    }
}

