/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.control.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.jboss.as.controller.client.ModelControllerClient;
import org.rhq.common.jbossas.client.controller.DeploymentJBossASClient;
import org.rhq.common.jbossas.client.controller.MCCHelper;
import org.rhq.server.control.ControlCommand;
import org.rhq.server.control.RHQControlException;

public abstract class AbstractInstall
extends ControlCommand {
    protected final String STORAGE_CONFIG_OPTION = "storage-config";
    protected final String STORAGE_DATA_ROOT_DIR = "storage-data-root-dir";
    protected final String STORAGE_CONFIG_PROP = "rhqctl.install.storage-config";

    protected void installWindowsService(File workingDir, String batFile) throws Exception {
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(workingDir);
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        CommandLine commandLine = this.getCommandLine(batFile, "stop");
        executor.execute(commandLine);
        commandLine = this.getCommandLine(batFile, "remove");
        executor.execute(commandLine);
        commandLine = this.getCommandLine(batFile, "install");
        executor.execute(commandLine);
    }

    protected void validateCustomStorageDataDirectories(org.apache.commons.cli.CommandLine commandLine, List<String> errors) {
        StorageDataDirectories customDataDirs = this.getCustomStorageDataDirectories(commandLine);
        if (customDataDirs != null) {
            if (customDataDirs.basedir.isAbsolute()) {
                if (!this.isDirectoryEmpty(customDataDirs.dataDir)) {
                    errors.add("Storage data directory [" + customDataDirs.dataDir + "] is not empty.");
                }
                if (!this.isDirectoryEmpty(customDataDirs.commitlogDir)) {
                    errors.add("Storage commitlog directory [" + customDataDirs.commitlogDir + "] is not empty.");
                }
                if (!this.isDirectoryEmpty(customDataDirs.savedcachesDir)) {
                    errors.add("Storage saved-caches directory [" + customDataDirs.savedcachesDir + "] is not empty.");
                }
            } else {
                errors.add("The storage root directory [" + customDataDirs.basedir + "] must be specified with an absolute path and should be outside of the main install directory.");
            }
        }
    }

    private boolean isDirectoryEmpty(File dir) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            return files == null || files.length == 0;
        }
        return true;
    }

    protected void waitForProcessToStop(String pid) throws Exception {
        if (this.isWindows() || pid == null) {
            Thread.sleep(10000L);
        } else {
            int tries;
            for (tries = 5; tries > 0; --tries) {
                this.log.debug((Object)".");
                if (!this.isUnixPidRunning(pid)) break;
                Thread.sleep(2000L);
            }
            if (tries == 0) {
                throw new RHQControlException("Process [" + pid + "] did not finish yet. Terminate it manually and retry.");
            }
        }
    }

    protected boolean isUnixPidRunning(String pid) {
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(this.getBinDir());
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        CommandLine commandLine = new CommandLine("/bin/kill").addArgument("-0").addArgument(pid);
        try {
            int code = executor.execute(commandLine);
            if (code != 0) {
                return false;
            }
        }
        catch (ExecuteException ee) {
            if (ee.getExitValue() == 1) {
                return false;
            }
        }
        catch (IOException e) {
            this.log.error((Object)("Checking for running process failed: " + e.getMessage()));
        }
        return true;
    }

    protected void waitForRHQServerToInitialize() throws Exception {
        try {
            long timerStart;
            long messageInterval = 30000L;
            long problemMessageInterval = 120000L;
            long intervalStart = timerStart = System.currentTimeMillis();
            while (!this.isRHQServerInitialized()) {
                Long now = System.currentTimeMillis();
                if (now - intervalStart > 30000L) {
                    long totalWait = now - timerStart;
                    if (totalWait < 120000L) {
                        this.log.info((Object)"Still waiting for server to start...");
                    } else {
                        long minutes = totalWait / 60000L;
                        this.log.info((Object)("It has been over [" + minutes + "] minutes - you may want to ensure your server startup is proceeding as expected. You can check the log at [" + new File(this.getBaseDir(), "logs/server.log").getPath() + "]."));
                        timerStart = now;
                    }
                    intervalStart = now;
                }
                Thread.sleep(5000L);
            }
        }
        catch (IOException e) {
            this.log.error((Object)("An error occurred while checking to see if the server is initialized: " + e.getMessage()));
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isRHQServerInitialized() throws IOException {
        boolean bl;
        BufferedReader reader;
        block26: {
            reader = null;
            ModelControllerClient mcc = null;
            Properties props = new Properties();
            try {
                boolean isDeployed;
                File propsFile = new File(this.getBaseDir(), "bin/rhq-server.properties");
                reader = new BufferedReader(new FileReader(propsFile));
                props.load(reader);
                String host = (String)props.get("jboss.bind.address.management");
                int port = Integer.valueOf((String)props.get("jboss.management.native.port"));
                mcc = MCCHelper.getModelControllerClient((String)host, (int)port);
                DeploymentJBossASClient client = new DeploymentJBossASClient(mcc);
                bl = isDeployed = client.isDeployment("rhq.ear");
                if (null == mcc) break block26;
            }
            catch (Throwable t) {
                try {
                    this.log.debug((Object)"Falling back to logfile check due to: ", t);
                    File logDir = new File(this.getBaseDir(), "logs");
                    reader = new BufferedReader(new FileReader(new File(logDir, "server.log")));
                    String line = reader.readLine();
                    while (line != null) {
                        if (line.contains("Server started")) {
                            boolean bl2 = true;
                            return bl2;
                        }
                        line = reader.readLine();
                    }
                    boolean bl3 = false;
                    return bl3;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (null != mcc) {
                        try {
                            mcc.close();
                        }
                        catch (Exception e) {}
                    }
                    if (null != reader) {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            try {
                mcc.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (null == reader) return bl;
        try {
            reader.close();
            return bl;
        }
        catch (Exception e) {
            // empty catch block
        }
        return bl;
    }

    protected void startAgent(File agentBasedir) throws Exception {
        this.startAgent(agentBasedir, false);
    }

    protected void startAgent(File agentBasedir, boolean updateWindowsService) throws Exception {
        try {
            CommandLine commandLine;
            File agentBinDir = new File(agentBasedir, "bin");
            if (!agentBinDir.exists()) {
                throw new IllegalArgumentException("No Agent found for base directory [" + agentBasedir.getPath() + "]");
            }
            this.log.info((Object)"Starting RHQ agent...");
            DefaultExecutor executor = new DefaultExecutor();
            executor.setWorkingDirectory(agentBinDir);
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
            if (this.isWindows() && updateWindowsService) {
                commandLine = this.getCommandLine("rhq-agent-wrapper", "stop");
                try {
                    executor.execute(commandLine);
                }
                catch (Exception e) {
                    this.log.debug((Object)"Failed to stop agent service", (Throwable)e);
                }
                commandLine = this.getCommandLine("rhq-agent-wrapper", "remove");
                try {
                    executor.execute(commandLine);
                }
                catch (Exception e) {
                    this.log.debug((Object)"Failed to uninstall agent service", (Throwable)e);
                }
                commandLine = this.getCommandLine("rhq-agent-wrapper", "install");
                executor.execute(commandLine);
            }
            commandLine = this.getCommandLine("rhq-agent-wrapper", "start");
            executor.execute(commandLine);
            this.log.info((Object)"The agent has started up");
        }
        catch (IOException e) {
            this.log.error((Object)("An error occurred while starting the agent: " + e.getMessage()));
            throw e;
        }
    }

    protected void stopAgent(File agentBasedir) throws Exception {
        File agentBinDir = new File(agentBasedir, "bin");
        if (!agentBinDir.exists()) {
            throw new IllegalArgumentException("No Agent found for base directory [" + agentBasedir.getPath() + "]");
        }
        this.log.debug((Object)"Stopping RHQ agent...");
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(agentBinDir);
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        CommandLine commandLine = this.getCommandLine("rhq-agent-wrapper", "stop");
        if (this.isWindows()) {
            try {
                executor.execute(commandLine);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to stop agent service", (Throwable)e);
            }
        } else {
            String pid = this.getAgentPid();
            if (pid != null) {
                executor.execute(commandLine);
            }
        }
    }

    protected void stopServer(File serverBasedir) throws Exception {
        File serverBinDir = new File(serverBasedir, "bin");
        if (!serverBinDir.exists()) {
            throw new IllegalArgumentException("No Server found for base directory [" + serverBasedir.getPath() + "]");
        }
        this.log.debug((Object)"Stopping RHQ server...");
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(serverBinDir);
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        CommandLine commandLine = this.getCommandLine("rhq-server", "stop");
        if (this.isWindows()) {
            try {
                executor.execute(commandLine);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to stop server service", (Throwable)e);
            }
        } else {
            executor.execute(commandLine);
        }
    }

    protected void startRHQServerForInstallation() throws IOException {
        try {
            CommandLine commandLine;
            this.log.info((Object)"The RHQ Server must be started to complete its upgrade. Starting the RHQ server in preparation of running the server installer...");
            if (this.isPortInUse("127.0.0.1", 9999)) {
                throw new IOException("Something is already listening to port 9999 - shut it down before upgrading the server.");
            }
            DefaultExecutor executor = new DefaultExecutor();
            executor.setWorkingDirectory(this.getBinDir());
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
            if (this.isWindows()) {
                commandLine = this.getCommandLine("rhq-server", "stop");
                executor.execute(commandLine);
                commandLine = this.getCommandLine("rhq-server", "remove");
                executor.execute(commandLine);
                commandLine = this.getCommandLine("rhq-server", "install");
                executor.execute(commandLine);
                commandLine = this.getCommandLine("rhq-server", "start");
                executor.execute(commandLine);
            } else {
                commandLine = this.getCommandLine("rhq-server", "start");
                executor.execute(commandLine, (ExecuteResultHandler)new DefaultExecuteResultHandler());
            }
            this.log.info((Object)"Waiting for the RHQ Server to start in preparation of running the server installer for upgrade...");
            commandLine = this.getCommandLine("rhq-installer", "--test");
            DefaultExecutor installerExecutor = new DefaultExecutor();
            installerExecutor.setWorkingDirectory(this.getBinDir());
            installerExecutor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
            int exitCode = 0;
            int numTries = 0;
            int maxTries = 30;
            do {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (numTries++ > maxTries) {
                    throw new IOException("Failed to detect server initialization, max tries exceeded. Aborting...");
                }
                if (numTries <= 1) continue;
                this.log.info((Object)"Still waiting to run the server installer...");
            } while ((exitCode = installerExecutor.execute(commandLine)) != 0);
            this.log.info((Object)"The RHQ Server is ready to be upgraded by the server installer.");
        }
        catch (IOException e) {
            this.log.error((Object)("An error occurred while starting the RHQ server: " + e.getMessage()));
            throw e;
        }
    }

    protected void runRHQServerInstaller() throws IOException {
        try {
            this.log.info((Object)"Installing RHQ server");
            CommandLine commandLine = this.getCommandLine("rhq-installer", new String[0]);
            DefaultExecutor executor = new DefaultExecutor();
            executor.setWorkingDirectory(this.getBinDir());
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
            executor.execute(commandLine, (ExecuteResultHandler)new DefaultExecuteResultHandler());
            this.log.info((Object)"The server installer is running");
        }
        catch (IOException e) {
            this.log.error((Object)("An error occurred while starting the server installer: " + e.getMessage()));
        }
    }

    private StorageDataDirectories getCustomStorageDataDirectories(org.apache.commons.cli.CommandLine commandLine) {
        StorageDataDirectories storageDataDirs = null;
        if (commandLine.hasOption("storage-data-root-dir")) {
            storageDataDirs = new StorageDataDirectories();
            storageDataDirs.basedir = new File(commandLine.getOptionValue("storage-data-root-dir"));
            storageDataDirs.dataDir = new File(storageDataDirs.basedir, "data");
            storageDataDirs.commitlogDir = new File(storageDataDirs.basedir, "commitlog");
            storageDataDirs.savedcachesDir = new File(storageDataDirs.basedir, "saved_caches");
        }
        return storageDataDirs;
    }

    protected int installStorageNode(File storageBasedir, org.apache.commons.cli.CommandLine rhqctlCommandLine) throws IOException {
        try {
            String[] args;
            this.log.info((Object)"Preparing to install RHQ storage node.");
            this.putProperty("rhq.storage.basedir", storageBasedir.getAbsolutePath());
            CommandLine commandLine = this.getCommandLine("rhq-storage-installer", "--dir", storageBasedir.getAbsolutePath());
            if (rhqctlCommandLine.hasOption("storage-data-root-dir")) {
                StorageDataDirectories dataDirs = this.getCustomStorageDataDirectories(rhqctlCommandLine);
                commandLine.addArguments(new String[]{"--data", dataDirs.dataDir.getAbsolutePath()});
                commandLine.addArguments(new String[]{"--commitlog", dataDirs.commitlogDir.getAbsolutePath()});
                commandLine.addArguments(new String[]{"--saved-caches", dataDirs.savedcachesDir.getAbsolutePath()});
            }
            if (rhqctlCommandLine.hasOption("storage-config")) {
                args = this.toArray(this.loadStorageProperties(rhqctlCommandLine.getOptionValue("storage-config")));
                commandLine.addArguments(args);
            } else if (this.hasProperty("rhqctl.install.storage-config")) {
                args = this.toArray(this.loadStorageProperties(this.getProperty("rhqctl.install.storage-config")));
                commandLine.addArguments(args);
            }
            DefaultExecutor executor = new DefaultExecutor();
            executor.setWorkingDirectory(this.getBinDir());
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
            int exitCode = executor.execute(commandLine);
            this.log.info((Object)("The storage node installer has finished with an exit value of " + exitCode));
            return exitCode;
        }
        catch (IOException e) {
            this.log.error((Object)("An error occurred while running the storage installer: " + e.getMessage()));
            if (e.getMessage().toLowerCase().contains("exit value: 3")) {
                this.log.error((Object)"Try to point your root data directory via --storage-data-root-dir to a directory where you have read and write permissions.");
            }
            throw e;
        }
    }

    private Properties loadStorageProperties(String path) throws IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(new File(path)));
        return properties;
    }

    private String[] toArray(Properties properties) {
        String[] array = new String[properties.size() * 2];
        int i = 0;
        for (Object key : properties.keySet()) {
            array[i++] = "--" + (String)key;
            array[i++] = properties.getProperty((String)key);
        }
        return array;
    }

    private class StorageDataDirectories {
        public File basedir;
        public File dataDir;
        public File commitlogDir;
        public File savedcachesDir;

        private StorageDataDirectories() {
        }
    }
}

