/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.control.command;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.apache.commons.cli.Options;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.server.control.ControlCommand;
import org.rhq.server.control.RHQControlException;

public class Status
extends ControlCommand {
    private Options options = new Options().addOption(null, "storage", false, "Check status of RHQ storage node").addOption(null, "server", false, "Check status of RHQ server").addOption(null, "agent", false, "Check status of RHQ agent");

    @Override
    public String getName() {
        return "status";
    }

    @Override
    public String getDescription() {
        return "Check status of RHQ services";
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    protected void exec(org.apache.commons.cli.CommandLine commandLine) {
        try {
            if (commandLine.getOptions().length == 0) {
                if (this.isStorageInstalled()) {
                    this.checkStorageStatus();
                }
                if (this.isServerInstalled()) {
                    this.checkServerStatus();
                }
                if (this.isAgentInstalled()) {
                    this.checkAgentStatus();
                }
            } else {
                if (commandLine.hasOption("storage")) {
                    if (this.isStorageInstalled()) {
                        this.checkStorageStatus();
                    } else {
                        this.log.warn((Object)"It appears that the storage node is not installed. The --storage option will be ignored.");
                    }
                }
                if (commandLine.hasOption("server")) {
                    if (this.isServerInstalled()) {
                        this.checkServerStatus();
                    } else {
                        this.log.warn((Object)"It appears that the server is not installed. The --server option will be ignored.");
                    }
                }
                if (commandLine.hasOption("agent")) {
                    if (this.isAgentInstalled()) {
                        this.checkAgentStatus();
                    } else {
                        this.log.warn((Object)"It appears that the agent is not installed. The --agent option will be ignored.");
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RHQControlException("Failed to check statuses", e);
        }
    }

    private void checkStorageStatus() throws Exception {
        this.log.debug((Object)"Checking RHQ storage node status");
        if (this.isWindows()) {
            DefaultExecutor executor = new DefaultExecutor();
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
            executor.setWorkingDirectory(this.getBinDir());
            CommandLine commandLine = this.getCommandLine("rhq-storage", "status");
            try {
                executor.execute(commandLine);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to check storage service status", (Throwable)e);
            }
        } else {
            File storageBinDir = new File(this.getStorageBasedir(), "bin");
            File pidFile = new File(storageBinDir, "cassandra.pid");
            if (pidFile.exists()) {
                String pid = StreamUtil.slurp((Reader)new FileReader(pidFile));
                System.out.println(String.format("%-30s", "RHQ Storage Node") + " (pid " + String.format("%-7s", pid) + ") IS running");
            } else {
                System.out.println(String.format("%-30s", "RHQ Storage Node") + " (no pid file) IS NOT running");
            }
        }
    }

    private void checkServerStatus() throws Exception {
        this.log.debug((Object)"Checking RHQ server status");
        CommandLine commandLine = this.getCommandLine("rhq-server", "status");
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(this.getBinDir());
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        executor.execute(commandLine);
    }

    private void checkAgentStatus() throws Exception {
        block2: {
            this.log.debug((Object)"Checking RHQ agent status");
            File agentBinDir = new File(this.getAgentBasedir(), "bin");
            CommandLine commandLine = this.getCommandLine("rhq-agent-wrapper", "status");
            DefaultExecutor executor = new DefaultExecutor();
            executor.setWorkingDirectory(agentBinDir);
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
            try {
                executor.execute(commandLine);
            }
            catch (ExecuteException e) {
                if (this.isWindows()) break block2;
                throw e;
            }
        }
    }
}

