/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.control.command;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import org.apache.commons.cli.Options;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.server.control.RHQControlException;
import org.rhq.server.control.command.AbstractInstall;

public class Install
extends AbstractInstall {
    private final String AGENT_CONFIG_OPTION = "agent-config";
    private final String AGENT_PREFERENCE = "agent-preference";
    private final String AGENT_AUTOSTART_OPTION = "agent-auto-start";
    private final String SERVER_CONFIG_OPTION = "server-config";
    private Options options = new Options().addOption(null, "storage", false, "Install RHQ storage node. The install directory will be [" + this.getStorageBasedir() + "]. Note that this option implies --agent which means an agent will also be installed, if one is not yet installed.").addOption(null, "server", false, "Install RHQ server. If you have not yet installed an RHQ storage node somewhere in your network, you must specify --storage to install one.").addOption(null, "agent", false, "Install RHQ agent. The install directory will be [" + this.getAgentBasedir() + "]").addOption(null, "server-config", true, "An alternate properties file to use in place of the default rhq-server.properties").addOption(null, "agent-config", true, "An alternate XML file to use in place of the default agent-configuration.xml").addOption(null, "storage-config", true, "A properties file with keys that correspond to option names of the storage installer. Each property will be translated into an option that is passed to the storage installer.").addOption(null, "agent-preference", true, "An agent preference setting (whose argument is in the form 'name=value') to be set in the agent. More than one of these is allowed.").addOption(null, "agent-auto-start", true, "If an agent is to be installed it will, by default, also be started. However, if this option is set to false, the agent will not be started after it gets installed.").addOption(null, "storage-data-root-dir", true, "The root directory under which all storage data directories will be placed.");
    private static final String PREF_RHQ_AGENT_SECURITY_TOKEN = "rhq.agent.security-token";
    private static final String PREF_RHQ_AGENT_CONFIGURATION_SETUP_FLAG = "rhq.agent.configuration-setup-flag";
    private static final String PREF_RHQ_AGENT_AUTO_UPDATE_FLAG = "rhq.agent.agent-update.enabled";

    public Install() {
        this.options.getOption("agent-auto-start").setOptionalArg(true);
    }

    @Override
    public String getName() {
        return "install";
    }

    @Override
    public String getDescription() {
        return "Installs RHQ services.";
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    protected void exec(org.apache.commons.cli.CommandLine commandLine) {
        try {
            List<String> errors = this.validateOptions(commandLine);
            if (!errors.isEmpty()) {
                for (String error : errors) {
                    this.log.error((Object)error);
                }
                this.log.error((Object)"Exiting due to the previous errors");
                return;
            }
            if (!(commandLine.hasOption("storage") || commandLine.hasOption("server") || commandLine.hasOption("agent"))) {
                this.replaceServerPropertiesIfNecessary(commandLine);
                if (!this.isStorageInstalled()) {
                    this.installStorageNode(this.getStorageBasedir(), commandLine);
                } else if (this.isWindows()) {
                    this.installWindowsService(this.getBinDir(), "rhq-storage", false, true);
                }
                if (!this.isServerInstalled()) {
                    this.startRHQServerForInstallation();
                    this.runRHQServerInstaller();
                    this.waitForRHQServerToInitialize();
                } else if (this.isWindows()) {
                    this.installWindowsService(this.getBinDir(), "rhq-server", false, true);
                }
                if (!this.isAgentInstalled()) {
                    this.clearAgentPreferences();
                    File agentBasedir = this.getAgentBasedir();
                    this.installAgent(agentBasedir);
                    this.configureAgent(agentBasedir, commandLine);
                    boolean start = Boolean.parseBoolean(commandLine.getOptionValue("agent-auto-start", "true"));
                    if (start) {
                        this.startAgent(agentBasedir, true);
                    } else {
                        this.log.info((Object)"The agent was installed but was told not to start automatically.");
                    }
                } else if (this.isWindows()) {
                    boolean start = Boolean.parseBoolean(commandLine.getOptionValue("agent-auto-start", "true"));
                    this.installWindowsService(new File(this.getAgentBasedir(), "bin"), "rhq-agent-wrapper", false, start);
                }
            } else {
                File agentBasedir;
                if (commandLine.hasOption("storage")) {
                    if (this.isStorageInstalled()) {
                        this.log.info((Object)("The RHQ storage node is already installed in " + new File(this.getBaseDir(), "storage")));
                        if (this.isWindows()) {
                            this.installWindowsService(this.getBinDir(), "rhq-storage", false, true);
                        } else {
                            this.log.info((Object)"Skipping storage node installation.");
                        }
                    } else {
                        this.replaceServerPropertiesIfNecessary(commandLine);
                        this.installStorageNode(this.getStorageBasedir(), commandLine);
                    }
                    if (!this.isAgentInstalled()) {
                        agentBasedir = this.getAgentBasedir();
                        this.clearAgentPreferences();
                        this.installAgent(agentBasedir);
                        this.configureAgent(agentBasedir, commandLine);
                        if (Boolean.parseBoolean(commandLine.getOptionValue("agent-auto-start", "true"))) {
                            this.startAgent(agentBasedir, true);
                        } else {
                            this.log.info((Object)"The agent was installed but was told not to start automatically.");
                        }
                    }
                }
                if (commandLine.hasOption("server")) {
                    if (this.isServerInstalled()) {
                        this.log.warn((Object)"The RHQ server is already installed.");
                        if (this.isWindows()) {
                            this.installWindowsService(this.getBinDir(), "rhq-server", false, true);
                        } else {
                            this.log.info((Object)"Skipping server installation.");
                        }
                    } else {
                        this.replaceServerPropertiesIfNecessary(commandLine);
                        this.startRHQServerForInstallation();
                        this.runRHQServerInstaller();
                        this.waitForRHQServerToInitialize();
                    }
                }
                if (commandLine.hasOption("agent")) {
                    if (this.isAgentInstalled() && !commandLine.hasOption("storage")) {
                        this.log.info((Object)("The RHQ agent is already installed in [" + this.getAgentBasedir() + "]"));
                        boolean start = Boolean.parseBoolean(commandLine.getOptionValue("agent-auto-start", "true"));
                        if (this.isWindows()) {
                            this.installWindowsService(new File(this.getAgentBasedir(), "bin"), "rhq-agent-wrapper", false, start);
                        } else {
                            this.log.info((Object)"Skipping agent installation.");
                        }
                    } else {
                        agentBasedir = this.getAgentBasedir();
                        this.clearAgentPreferences();
                        this.installAgent(agentBasedir);
                        this.configureAgent(agentBasedir, commandLine);
                        if (Boolean.parseBoolean(commandLine.getOptionValue("agent-auto-start", "true"))) {
                            this.startAgent(agentBasedir, true);
                        } else {
                            this.log.info((Object)"The agent was installed but was told not to start automatically.");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RHQControlException("An error occurred while executing the install command", e);
        }
    }

    private List<String> validateOptions(org.apache.commons.cli.CommandLine commandLine) {
        LinkedList<String> errors = new LinkedList<String>();
        if (!(commandLine.hasOption("storage") || commandLine.hasOption("server") || commandLine.hasOption("agent"))) {
            this.validateCustomStorageDataDirectories(commandLine, errors);
            if (commandLine.hasOption("server-config") && !this.isServerInstalled()) {
                File serverConfig = new File(commandLine.getOptionValue("server-config"));
                this.validateServerConfigOption(serverConfig, errors);
            }
            if (commandLine.hasOption("agent-config") && !this.isAgentInstalled()) {
                File agentConfig = new File(commandLine.getOptionValue("agent-config"));
                this.validateAgentConfigOption(agentConfig, errors);
            }
            if (commandLine.hasOption("storage-config") && !this.isStorageInstalled()) {
                File storageConfig = new File(commandLine.getOptionValue("storage-config"));
                this.validateStorageConfigOption(storageConfig, errors);
            }
        } else {
            File agentConfig;
            if (commandLine.hasOption("storage")) {
                if (!this.isStorageInstalled() && commandLine.hasOption("storage-config")) {
                    File storageConfig = new File(commandLine.getOptionValue("storage-config"));
                    this.validateStorageConfigOption(storageConfig, errors);
                }
                if (!this.isAgentInstalled() && commandLine.hasOption("agent-config")) {
                    agentConfig = new File(commandLine.getOptionValue("agent-config"));
                    this.validateAgentConfigOption(agentConfig, errors);
                }
                this.validateCustomStorageDataDirectories(commandLine, errors);
            }
            if (commandLine.hasOption("server") && !this.isStorageInstalled() && commandLine.hasOption("server-config")) {
                File serverConfig = new File(commandLine.getOptionValue("server-config"));
                this.validateServerConfigOption(serverConfig, errors);
            }
            if (commandLine.hasOption("agent") && !this.isAgentInstalled() && commandLine.hasOption("agent-config")) {
                agentConfig = new File(commandLine.getOptionValue("agent-config"));
                this.validateAgentConfigOption(agentConfig, errors);
            }
        }
        return errors;
    }

    private void validateServerConfigOption(File serverConfig, List<String> errors) {
        if (!serverConfig.exists()) {
            errors.add("The --server-config option has as its value a file that does not exist [" + serverConfig.getAbsolutePath() + "]");
        } else if (serverConfig.isDirectory()) {
            errors.add("The --server-config option has as its value a path that is a directory [" + serverConfig.getAbsolutePath() + "]. It should be a properties file that replaces the " + "default rhq-server.properties");
        }
    }

    private void validateAgentConfigOption(File agentConfig, List<String> errors) {
        if (!agentConfig.exists()) {
            errors.add("The --agent-config option has as its value a file that does not exist [" + agentConfig.getAbsolutePath() + "]");
        } else if (agentConfig.isDirectory()) {
            errors.add("The --agent-config option has as its value a path that is a directory [" + agentConfig.getAbsolutePath() + "]. It should be an XML file that replaces the default " + "agent-configuration.xml");
        }
    }

    private void validateStorageConfigOption(File storageConfig, List<String> errors) {
        if (!storageConfig.exists()) {
            errors.add("The --storage-config option has as its value a file that does not exist [" + storageConfig.getAbsolutePath() + "]");
        } else if (storageConfig.isDirectory()) {
            errors.add("The --storage-config option has as its value a path that is a directory [" + storageConfig.getAbsolutePath() + "]. It should be a properties file with keys that " + "correspond to options for the storage installer.");
        }
    }

    private void installAgent(File agentBasedir) throws IOException {
        try {
            this.log.info((Object)"Installing RHQ agent");
            File agentInstallerJar = this.getAgentInstaller();
            this.putProperty("rhq.agent.basedir", agentBasedir.getAbsolutePath());
            CommandLine commandLine = new CommandLine("java").addArgument("-jar").addArgument(agentInstallerJar.getAbsolutePath()).addArgument("--install=" + agentBasedir.getParentFile().getAbsolutePath()).addArgument("--log=" + new File(this.getLogDir(), "rhq-agent-update.log"));
            DefaultExecutor executor = new DefaultExecutor();
            executor.setWorkingDirectory(this.getBaseDir());
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
            int exitValue = executor.execute(commandLine);
            this.log.info((Object)("The agent installer finished running with exit value " + exitValue));
        }
        catch (IOException e) {
            this.log.error((Object)("An error occurred while running the agent installer: " + e.getMessage()));
            throw e;
        }
    }

    private File getAgentInstaller() {
        File agentDownloadDir = new File(this.getBaseDir(), "modules/org/rhq/server-startup/main/deployments/rhq.ear/rhq-downloads/rhq-agent");
        return agentDownloadDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().contains("rhq-enterprise-agent");
            }
        })[0];
    }

    private void configureAgent(File agentBasedir, org.apache.commons.cli.CommandLine commandLine) throws Exception {
        try {
            File agentConfDir = new File(agentBasedir, "conf");
            File agentConfigFile = new File(agentConfDir, "agent-configuration.xml");
            if (commandLine.hasOption("agent-config")) {
                this.log.info((Object)("Configuring the RHQ agent with custom configuration file: " + commandLine.getOptionValue("agent-config")));
                this.replaceAgentConfigIfNecessary(commandLine);
            } else {
                this.log.info((Object)("Configuring the RHQ agent with default configuration file: " + agentConfigFile));
            }
            Preferences preferencesNode = this.getAgentPreferences();
            String securityToken = preferencesNode.get(PREF_RHQ_AGENT_SECURITY_TOKEN, null);
            ByteArrayOutputStream rawConfigFileData = new ByteArrayOutputStream();
            StreamUtil.copy((InputStream)new FileInputStream(agentConfigFile), (OutputStream)rawConfigFileData, (boolean)true);
            String newConfig = rawConfigFileData.toString().replace("${rhq.agent.preferences-node}", "default");
            ByteArrayInputStream newConfigInputStream = new ByteArrayInputStream(newConfig.getBytes());
            Preferences.importPreferences(newConfigInputStream);
            if (securityToken != null) {
                preferencesNode.put(PREF_RHQ_AGENT_SECURITY_TOKEN, securityToken);
            }
            this.overrideAgentPreferences(commandLine, preferencesNode);
            String agentUpdateEnabledPref = PREF_RHQ_AGENT_AUTO_UPDATE_FLAG;
            preferencesNode.putBoolean(agentUpdateEnabledPref, false);
            String setupPref = PREF_RHQ_AGENT_CONFIGURATION_SETUP_FLAG;
            preferencesNode.putBoolean(setupPref, true);
            preferencesNode.flush();
            preferencesNode.sync();
            this.log.info((Object)"Finished configuring the agent");
        }
        catch (Exception e) {
            this.log.error((Object)("An error occurred while configuring the agent: " + e.getMessage()));
            throw e;
        }
    }

    private void overrideAgentPreferences(org.apache.commons.cli.CommandLine commandLine, Preferences preferencesNode) {
        String[] customPrefs = commandLine.getOptionValues("agent-preference");
        if (customPrefs != null && customPrefs.length > 0) {
            for (String nameValuePairString : customPrefs) {
                String[] nameValuePairArray = nameValuePairString.split("=", 2);
                String prefName = nameValuePairArray[0];
                String prefValue = nameValuePairArray.length == 1 ? "true" : nameValuePairArray[1];
                this.log.info((Object)("Overriding agent preference: " + prefName + "=" + prefValue));
                preferencesNode.put(prefName, prefValue);
            }
        }
    }

    private void clearAgentPreferences() throws Exception {
        this.log.info((Object)"Removing any existing agent preferences from default preference node");
        Preferences agentPrefs = this.getAgentPreferences();
        String[] prefKeys = null;
        try {
            prefKeys = agentPrefs.keys();
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to get agent preferences - cannot clear them: " + e));
        }
        if (prefKeys != null && prefKeys.length > 0) {
            for (String prefKey : prefKeys) {
                if (prefKey.equals(PREF_RHQ_AGENT_SECURITY_TOKEN)) continue;
                agentPrefs.remove(prefKey);
            }
            agentPrefs.flush();
            Preferences.userRoot().sync();
        }
    }

    private Preferences getAgentPreferences() {
        Preferences agentPrefs = Preferences.userRoot().node("rhq-agent/default");
        return agentPrefs;
    }

    private void replaceServerPropertiesIfNecessary(org.apache.commons.cli.CommandLine commandLine) {
        if (commandLine.hasOption("server-config") && !this.isServerInstalled()) {
            this.replaceServerProperties(new File(commandLine.getOptionValue("server-config")));
        }
    }

    private void replaceServerProperties(File newServerProperties) {
        File defaultServerProps = new File(System.getProperty("rhq.server.properties-file"));
        defaultServerProps.delete();
        try {
            StreamUtil.copy((Reader)new FileReader(newServerProperties), (Writer)new FileWriter(defaultServerProps));
        }
        catch (IOException e) {
            throw new RHQControlException("Failed to replace " + defaultServerProps + " with " + newServerProperties, e);
        }
    }

    private void replaceAgentConfigIfNecessary(org.apache.commons.cli.CommandLine commandLine) {
        if (!commandLine.hasOption("agent-config")) {
            return;
        }
        File newConfigFile = new File(commandLine.getOptionValue("agent-config"));
        File confDir = new File(this.getAgentBasedir(), "conf");
        File defaultConfigFile = new File(confDir, "agent-configuration.xml");
        defaultConfigFile.delete();
        try {
            StreamUtil.copy((Reader)new FileReader(newConfigFile), (Writer)new FileWriter(defaultConfigFile));
        }
        catch (IOException e) {
            throw new RHQControlException("Failed to replace " + defaultConfigFile + " with " + newConfigFile);
        }
    }
}

