/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.base.Function;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.composite.MeasurementDataNumericHighLowComposite;
import org.rhq.server.metrics.ArithmeticMeanCalculator;
import org.rhq.server.metrics.Buckets;
import org.rhq.server.metrics.ComputeAggregate;
import org.rhq.server.metrics.ComputeRawAggregate;
import org.rhq.server.metrics.DateTimeService;
import org.rhq.server.metrics.MetricsConfiguration;
import org.rhq.server.metrics.MetricsDAO;
import org.rhq.server.metrics.RawDataInsertedCallback;
import org.rhq.server.metrics.StorageClientThreadFactory;
import org.rhq.server.metrics.StorageResultSetFuture;
import org.rhq.server.metrics.aggregation.Aggregator;
import org.rhq.server.metrics.domain.AggregateNumericMetric;
import org.rhq.server.metrics.domain.AggregateType;
import org.rhq.server.metrics.domain.MetricsIndexEntry;
import org.rhq.server.metrics.domain.MetricsTable;
import org.rhq.server.metrics.domain.RawNumericMetric;

public class MetricsServer {
    private final Log log = LogFactory.getLog(MetricsServer.class);
    private DateTimeService dateTimeService = new DateTimeService();
    private MetricsDAO dao;
    private MetricsConfiguration configuration;
    private boolean pastAggregationMissed;
    private Long mostRecentRawDataPriorToStartup;
    private AtomicLong totalAggregationTime = new AtomicLong();
    private int numAggregationWorkers = 4;
    private ListeningExecutorService aggregationWorkers;
    private int aggregationBatchSize = Integer.parseInt(System.getProperty("rhq.metrics.aggregation.batch-size", "5"));
    private int parallelism = Integer.parseInt(System.getProperty("rhq.metrics.aggregation.parallelism", "3"));
    private boolean useAsyncAggregation = Boolean.valueOf(System.getProperty("rhq.metrics.aggregation.async", "true"));

    public void setDAO(MetricsDAO dao) {
        this.dao = dao;
    }

    public void setConfiguration(MetricsConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public int getAggregationBatchSize() {
        return this.aggregationBatchSize;
    }

    public void setAggregationBatchSize(int batchSize) {
        this.aggregationBatchSize = batchSize;
    }

    public int getAggregationParallelism() {
        return this.parallelism;
    }

    public void setAggregationParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public int getNumAggregationWorkers() {
        return this.numAggregationWorkers;
    }

    public void setUseAsyncAggregation(boolean useAsyncAggregation) {
        this.useAsyncAggregation = useAsyncAggregation;
    }

    public void init() {
        if (this.log.isDebugEnabled() && this.useAsyncAggregation) {
            this.log.debug((Object)"Async aggregation is enabled");
        }
        this.numAggregationWorkers = Integer.parseInt(System.getProperty("rhq.metrics.aggregation.workers", "4"));
        if (this.numAggregationWorkers < 2) {
            this.numAggregationWorkers = 2;
        }
        this.aggregationWorkers = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this.numAggregationWorkers, new StorageClientThreadFactory()));
        this.determineMostRecentRawDataSinceLastShutdown();
    }

    private void determineMostRecentRawDataSinceLastShutdown() {
        DateTime previousHour = this.currentHour().minus((ReadableDuration)this.configuration.getRawTimeSliceDuration());
        DateTime oldestRawTime = previousHour.minus(this.configuration.getRawRetention());
        ResultSet resultSet = this.dao.setFindTimeSliceForIndex(MetricsTable.ONE_HOUR, previousHour.getMillis());
        Row row = resultSet.one();
        while (row == null && previousHour.compareTo((ReadableInstant)oldestRawTime) > 0) {
            previousHour = previousHour.minus((ReadableDuration)this.configuration.getRawTimeSliceDuration());
            resultSet = this.dao.setFindTimeSliceForIndex(MetricsTable.ONE_HOUR, previousHour.getMillis());
            row = resultSet.one();
        }
        if (row == null) {
            this.log.info((Object)"Did not find any raw data in the storage database since the last server shutdown. Raw data aggregate computations are up to date.");
        } else {
            this.mostRecentRawDataPriorToStartup = row.getDate(0).getTime();
            if (this.roundDownToHour(this.mostRecentRawDataPriorToStartup).equals((Object)this.currentHour())) {
                this.log.info((Object)"Raw data aggregate computations are up to date");
            } else {
                this.pastAggregationMissed = true;
                this.log.info((Object)("Found the most recently inserted raw data prior to this server start up with a timestamp of [" + this.mostRecentRawDataPriorToStartup + "]. Aggregates for this data will be computed the " + "next time the aggregation job runs."));
            }
        }
    }

    private boolean hasTimeSliceEnded(DateTime startTime, Duration duration) {
        DateTime endTime = startTime.plus((ReadableDuration)duration);
        return DateTimeComparator.getInstance().compare((Object)this.currentHour(), (Object)endTime) >= 0;
    }

    protected DateTime currentHour() {
        return this.dateTimeService.getTimeSlice(this.dateTimeService.now(), this.configuration.getRawTimeSliceDuration());
    }

    protected DateTime roundDownToHour(long timestamp) {
        return this.dateTimeService.getTimeSlice(new DateTime(timestamp), this.configuration.getRawTimeSliceDuration());
    }

    public void shutdown() {
        this.aggregationWorkers.shutdown();
    }

    public RawNumericMetric findLatestValueForResource(int scheduleId) {
        this.log.debug((Object)("Querying for most recent raw metrics for [scheduleId: " + scheduleId + "]"));
        return this.dao.findLatestRawMetric(scheduleId);
    }

    public long getTotalAggregationTime() {
        return this.totalAggregationTime.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<MeasurementDataNumericHighLowComposite> findDataForResource(int scheduleId, long beginTime, long endTime, int numberOfBuckets) {
        Stopwatch stopwatch = new Stopwatch().start();
        try {
            DateTime begin = new DateTime(beginTime);
            if (this.dateTimeService.isInRawDataRange(begin)) {
                Iterable<RawNumericMetric> metrics = this.dao.findRawMetrics(scheduleId, beginTime, endTime);
                List<MeasurementDataNumericHighLowComposite> list = this.createRawComposites(metrics, beginTime, endTime, numberOfBuckets);
                return list;
            }
            Iterable<AggregateNumericMetric> metrics = null;
            if (this.dateTimeService.isIn1HourDataRange(begin)) {
                metrics = this.dao.findOneHourMetrics(scheduleId, beginTime, endTime);
            } else if (this.dateTimeService.isIn6HourDataRnage(begin)) {
                metrics = this.dao.findSixHourMetrics(scheduleId, beginTime, endTime);
            } else if (this.dateTimeService.isIn24HourDataRnage(begin)) {
                metrics = this.dao.findTwentyFourHourMetrics(scheduleId, beginTime, endTime);
            } else {
                throw new IllegalArgumentException("beginTime[" + beginTime + "] is outside the accepted range.");
            }
            List<MeasurementDataNumericHighLowComposite> list = this.createComposites(metrics, beginTime, endTime, numberOfBuckets);
            return list;
        }
        finally {
            stopwatch.stop();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Retrieved resource data for [scheduleId: " + scheduleId + ", beginTime: " + beginTime + ", endTime: " + endTime + "] in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MeasurementDataNumericHighLowComposite> findDataForGroup(List<Integer> scheduleIds, long beginTime, long endTime, int numberOfBuckets) {
        Stopwatch stopwatch = new Stopwatch().start();
        try {
            DateTime begin = new DateTime(beginTime);
            if (this.dateTimeService.isInRawDataRange(begin)) {
                Iterable<RawNumericMetric> metrics = this.dao.findRawMetrics(scheduleIds, beginTime, endTime);
                List<MeasurementDataNumericHighLowComposite> list = this.createRawComposites(metrics, beginTime, endTime, numberOfBuckets);
                return list;
            }
            Iterable<AggregateNumericMetric> metrics = null;
            if (this.dateTimeService.isIn1HourDataRange(begin)) {
                metrics = this.dao.findOneHourMetrics(scheduleIds, beginTime, endTime);
            } else if (this.dateTimeService.isIn6HourDataRnage(begin)) {
                metrics = this.dao.findSixHourMetrics(scheduleIds, beginTime, endTime);
            } else if (this.dateTimeService.isIn24HourDataRnage(begin)) {
                metrics = this.dao.findTwentyFourHourMetrics(scheduleIds, beginTime, endTime);
            } else {
                throw new IllegalArgumentException("beginTime[" + beginTime + "] is outside the accepted range.");
            }
            List<MeasurementDataNumericHighLowComposite> list = this.createComposites(metrics, beginTime, endTime, numberOfBuckets);
            return list;
        }
        finally {
            stopwatch.stop();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Retrieved resource group data for [scheduleIds: " + scheduleIds + ", beginTime: " + beginTime + ", endTime: " + endTime + "] in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AggregateNumericMetric getSummaryAggregate(int scheduleId, long beginTime, long endTime) {
        Stopwatch stopwatch = new Stopwatch().start();
        try {
            DateTime begin = new DateTime(beginTime);
            if (this.dateTimeService.isInRawDataRange(begin)) {
                Iterable<RawNumericMetric> metrics = this.dao.findRawMetrics(scheduleId, beginTime, endTime);
                AggregateNumericMetric aggregateNumericMetric = this.calculateAggregatedRaw(metrics, beginTime);
                return aggregateNumericMetric;
            }
            Iterable<AggregateNumericMetric> metrics = null;
            if (this.dateTimeService.isIn1HourDataRange(begin)) {
                metrics = this.dao.findOneHourMetrics(scheduleId, beginTime, endTime);
            } else if (this.dateTimeService.isIn6HourDataRnage(begin)) {
                metrics = this.dao.findSixHourMetrics(scheduleId, beginTime, endTime);
            } else if (this.dateTimeService.isIn24HourDataRnage(begin)) {
                metrics = this.dao.findTwentyFourHourMetrics(scheduleId, beginTime, endTime);
            } else {
                throw new IllegalArgumentException("beginTime[" + beginTime + "] is outside the accepted range.");
            }
            AggregateNumericMetric aggregateNumericMetric = this.calculateAggregate(metrics, beginTime);
            return aggregateNumericMetric;
        }
        finally {
            stopwatch.stop();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Finished calculating resource summary aggregate for [scheduleId: " + scheduleId + ", beginTime: " + beginTime + ", endTime: " + endTime + "] in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<AggregateNumericMetric> getSummaryAggregateAsync(int scheduleId, long beginTime, long endTime) {
        long start = System.currentTimeMillis();
        try {
            StorageResultSetFuture queryFuture;
            DateTime begin;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Calculating resource summary aggregate (async) for [scheduleId: " + scheduleId + ", beginTime: " + beginTime + ", endTime: " + endTime + "]"));
            }
            if (this.dateTimeService.isInRawDataRange(begin = new DateTime(beginTime))) {
                StorageResultSetFuture queryFuture2 = this.dao.findRawMetricsAsync(scheduleId, beginTime, endTime);
                ListenableFuture listenableFuture = Futures.transform((ListenableFuture)queryFuture2, (Function)new ComputeRawAggregate(beginTime));
                return listenableFuture;
            }
            if (this.dateTimeService.isIn1HourDataRange(begin)) {
                queryFuture = this.dao.findOneHourMetricsAsync(scheduleId, beginTime, endTime);
            } else if (this.dateTimeService.isIn6HourDataRnage(begin)) {
                queryFuture = this.dao.findSixHourMetricsAsync(scheduleId, beginTime, endTime);
            } else if (this.dateTimeService.isIn24HourDataRnage(begin)) {
                queryFuture = this.dao.findTwentyFourHourMetricsAsync(scheduleId, beginTime, endTime);
            } else {
                throw new IllegalArgumentException("beginTime[" + beginTime + "] is outside the accepted range.");
            }
            ListenableFuture listenableFuture = Futures.transform((ListenableFuture)queryFuture, (Function)new ComputeAggregate(beginTime));
            return listenableFuture;
        }
        finally {
            long end = System.currentTimeMillis();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Finished calculating resource summary aggregate (async) in " + (end - start) + " ms"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AggregateNumericMetric getSummaryAggregate(List<Integer> scheduleIds, long beginTime, long endTime) {
        Stopwatch stopwatch = new Stopwatch().start();
        try {
            DateTime begin = new DateTime(beginTime);
            if (this.dateTimeService.isInRawDataRange(new DateTime(beginTime))) {
                Iterable<RawNumericMetric> metrics = this.dao.findRawMetrics(scheduleIds, beginTime, endTime);
                AggregateNumericMetric aggregateNumericMetric = this.calculateAggregatedRaw(metrics, beginTime);
                return aggregateNumericMetric;
            }
            Iterable<AggregateNumericMetric> metrics = null;
            if (this.dateTimeService.isIn1HourDataRange(begin)) {
                metrics = this.dao.findOneHourMetrics(scheduleIds, beginTime, endTime);
            } else if (this.dateTimeService.isIn6HourDataRnage(begin)) {
                metrics = this.dao.findSixHourMetrics(scheduleIds, beginTime, endTime);
            } else if (this.dateTimeService.isIn24HourDataRnage(begin)) {
                metrics = this.dao.findTwentyFourHourMetrics(scheduleIds, beginTime, endTime);
            } else {
                throw new IllegalArgumentException("beginTime[" + beginTime + "] is outside the accepted range.");
            }
            AggregateNumericMetric aggregateNumericMetric = this.calculateAggregate(metrics, beginTime);
            return aggregateNumericMetric;
        }
        finally {
            stopwatch.stop();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Finished calculating group summary aggregate for [scheduleIds: " + scheduleIds + ", beginTime: " + beginTime + ", endTime: " + endTime + "] in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
            }
        }
    }

    private List<MeasurementDataNumericHighLowComposite> createRawComposites(Iterable<RawNumericMetric> metrics, long beginTime, long endTime, int numberOfBuckets) {
        Buckets buckets = new Buckets(beginTime, endTime, numberOfBuckets);
        for (RawNumericMetric metric : metrics) {
            buckets.insert(metric.getTimestamp(), metric.getValue(), metric.getValue(), metric.getValue());
        }
        ArrayList<MeasurementDataNumericHighLowComposite> data = new ArrayList<MeasurementDataNumericHighLowComposite>();
        for (int i = 0; i < buckets.getNumDataPoints(); ++i) {
            Buckets.Bucket bucket = buckets.get(i);
            data.add(new MeasurementDataNumericHighLowComposite(bucket.getStartTime(), bucket.getAvg(), bucket.getMax(), bucket.getMin()));
        }
        return data;
    }

    private List<MeasurementDataNumericHighLowComposite> createComposites(Iterable<AggregateNumericMetric> metrics, long beginTime, long endTime, int numberOfBuckets) {
        Buckets buckets = new Buckets(beginTime, endTime, numberOfBuckets);
        for (AggregateNumericMetric metric : metrics) {
            buckets.insert(metric.getTimestamp(), metric.getAvg(), metric.getMin(), metric.getMax());
        }
        ArrayList<MeasurementDataNumericHighLowComposite> data = new ArrayList<MeasurementDataNumericHighLowComposite>();
        for (int i = 0; i < buckets.getNumDataPoints(); ++i) {
            Buckets.Bucket bucket = buckets.get(i);
            data.add(new MeasurementDataNumericHighLowComposite(bucket.getStartTime(), bucket.getAvg(), bucket.getMax(), bucket.getMin()));
        }
        return data;
    }

    public void addNumericData(final Set<MeasurementDataNumeric> dataSet, final RawDataInsertedCallback callback) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Inserting " + dataSet.size() + " raw metrics"));
            }
            final long startTime = this.dateTimeService.now().getMillis();
            final AtomicInteger remainingInserts = new AtomicInteger(dataSet.size());
            for (final MeasurementDataNumeric data : dataSet) {
                StorageResultSetFuture resultSetFuture = this.dao.insertRawData(data);
                Futures.addCallback((ListenableFuture)resultSetFuture, (FutureCallback)new FutureCallback<ResultSet>(){

                    public void onSuccess(ResultSet rows) {
                        MetricsServer.this.updateMetricsIndex(data, dataSet.size(), remainingInserts, startTime, callback);
                    }

                    public void onFailure(Throwable throwable) {
                        if (MetricsServer.this.log.isDebugEnabled()) {
                            MetricsServer.this.log.error((Object)("An error occurred while inserting raw data " + data), throwable);
                        } else {
                            MetricsServer.this.log.error((Object)("An error occurred while inserting raw data " + data + ": " + throwable.getClass().getName() + ": " + throwable.getMessage()));
                        }
                        callback.onFailure(throwable);
                    }
                }, (Executor)this.aggregationWorkers);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"An error occurred while inserting raw numeric data ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    void updateMetricsIndex(final MeasurementDataNumeric rawData, final int total, final AtomicInteger remainingInserts, final long startTime, final RawDataInsertedCallback callback) {
        long timeSlice = this.dateTimeService.getTimeSlice(new DateTime(rawData.getTimestamp()), this.configuration.getRawTimeSliceDuration()).getMillis();
        StorageResultSetFuture resultSetFuture = this.dao.updateMetricsIndex(MetricsTable.ONE_HOUR, rawData.getScheduleId(), timeSlice);
        Futures.addCallback((ListenableFuture)resultSetFuture, (FutureCallback)new FutureCallback<ResultSet>(){

            public void onSuccess(ResultSet rows) {
                callback.onSuccess(rawData);
                if (remainingInserts.decrementAndGet() == 0) {
                    long endTime = System.currentTimeMillis();
                    if (MetricsServer.this.log.isDebugEnabled()) {
                        MetricsServer.this.log.debug((Object)("Finished inserting " + total + " raw metrics in " + (endTime - startTime) + " ms"));
                    }
                    callback.onFinish();
                }
            }

            public void onFailure(Throwable throwable) {
                MetricsServer.this.log.error((Object)("An error occurred while trying to update " + (Object)((Object)MetricsTable.INDEX) + " for raw data " + rawData));
                callback.onFailure(throwable);
            }
        }, (Executor)this.aggregationWorkers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<AggregateNumericMetric> calculateAggregates() {
        Stopwatch stopwatch = new Stopwatch().start();
        try {
            DateTime theHour = this.currentHour();
            if (this.useAsyncAggregation) {
                if (this.pastAggregationMissed) {
                    DateTime missedHour = this.roundDownToHour(this.mostRecentRawDataPriorToStartup);
                    new Aggregator(this.aggregationWorkers, this.dao, this.configuration, this.dateTimeService, missedHour, this.aggregationBatchSize, this.parallelism).run();
                    this.pastAggregationMissed = false;
                }
                DateTime timeSlice = theHour.minus((ReadableDuration)this.configuration.getRawTimeSliceDuration());
                Set<AggregateNumericMetric> set = new Aggregator(this.aggregationWorkers, this.dao, this.configuration, this.dateTimeService, timeSlice, this.aggregationBatchSize, this.parallelism).run();
                return set;
            }
            if (this.pastAggregationMissed) {
                this.calculateAggregates(this.roundDownToHour(this.mostRecentRawDataPriorToStartup).plusHours(1).getMillis());
                this.pastAggregationMissed = false;
            }
            List<AggregateNumericMetric> list = this.calculateAggregates(theHour.getMillis());
            return list;
        }
        finally {
            stopwatch.stop();
            this.totalAggregationTime.addAndGet(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            this.log.info((Object)("Finished metrics aggregation in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
        }
    }

    private List<AggregateNumericMetric> calculateAggregates(long startTime) {
        List<AggregateNumericMetric> updatedSchedules;
        DateTime dt = new DateTime(startTime);
        DateTime currentHour = this.dateTimeService.getTimeSlice(dt, this.configuration.getRawTimeSliceDuration());
        DateTime lastHour = currentHour.minus((ReadableDuration)this.configuration.getRawTimeSliceDuration());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Starting aggregation for time slice " + lastHour));
        }
        long sixHourTimeSlice = this.dateTimeService.getTimeSlice(lastHour, this.configuration.getOneHourTimeSliceDuration()).getMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("six hour time slice = " + new Date(sixHourTimeSlice)));
        }
        long twentyFourHourTimeSlice = this.dateTimeService.getTimeSlice(lastHour, this.configuration.getSixHourTimeSliceDuration()).getMillis();
        List<AggregateNumericMetric> newOneHourAggregates = null;
        newOneHourAggregates = updatedSchedules = this.aggregateRawData(lastHour);
        if (!updatedSchedules.isEmpty()) {
            this.dao.deleteMetricsIndexEntries(MetricsTable.ONE_HOUR, lastHour.getMillis());
            this.updateMetricsIndex(MetricsTable.SIX_HOUR, updatedSchedules, this.configuration.getOneHourTimeSliceDuration());
        }
        if (!(updatedSchedules = this.calculateAggregates(MetricsTable.ONE_HOUR, MetricsTable.SIX_HOUR, sixHourTimeSlice, this.configuration.getOneHourTimeSliceDuration())).isEmpty()) {
            this.dao.deleteMetricsIndexEntries(MetricsTable.SIX_HOUR, sixHourTimeSlice);
            this.updateMetricsIndex(MetricsTable.TWENTY_FOUR_HOUR, updatedSchedules, this.configuration.getSixHourTimeSliceDuration());
        }
        if (!(updatedSchedules = this.calculateAggregates(MetricsTable.SIX_HOUR, MetricsTable.TWENTY_FOUR_HOUR, twentyFourHourTimeSlice, this.configuration.getSixHourTimeSliceDuration())).isEmpty()) {
            this.dao.deleteMetricsIndexEntries(MetricsTable.TWENTY_FOUR_HOUR, twentyFourHourTimeSlice);
        }
        return newOneHourAggregates;
    }

    private void updateMetricsIndex(MetricsTable bucket, Iterable<AggregateNumericMetric> metrics, Duration duration) {
        TreeMap<Integer, Long> updates = new TreeMap<Integer, Long>();
        for (AggregateNumericMetric metric : metrics) {
            updates.put(metric.getScheduleId(), this.dateTimeService.getTimeSlice(new DateTime(metric.getTimestamp()), duration).getMillis());
        }
        this.dao.updateMetricsIndex(bucket, updates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AggregateNumericMetric> aggregateRawData(DateTime theHour) {
        long start = System.currentTimeMillis();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Preparing to aggregate raw data. Time slice start time is [" + theHour + "] and the end time is [" + theHour.plus((ReadableDuration)this.configuration.getRawTimeSliceDuration()) + "]"));
            }
            Iterable<MetricsIndexEntry> indexEntries = this.dao.findMetricsIndexEntries(MetricsTable.ONE_HOUR, theHour.getMillis());
            ArrayList<AggregateNumericMetric> oneHourMetrics = new ArrayList<AggregateNumericMetric>();
            for (MetricsIndexEntry indexEntry : indexEntries) {
                DateTime startTime = indexEntry.getTime();
                DateTime endTime = startTime.plus((ReadableDuration)this.configuration.getRawTimeSliceDuration());
                Iterable<RawNumericMetric> rawMetrics = this.dao.findRawMetrics(indexEntry.getScheduleId(), startTime.getMillis(), endTime.getMillis());
                AggregateNumericMetric aggregatedRaw = this.calculateAggregatedRaw(rawMetrics, startTime.getMillis());
                aggregatedRaw.setScheduleId(indexEntry.getScheduleId());
                oneHourMetrics.add(aggregatedRaw);
            }
            for (AggregateNumericMetric metric : oneHourMetrics) {
                this.dao.insertOneHourData(metric.getScheduleId(), metric.getTimestamp(), AggregateType.MIN, metric.getMin());
                this.dao.insertOneHourData(metric.getScheduleId(), metric.getTimestamp(), AggregateType.MAX, metric.getMax());
                this.dao.insertOneHourData(metric.getScheduleId(), metric.getTimestamp(), AggregateType.AVG, metric.getAvg());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Finished computing and inserting " + oneHourMetrics.size() + " aggregates into table [" + (Object)((Object)MetricsTable.ONE_HOUR) + "]"));
            }
            ArrayList<AggregateNumericMetric> arrayList = oneHourMetrics;
            return arrayList;
        }
        finally {
            long end = System.currentTimeMillis();
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Finished computing aggregates for table [" + (Object)((Object)MetricsTable.RAW) + "]" + (end - start) + " ms"));
            }
        }
    }

    private AggregateNumericMetric calculateAggregatedRaw(Iterable<RawNumericMetric> rawMetrics, long timestamp) {
        double min;
        double max = min = Double.NaN;
        int count = 0;
        ArithmeticMeanCalculator mean = new ArithmeticMeanCalculator();
        for (RawNumericMetric metric : rawMetrics) {
            double value = metric.getValue();
            if (count == 0) {
                max = min = value;
            }
            if (value < min) {
                min = value;
            } else if (value > max) {
                max = value;
            }
            mean.add(value);
            ++count;
        }
        return new AggregateNumericMetric(0, mean.getArithmeticMean(), min, max, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AggregateNumericMetric> calculateAggregates(MetricsTable fromTable, MetricsTable toTable, long timeSlice, Duration nextDuration) {
        long start = System.currentTimeMillis();
        try {
            DateTimeComparator dateTimeComparator;
            DateTime startTime = new DateTime(timeSlice);
            DateTime endTime = startTime.plus((ReadableDuration)nextDuration);
            DateTime currentHour = this.currentHour();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Preparing to compute aggregates for data in " + (Object)((Object)fromTable) + " table"));
                this.log.debug((Object)("Time slice start time is [" + startTime + "] and the end time is [" + endTime + "]."));
            }
            if ((dateTimeComparator = DateTimeComparator.getInstance()).compare((Object)currentHour, (Object)endTime) < 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Skipping aggregation for " + (Object)((Object)fromTable) + " since the time slice has not yet completed"));
                }
                List<AggregateNumericMetric> list = Collections.emptyList();
                return list;
            }
            Iterable<MetricsIndexEntry> indexEntries = this.dao.findMetricsIndexEntries(toTable, timeSlice);
            ArrayList<AggregateNumericMetric> toMetrics = new ArrayList<AggregateNumericMetric>();
            for (MetricsIndexEntry indexEntry : indexEntries) {
                Iterable<AggregateNumericMetric> metrics = null;
                switch (fromTable) {
                    case ONE_HOUR: {
                        metrics = this.dao.findOneHourMetrics(indexEntry.getScheduleId(), startTime.getMillis(), endTime.getMillis());
                        break;
                    }
                    case SIX_HOUR: {
                        metrics = this.dao.findSixHourMetrics(indexEntry.getScheduleId(), startTime.getMillis(), endTime.getMillis());
                        break;
                    }
                    default: {
                        metrics = this.dao.findTwentyFourHourMetrics(indexEntry.getScheduleId(), startTime.getMillis(), endTime.getMillis());
                    }
                }
                AggregateNumericMetric aggregatedMetric = this.calculateAggregate(metrics, startTime.getMillis());
                aggregatedMetric.setScheduleId(indexEntry.getScheduleId());
                toMetrics.add(aggregatedMetric);
            }
            switch (toTable) {
                case ONE_HOUR: {
                    this.insertOneHourAggregates(toMetrics);
                    break;
                }
                case SIX_HOUR: {
                    this.insertSixHourAggregates(toMetrics);
                    break;
                }
                default: {
                    this.insertTwentyFourHourAggregates(toMetrics);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Finished computing and inserting " + toMetrics.size() + " aggregates into table [" + (Object)((Object)toTable) + "] "));
            }
            ArrayList<AggregateNumericMetric> arrayList = toMetrics;
            return arrayList;
        }
        finally {
            long end = System.currentTimeMillis();
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Finished computing aggregates for table [" + (Object)((Object)fromTable) + "] " + (end - start) + " ms"));
            }
        }
    }

    private void insertOneHourAggregates(List<AggregateNumericMetric> metrics) {
        for (AggregateNumericMetric metric : metrics) {
            this.dao.insertOneHourData(metric.getScheduleId(), metric.getTimestamp(), AggregateType.MIN, metric.getMin());
            this.dao.insertOneHourData(metric.getScheduleId(), metric.getTimestamp(), AggregateType.MAX, metric.getMax());
            this.dao.insertOneHourData(metric.getScheduleId(), metric.getTimestamp(), AggregateType.AVG, metric.getAvg());
        }
    }

    private void insertSixHourAggregates(List<AggregateNumericMetric> metrics) {
        for (AggregateNumericMetric metric : metrics) {
            this.dao.insertSixHourData(metric.getScheduleId(), metric.getTimestamp(), AggregateType.MIN, metric.getMin());
            this.dao.insertSixHourData(metric.getScheduleId(), metric.getTimestamp(), AggregateType.MAX, metric.getMax());
            this.dao.insertSixHourData(metric.getScheduleId(), metric.getTimestamp(), AggregateType.AVG, metric.getAvg());
        }
    }

    private void insertTwentyFourHourAggregates(List<AggregateNumericMetric> metrics) {
        for (AggregateNumericMetric metric : metrics) {
            this.dao.insertTwentyFourHourData(metric.getScheduleId(), metric.getTimestamp(), AggregateType.MIN, metric.getMin());
            this.dao.insertTwentyFourHourData(metric.getScheduleId(), metric.getTimestamp(), AggregateType.MAX, metric.getMax());
            this.dao.insertTwentyFourHourData(metric.getScheduleId(), metric.getTimestamp(), AggregateType.AVG, metric.getAvg());
        }
    }

    private AggregateNumericMetric calculateAggregate(Iterable<AggregateNumericMetric> metrics, long timestamp) {
        double min;
        double max = min = Double.NaN;
        int count = 0;
        ArithmeticMeanCalculator mean = new ArithmeticMeanCalculator();
        for (AggregateNumericMetric metric : metrics) {
            if (count == 0) {
                min = metric.getMin();
                max = metric.getMax();
            }
            if (metric.getMin() < min) {
                min = metric.getMin();
            } else if (metric.getMax() > max) {
                max = metric.getMax();
            }
            mean.add(metric.getAvg());
            ++count;
        }
        return new AggregateNumericMetric(0, mean.getArithmeticMean(), min, max, timestamp);
    }
}

