/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.aggregation;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.rhq.server.metrics.ArithmeticMeanCalculator;
import org.rhq.server.metrics.MetricsDAO;
import org.rhq.server.metrics.StorageResultSetFuture;
import org.rhq.server.metrics.domain.AggregateNumericMetric;
import org.rhq.server.metrics.domain.AggregateType;
import org.rhq.server.metrics.domain.MetricsTable;

class Compute1HourData
implements AsyncFunction<List<ResultSet>, List<ResultSet>> {
    private final Log log = LogFactory.getLog(Compute1HourData.class);
    private DateTime startTime;
    private MetricsDAO dao;
    private DateTime sixHourTimeSlice;
    private Set<AggregateNumericMetric> oneHourData;

    public Compute1HourData(DateTime startTime, DateTime sixHourTimeSlice, MetricsDAO dao, Set<AggregateNumericMetric> oneHourData) {
        this.startTime = startTime;
        this.sixHourTimeSlice = sixHourTimeSlice;
        this.dao = dao;
        this.oneHourData = oneHourData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<List<ResultSet>> apply(List<ResultSet> rawDataResultSets) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Computing and storing 1 hour data for " + rawDataResultSets.size() + " schedules"));
        }
        Stopwatch stopwatch = new Stopwatch().start();
        try {
            ArrayList<StorageResultSetFuture> insertFutures = new ArrayList<StorageResultSetFuture>(rawDataResultSets.size());
            for (ResultSet resultSet : rawDataResultSets) {
                if (resultSet == null) continue;
                AggregateNumericMetric aggregate = this.calculateAggregatedRaw(resultSet);
                this.oneHourData.add(aggregate);
                insertFutures.add(this.dao.insertOneHourDataAsync(aggregate.getScheduleId(), aggregate.getTimestamp(), AggregateType.MIN, aggregate.getMin()));
                insertFutures.add(this.dao.insertOneHourDataAsync(aggregate.getScheduleId(), aggregate.getTimestamp(), AggregateType.MAX, aggregate.getMax()));
                insertFutures.add(this.dao.insertOneHourDataAsync(aggregate.getScheduleId(), aggregate.getTimestamp(), AggregateType.AVG, aggregate.getAvg()));
                insertFutures.add(this.dao.updateMetricsIndex(MetricsTable.SIX_HOUR, aggregate.getScheduleId(), this.sixHourTimeSlice.getMillis()));
            }
            ListenableFuture listenableFuture = Futures.successfulAsList(insertFutures);
            return listenableFuture;
        }
        finally {
            if (this.log.isDebugEnabled()) {
                stopwatch.stop();
                this.log.debug((Object)("Finished computing and storing 1 hour data for " + rawDataResultSets.size() + " schedules in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
            }
        }
    }

    private AggregateNumericMetric calculateAggregatedRaw(ResultSet resultSet) {
        double min;
        double max = min = Double.NaN;
        int count = 0;
        ArithmeticMeanCalculator mean = new ArithmeticMeanCalculator();
        List rows = resultSet.all();
        for (Row row : rows) {
            double value = row.getDouble(2);
            if (count == 0) {
                max = min = value;
            }
            if (value < min) {
                min = value;
            } else if (value > max) {
                max = value;
            }
            mean.add(value);
            ++count;
        }
        return new AggregateNumericMetric(((Row)rows.get(0)).getInt(0), mean.getArithmeticMean(), min, max, this.startTime.getMillis());
    }
}

