/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.aggregation;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.rhq.server.metrics.ArithmeticMeanCalculator;
import org.rhq.server.metrics.MetricsDAO;
import org.rhq.server.metrics.StorageResultSetFuture;
import org.rhq.server.metrics.domain.AggregateNumericMetric;
import org.rhq.server.metrics.domain.AggregateType;
import org.rhq.server.metrics.domain.MetricsTable;

class Compute6HourData
implements AsyncFunction<List<ResultSet>, List<ResultSet>> {
    private final Log log = LogFactory.getLog(Compute6HourData.class);
    private DateTime startTime;
    private MetricsDAO dao;
    private DateTime twentyFourHourTimeSlice;

    public Compute6HourData(DateTime startTime, DateTime twentyFourHourTimeSlice, MetricsDAO dao) {
        this.startTime = startTime;
        this.twentyFourHourTimeSlice = twentyFourHourTimeSlice;
        this.dao = dao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<List<ResultSet>> apply(List<ResultSet> oneHourDataResultSets) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Computing and storing 6 hour data for " + oneHourDataResultSets.size() + " schedules"));
        }
        Stopwatch stopwatch = new Stopwatch().start();
        try {
            ArrayList<StorageResultSetFuture> insertFutures = new ArrayList<StorageResultSetFuture>(oneHourDataResultSets.size());
            for (ResultSet resultSet : oneHourDataResultSets) {
                if (resultSet == null) continue;
                AggregateNumericMetric aggregate = this.calculateAggregate(resultSet);
                insertFutures.add(this.dao.insertSixHourDataAsync(aggregate.getScheduleId(), aggregate.getTimestamp(), AggregateType.MIN, aggregate.getMin()));
                insertFutures.add(this.dao.insertSixHourDataAsync(aggregate.getScheduleId(), aggregate.getTimestamp(), AggregateType.MAX, aggregate.getMax()));
                insertFutures.add(this.dao.insertSixHourDataAsync(aggregate.getScheduleId(), aggregate.getTimestamp(), AggregateType.AVG, aggregate.getAvg()));
                insertFutures.add(this.dao.updateMetricsIndex(MetricsTable.TWENTY_FOUR_HOUR, aggregate.getScheduleId(), this.twentyFourHourTimeSlice.getMillis()));
            }
            ListenableFuture listenableFuture = Futures.successfulAsList(insertFutures);
            return listenableFuture;
        }
        finally {
            if (this.log.isDebugEnabled()) {
                stopwatch.stop();
                this.log.debug((Object)("Finished computing and storing 6 hour data for " + oneHourDataResultSets.size() + " schedules in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
            }
        }
    }

    private AggregateNumericMetric calculateAggregate(ResultSet resultSet) {
        double min;
        double max = min = Double.NaN;
        ArithmeticMeanCalculator mean = new ArithmeticMeanCalculator();
        List rows = resultSet.all();
        for (int i = 0; i < rows.size(); i += 3) {
            if (i == 0) {
                min = ((Row)rows.get(i + 1)).getDouble(3);
                max = ((Row)rows.get(i)).getDouble(3);
            } else {
                if (((Row)rows.get(i + 1)).getDouble(3) < min) {
                    min = ((Row)rows.get(i + 1)).getDouble(3);
                }
                if (((Row)rows.get(i)).getDouble(3) > max) {
                    max = ((Row)rows.get(i)).getDouble(3);
                }
            }
            mean.add(((Row)rows.get(i + 2)).getDouble(3));
        }
        return new AggregateNumericMetric(((Row)rows.get(0)).getInt(0), mean.getArithmeticMean(), min, max, this.startTime.getMillis());
    }
}

