/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.ResultSet;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.server.metrics.MetricsConfiguration;
import org.rhq.server.metrics.StorageResultSetFuture;
import org.rhq.server.metrics.StorageSession;
import org.rhq.server.metrics.domain.AggregateNumericMetric;
import org.rhq.server.metrics.domain.AggregateNumericMetricMapper;
import org.rhq.server.metrics.domain.AggregateSimpleNumericMetric;
import org.rhq.server.metrics.domain.AggregateSimpleNumericMetricMapper;
import org.rhq.server.metrics.domain.AggregateType;
import org.rhq.server.metrics.domain.ListPagedResult;
import org.rhq.server.metrics.domain.MetricsTable;
import org.rhq.server.metrics.domain.RawNumericMetric;
import org.rhq.server.metrics.domain.RawNumericMetricMapper;
import org.rhq.server.metrics.domain.SimplePagedResult;

public class MetricsDAO {
    private final Log log = LogFactory.getLog(MetricsDAO.class);
    private static final Set<Integer> EMPTY_SCHEDULE_IDS = Collections.emptySet();
    private StorageSession storageSession;
    private MetricsConfiguration configuration;
    private PreparedStatement insertRawData;
    private PreparedStatement rawMetricsQuery;
    private PreparedStatement insertCacheEntry;
    private PreparedStatement insertOneHourData;
    private PreparedStatement insertSixHourData;
    private PreparedStatement insertTwentyFourHourData;
    private PreparedStatement findLatestRawMetric;
    private PreparedStatement findRawMetrics;
    private PreparedStatement findOneHourMetricsByDateRange;
    private PreparedStatement findSixHourMetricsByDateRange;
    private PreparedStatement findTwentyFourHourMetricsByDateRange;
    private PreparedStatement findCacheEntries;
    private PreparedStatement findCacheTimeSlice;
    private PreparedStatement deleteCacheEntries;
    private PreparedStatement updateCacheIndex;
    private PreparedStatement findCacheIndexEntriesByDay;
    private PreparedStatement findPastCacheIndexEntriesBeforeToday;
    private PreparedStatement findPastCacheIndexEntriesFromToday;
    private PreparedStatement findCurrentCacheIndexEntries;
    private PreparedStatement findCurrentCacheIndexEntriesFromOffset;
    private PreparedStatement deleteCacheIndexEntry;
    private PreparedStatement deleteCacheIndexEntries;
    private PreparedStatement delete6HourMetric;
    private PreparedStatement delete1HourMetric;
    private PreparedStatement delete24HourMetric;

    public MetricsDAO(StorageSession session, MetricsConfiguration configuration) {
        this.storageSession = session;
        this.configuration = configuration;
        this.initPreparedStatements();
    }

    public void initPreparedStatements() {
        this.log.info((Object)"Initializing prepared statements");
        long startTime = System.currentTimeMillis();
        this.insertRawData = this.storageSession.prepare("INSERT INTO " + (Object)((Object)MetricsTable.RAW) + " (schedule_id, time, value) VALUES (?, ?, ?) USING TTL " + this.configuration.getRawTTL());
        this.rawMetricsQuery = this.storageSession.prepare("SELECT schedule_id, time, value FROM " + (Object)((Object)MetricsTable.RAW) + " WHERE schedule_id = ? AND time >= ? AND time < ? ORDER BY time");
        this.insertOneHourData = this.storageSession.prepare("INSERT INTO " + (Object)((Object)MetricsTable.ONE_HOUR) + "(schedule_id, time, " + "type, value) VALUES (?, ?, ?, ?) USING TTL " + this.configuration.getOneHourTTL());
        this.insertSixHourData = this.storageSession.prepare("INSERT INTO " + (Object)((Object)MetricsTable.SIX_HOUR) + "(schedule_id, time, " + "type, value) VALUES (?, ?, ?, ?) USING TTL " + this.configuration.getSixHourTTL());
        this.insertTwentyFourHourData = this.storageSession.prepare("INSERT INTO " + (Object)((Object)MetricsTable.TWENTY_FOUR_HOUR) + "(schedule_id, " + "time, type, value) VALUES (?, ?, ?, ?) USING TTL " + this.configuration.getTwentyFourHourTTL());
        this.insertCacheEntry = this.storageSession.prepare("INSERT INTO " + (Object)((Object)MetricsTable.METRICS_CACHE) + " (bucket, time_slice, start_schedule_id, schedule_id, time, value) VALUES (?, ?, ?, ?, ?, ?)");
        this.findLatestRawMetric = this.storageSession.prepare("SELECT schedule_id, time, value FROM " + (Object)((Object)MetricsTable.RAW) + " WHERE schedule_id = ? ORDER BY time DESC LIMIT 1");
        this.findRawMetrics = this.storageSession.prepare("SELECT schedule_id, time, value FROM " + (Object)((Object)MetricsTable.RAW) + " WHERE schedule_id = ? AND time >= ? AND time <= ?");
        this.findOneHourMetricsByDateRange = this.storageSession.prepare("SELECT schedule_id, time, type, value FROM " + (Object)((Object)MetricsTable.ONE_HOUR) + " WHERE schedule_id = ? AND time >= ? AND time < ?");
        this.findSixHourMetricsByDateRange = this.storageSession.prepare("SELECT schedule_id, time, type, value FROM " + (Object)((Object)MetricsTable.SIX_HOUR) + " WHERE schedule_id = ? AND time >= ? AND time < ?");
        this.findTwentyFourHourMetricsByDateRange = this.storageSession.prepare("SELECT schedule_id, time, type, value FROM " + (Object)((Object)MetricsTable.TWENTY_FOUR_HOUR) + " WHERE schedule_id = ? AND time >= ? AND time < ?");
        this.findCacheEntries = this.storageSession.prepare("SELECT schedule_id, time, value FROM " + (Object)((Object)MetricsTable.METRICS_CACHE) + " " + "WHERE bucket = ? AND time_slice = ? AND start_schedule_id = ?");
        this.findCacheTimeSlice = this.storageSession.prepare("SELECT time_slice FROM " + (Object)((Object)MetricsTable.METRICS_CACHE) + " " + " WHERE bucket = ? AND time_slice = ? AND start_schedule_id = ?");
        this.deleteCacheEntries = this.storageSession.prepare("DELETE FROM " + (Object)((Object)MetricsTable.METRICS_CACHE) + " " + "WHERE bucket = ? AND time_slice = ? AND start_schedule_id = ?");
        this.updateCacheIndex = this.storageSession.prepare("UPDATE " + (Object)((Object)MetricsTable.METRICS_CACHE_INDEX) + " " + "SET schedule_ids = schedule_ids + ? " + "WHERE bucket = ? AND day = ? AND partition = ? AND collection_time_slice = ? AND " + "      start_schedule_id = ? AND insert_time_slice = ?");
        this.findCacheIndexEntriesByDay = this.storageSession.prepare("SELECT bucket, day, partition, collection_time_slice, start_schedule_id, insert_time_slice, schedule_ids  FROM " + (Object)((Object)MetricsTable.METRICS_CACHE_INDEX) + " " + "WHERE bucket = ? AND day = ? AND partition = ?");
        this.findPastCacheIndexEntriesBeforeToday = this.storageSession.prepare("SELECT bucket, day, partition, collection_time_slice, start_schedule_id, insert_time_slice, schedule_ids FROM " + (Object)((Object)MetricsTable.METRICS_CACHE_INDEX) + " " + "WHERE bucket = ? AND day = ? AND partition = ? AND collection_time_slice >= ? " + "LIMIT " + this.configuration.getIndexPageSize());
        this.findPastCacheIndexEntriesFromToday = this.storageSession.prepare("SELECT bucket, day, partition, collection_time_slice, start_schedule_id, insert_time_slice, schedule_ids FROM " + (Object)((Object)MetricsTable.METRICS_CACHE_INDEX) + " " + "WHERE bucket = ? AND day = ? AND partition = ? AND collection_time_slice < ?");
        this.findCurrentCacheIndexEntries = this.storageSession.prepare("SELECT bucket, day, partition, collection_time_slice, start_schedule_id, insert_time_slice, schedule_ids FROM " + (Object)((Object)MetricsTable.METRICS_CACHE_INDEX) + " " + "WHERE bucket = ? AND day = ? AND partition = ? AND collection_time_slice = ? " + "LIMIT " + this.configuration.getIndexPageSize());
        this.findCurrentCacheIndexEntriesFromOffset = this.storageSession.prepare("SELECT bucket, day, partition, collection_time_slice, start_schedule_id, insert_time_slice, schedule_ids FROM " + (Object)((Object)MetricsTable.METRICS_CACHE_INDEX) + " " + "WHERE bucket = ? AND day = ? AND partition = ? AND collection_time_slice = ? AND start_schedule_id > ? " + " LIMIT " + this.configuration.getIndexPageSize());
        this.deleteCacheIndexEntry = this.storageSession.prepare("DELETE FROM " + (Object)((Object)MetricsTable.METRICS_CACHE_INDEX) + " " + "WHERE bucket = ? AND day = ? AND partition = ? AND collection_time_slice = ? AND " + "      start_schedule_id = ? AND insert_time_slice = ?");
        this.deleteCacheIndexEntries = this.storageSession.prepare("DELETE FROM " + (Object)((Object)MetricsTable.METRICS_CACHE_INDEX) + " " + "WHERE bucket = ? AND day = ? AND partition = ? AND collection_time_slice = ? AND start_schedule_id = ?");
        this.delete6HourMetric = this.storageSession.prepare("DELETE FROM " + (Object)((Object)MetricsTable.SIX_HOUR) + " WHERE schedule_id = ? AND time = ?");
        this.delete1HourMetric = this.storageSession.prepare("DELETE FROM " + (Object)((Object)MetricsTable.ONE_HOUR) + " WHERE schedule_id = ? AND time = ?");
        this.delete24HourMetric = this.storageSession.prepare("DELETE FROM " + (Object)((Object)MetricsTable.TWENTY_FOUR_HOUR) + " WHERE schedule_id = ? AND time = ?");
        long endTime = System.currentTimeMillis();
        this.log.info((Object)("Finished initializing prepared statements in " + (endTime - startTime) + " ms"));
    }

    public StorageSession getStorageSession() {
        return this.storageSession;
    }

    public StorageResultSetFuture insertRawData(MeasurementDataNumeric data) {
        BoundStatement statement = this.insertRawData.bind(new Object[]{data.getScheduleId(), new Date(data.getTimestamp()), data.getValue()});
        return this.storageSession.executeAsync((Query)statement);
    }

    public ResultSet insertOneHourData(int scheduleId, long timestamp, AggregateType type, double value) {
        BoundStatement statement = this.insertOneHourData.bind(new Object[]{scheduleId, new Date(timestamp), type.ordinal(), value});
        return this.storageSession.execute((Query)statement);
    }

    public StorageResultSetFuture insertOneHourDataAsync(int scheduleId, long timestamp, AggregateType type, double value) {
        BoundStatement statement = this.insertOneHourData.bind(new Object[]{scheduleId, new Date(timestamp), type.ordinal(), value});
        return this.storageSession.executeAsync((Query)statement);
    }

    public ResultSet insertSixHourData(int scheduleId, long timestamp, AggregateType type, double value) {
        BoundStatement statement = this.insertSixHourData.bind(new Object[]{scheduleId, new Date(timestamp), type.ordinal(), value});
        return this.storageSession.execute((Query)statement);
    }

    public StorageResultSetFuture insertSixHourDataAsync(int scheduleId, long timestamp, AggregateType type, double value) {
        BoundStatement statement = this.insertSixHourData.bind(new Object[]{scheduleId, new Date(timestamp), type.ordinal(), value});
        return this.storageSession.executeAsync((Query)statement);
    }

    public ResultSet insertTwentyFourHourData(int scheduleId, long timestamp, AggregateType type, double value) {
        BoundStatement statement = this.insertTwentyFourHourData.bind(new Object[]{scheduleId, new Date(timestamp), type.ordinal(), value});
        return this.storageSession.execute((Query)statement);
    }

    public StorageResultSetFuture insertTwentyFourHourDataAsync(int scheduleId, long timestamp, AggregateType type, double value) {
        BoundStatement statement = this.insertTwentyFourHourData.bind(new Object[]{scheduleId, new Date(timestamp), type.ordinal(), value});
        return this.storageSession.executeAsync((Query)statement);
    }

    public List<RawNumericMetric> findRawMetrics(int scheduleId, long startTime, long endTime) {
        RawNumericMetricMapper mapper = new RawNumericMetricMapper();
        BoundStatement boundStatement = this.rawMetricsQuery.bind(new Object[]{scheduleId, new Date(startTime), new Date(endTime)});
        ResultSet resultSet = this.storageSession.execute((Query)boundStatement);
        return mapper.mapAll(resultSet);
    }

    public ResultSet findRawMetricsSync(int scheduleId, long startTime, long endTime) {
        BoundStatement boundStatement = this.rawMetricsQuery.bind(new Object[]{scheduleId, new Date(startTime), new Date(endTime)});
        return this.storageSession.execute((Query)boundStatement);
    }

    public StorageResultSetFuture findRawMetricsAsync(int scheduleId, long startTime, long endTime) {
        BoundStatement boundStatement = this.rawMetricsQuery.bind(new Object[]{scheduleId, new Date(startTime), new Date(endTime)});
        return this.storageSession.executeAsync((Query)boundStatement);
    }

    public RawNumericMetric findLatestRawMetric(int scheduleId) {
        RawNumericMetricMapper mapper = new RawNumericMetricMapper(false);
        BoundStatement boundStatement = this.findLatestRawMetric.bind(new Object[]{scheduleId});
        ResultSet resultSet = this.storageSession.execute((Query)boundStatement);
        return mapper.mapOne(resultSet);
    }

    public Iterable<RawNumericMetric> findRawMetrics(List<Integer> scheduleIds, long startTime, long endTime) {
        return new ListPagedResult<RawNumericMetric>(this.findRawMetrics, scheduleIds, startTime, endTime, new RawNumericMetricMapper(), this.storageSession);
    }

    public List<AggregateNumericMetric> findOneHourMetrics(int scheduleId, long startTime, long endTime) {
        AggregateNumericMetricMapper mapper = new AggregateNumericMetricMapper();
        BoundStatement statement = this.findOneHourMetricsByDateRange.bind(new Object[]{scheduleId, new Date(startTime), new Date(endTime)});
        ResultSet resultSet = this.storageSession.execute((Query)statement);
        return mapper.mapAll(resultSet);
    }

    public StorageResultSetFuture findOneHourMetricsAsync(int scheduleId, long startTime, long endTime) {
        BoundStatement statement = this.findOneHourMetricsByDateRange.bind(new Object[]{scheduleId, new Date(startTime), new Date(endTime)});
        return this.storageSession.executeAsync((Query)statement);
    }

    public List<AggregateNumericMetric> findSixHourMetrics(int scheduleId, long startTime, long endTime) {
        AggregateNumericMetricMapper mapper = new AggregateNumericMetricMapper();
        BoundStatement statement = this.findSixHourMetricsByDateRange.bind(new Object[]{scheduleId, new Date(startTime), new Date(endTime)});
        ResultSet resultSet = this.storageSession.execute((Query)statement);
        return mapper.mapAll(resultSet);
    }

    public StorageResultSetFuture findSixHourMetricsAsync(int scheduleId, long startTime, long endTime) {
        BoundStatement statement = this.findSixHourMetricsByDateRange.bind(new Object[]{scheduleId, new Date(startTime), new Date(endTime)});
        return this.storageSession.executeAsync((Query)statement);
    }

    public List<AggregateNumericMetric> findTwentyFourHourMetrics(int scheduleId, long startTime, long endTime) {
        AggregateNumericMetricMapper mapper = new AggregateNumericMetricMapper();
        BoundStatement statement = this.findTwentyFourHourMetricsByDateRange.bind(new Object[]{scheduleId, new Date(startTime), new Date(endTime)});
        ResultSet resultSet = this.storageSession.execute((Query)statement);
        return mapper.mapAll(resultSet);
    }

    public StorageResultSetFuture findTwentyFourHourMetricsAsync(int scheduleId, long startTime, long endTime) {
        BoundStatement statement = this.findTwentyFourHourMetricsByDateRange.bind(new Object[]{scheduleId, new Date(startTime), new Date(endTime)});
        return this.storageSession.executeAsync((Query)statement);
    }

    public Iterable<AggregateSimpleNumericMetric> findAggregatedSimpleOneHourMetric(int scheduleId, long startTime, long endTime) {
        BoundStatement statement = this.findOneHourMetricsByDateRange.bind(new Object[]{scheduleId, new Date(startTime), new Date(endTime)});
        return new SimplePagedResult<AggregateSimpleNumericMetric>((Query)statement, new AggregateSimpleNumericMetricMapper(), this.storageSession);
    }

    public Iterable<AggregateNumericMetric> findOneHourMetrics(List<Integer> scheduleIds, long startTime, long endTime) {
        return new ListPagedResult<AggregateNumericMetric>(this.findOneHourMetricsByDateRange, scheduleIds, startTime, endTime, new AggregateNumericMetricMapper(), this.storageSession);
    }

    public Iterable<AggregateNumericMetric> findSixHourMetrics(List<Integer> scheduleIds, long startTime, long endTime) {
        return new ListPagedResult<AggregateNumericMetric>(this.findSixHourMetricsByDateRange, scheduleIds, startTime, endTime, new AggregateNumericMetricMapper(), this.storageSession);
    }

    public Iterable<AggregateNumericMetric> findTwentyFourHourMetrics(List<Integer> scheduleIds, long startTime, long endTime) {
        return new ListPagedResult<AggregateNumericMetric>(this.findTwentyFourHourMetricsByDateRange, scheduleIds, startTime, endTime, new AggregateNumericMetricMapper(), this.storageSession);
    }

    public StorageResultSetFuture findCacheEntriesAsync(MetricsTable table, long timeSlice, int startScheduleId) {
        BoundStatement statement = this.findCacheEntries.bind(new Object[]{table.toString(), new Date(timeSlice), startScheduleId});
        return this.storageSession.executeAsync((Query)statement);
    }

    public ResultSet findCacheTimeSlice(MetricsTable table, long timestamp, int startScheduleId) {
        BoundStatement statement = this.findCacheTimeSlice.bind(new Object[]{table.toString(), new Date(timestamp), startScheduleId});
        return this.storageSession.execute((Query)statement);
    }

    public StorageResultSetFuture updateMetricsCache(MetricsTable table, long timeSlice, int startScheduleId, int scheduleId, long timestamp, Map<Integer, Double> values) {
        BoundStatement statement = this.insertCacheEntry.bind(new Object[]{table.getTableName(), new Date(timeSlice), startScheduleId, scheduleId, new Date(timestamp), values});
        return this.storageSession.executeAsync((Query)statement);
    }

    public StorageResultSetFuture deleteCacheEntries(MetricsTable table, long timestamp, int startScheduleId) {
        BoundStatement statement = this.deleteCacheEntries.bind(new Object[]{table.getTableName(), new Date(timestamp), startScheduleId});
        return this.storageSession.executeAsync((Query)statement);
    }

    public StorageResultSetFuture updateCacheIndex(MetricsTable table, long day, int partition, long collectionTimeSlice, int startScheduleId, long insertTimeSlice, Set<Integer> scheduleIds) {
        BoundStatement statement = this.updateCacheIndex.bind(new Object[]{scheduleIds, table.getTableName(), new Date(day), partition, new Date(collectionTimeSlice), startScheduleId, new Date(insertTimeSlice)});
        return this.storageSession.executeAsync((Query)statement);
    }

    public StorageResultSetFuture findPastCacheIndexEntriesBeforeToday(MetricsTable table, long day, int partition, long collectionTimeSlice) {
        BoundStatement statement = this.findPastCacheIndexEntriesBeforeToday.bind(new Object[]{table.getTableName(), new Date(day), partition, new Date(collectionTimeSlice)});
        return this.storageSession.executeAsync((Query)statement);
    }

    public StorageResultSetFuture findCacheIndexEntriesByDay(MetricsTable table, long day, int partition) {
        BoundStatement statement = this.findCacheIndexEntriesByDay.bind(new Object[]{table.getTableName(), new Date(day), partition});
        return this.storageSession.executeAsync((Query)statement);
    }

    public StorageResultSetFuture findPastCacheIndexEntriesFromToday(MetricsTable table, long day, int partition, long collectionTimeSlice) {
        BoundStatement statement = this.findPastCacheIndexEntriesFromToday.bind(new Object[]{table.getTableName(), new Date(day), partition, new Date(collectionTimeSlice)});
        return this.storageSession.executeAsync((Query)statement);
    }

    public StorageResultSetFuture findCurrentCacheIndexEntries(MetricsTable table, long day, int partition, long collectionTimeSlice) {
        BoundStatement statement = this.findCurrentCacheIndexEntries.bind(new Object[]{table.getTableName(), new Date(day), partition, new Date(collectionTimeSlice)});
        return this.storageSession.executeAsync((Query)statement);
    }

    public StorageResultSetFuture findCurrentCacheIndexEntries(MetricsTable table, long day, int partition, long collectionTimeSlice, int startScheduleId) {
        BoundStatement statement = this.findCurrentCacheIndexEntriesFromOffset.bind(new Object[]{table.getTableName(), new Date(day), partition, new Date(collectionTimeSlice), startScheduleId});
        return this.storageSession.executeAsync((Query)statement);
    }

    public StorageResultSetFuture deleteCacheIndexEntry(MetricsTable table, long day, int partition, long collectionTimeSlice, int startScheduleId, long insertTimeSlice) {
        BoundStatement statement = this.deleteCacheIndexEntry.bind(new Object[]{table.getTableName(), new Date(day), partition, new Date(collectionTimeSlice), startScheduleId, new Date(insertTimeSlice)});
        return this.storageSession.executeAsync((Query)statement);
    }

    public StorageResultSetFuture deleteCacheIndexEntries(MetricsTable table, long day, int partition, long collectionTimeSlice, int startScheduleId) {
        BoundStatement statement = this.deleteCacheIndexEntries.bind(new Object[]{table.getTableName(), new Date(day), partition, new Date(collectionTimeSlice), startScheduleId});
        return this.storageSession.executeAsync((Query)statement);
    }

    public void delete1HourMetric(int scheduleId, long timestamp) {
        BoundStatement statement = this.delete1HourMetric.bind(new Object[]{scheduleId, new Date(timestamp)});
        this.storageSession.execute((Query)statement);
    }

    public void delete6HourMetric(int scheduleId, long timestamp) {
        BoundStatement statement = this.delete6HourMetric.bind(new Object[]{scheduleId, new Date(timestamp)});
        this.storageSession.execute((Query)statement);
    }

    public void delete24HourMetric(int scheduleId, long timestamp) {
        BoundStatement statement = this.delete24HourMetric.bind(new Object[]{scheduleId, new Date(timestamp)});
        this.storageSession.execute((Query)statement);
    }
}

