/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics;

import com.datastax.driver.core.ResultSet;
import com.google.common.base.Function;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.composite.MeasurementDataNumericHighLowComposite;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.server.metrics.ArithmeticMeanCalculator;
import org.rhq.server.metrics.Buckets;
import org.rhq.server.metrics.ComputeAggregate;
import org.rhq.server.metrics.ComputeRawAggregate;
import org.rhq.server.metrics.DateTimeService;
import org.rhq.server.metrics.MetricsConfiguration;
import org.rhq.server.metrics.MetricsDAO;
import org.rhq.server.metrics.RawDataInsertedCallback;
import org.rhq.server.metrics.StorageClientThreadFactory;
import org.rhq.server.metrics.StorageResultSetFuture;
import org.rhq.server.metrics.StorageSession;
import org.rhq.server.metrics.aggregation.AggregationManager;
import org.rhq.server.metrics.domain.AggregateNumericMetric;
import org.rhq.server.metrics.domain.AggregateType;
import org.rhq.server.metrics.domain.CacheIndexEntry;
import org.rhq.server.metrics.domain.CacheIndexEntryMapper;
import org.rhq.server.metrics.domain.MetricsTable;
import org.rhq.server.metrics.domain.RawNumericMetric;
import org.rhq.server.metrics.invalid.InvalidMetricsManager;

public class MetricsServer {
    private final Log log = LogFactory.getLog(MetricsServer.class);
    private DateTimeService dateTimeService = new DateTimeService();
    private MetricsDAO dao;
    private MetricsConfiguration configuration;
    private boolean pastAggregationMissed;
    private Long mostRecentRawDataPriorToStartup;
    private AtomicLong totalAggregationTime = new AtomicLong();
    private InvalidMetricsManager invalidMetricsManager;
    private int numAggregationWorkers = 4;
    private ListeningExecutorService aggregationWorkers;
    private int aggregationBatchSize = Integer.parseInt(System.getProperty("rhq.metrics.aggregation.batch-size", "5"));
    private int parallelism = Integer.parseInt(System.getProperty("rhq.metrics.aggregation.parallelism", "3"));
    private int cacheBatchSize = Integer.parseInt(System.getProperty("rhq.metrics.cache.batch-size", "5"));
    private long cacheActivationTime;
    private Days rawDataAgeLimit = Days.days((int)Integer.parseInt(System.getProperty("rhq.metrics.data.age-limit", "3")));

    public void setDAO(MetricsDAO dao) {
        this.dao = dao;
    }

    public void setConfiguration(MetricsConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public int getAggregationBatchSize() {
        return this.aggregationBatchSize;
    }

    public void setAggregationBatchSize(int batchSize) {
        this.aggregationBatchSize = batchSize;
    }

    public int getAggregationParallelism() {
        return this.parallelism;
    }

    public void setAggregationParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public int getNumAggregationWorkers() {
        return this.numAggregationWorkers;
    }

    public void setCacheBatchSize(int size) {
        this.cacheBatchSize = size;
    }

    ListeningExecutorService getAggregationWorkers() {
        return this.aggregationWorkers;
    }

    public void setCacheActivationTime(long cacheActivationTime) {
        this.cacheActivationTime = cacheActivationTime;
    }

    public int getRawDataAgeLimit() {
        return this.rawDataAgeLimit.getDays();
    }

    public void setRawDataAgeLimit(int rawDataAgeLimit) {
        this.rawDataAgeLimit = Days.days((int)rawDataAgeLimit);
    }

    public void init() {
        this.numAggregationWorkers = Integer.parseInt(System.getProperty("rhq.metrics.aggregation.workers", "4"));
        if (this.numAggregationWorkers < 2) {
            this.numAggregationWorkers = 2;
        }
        this.aggregationWorkers = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this.numAggregationWorkers, new StorageClientThreadFactory()));
        this.determineMostRecentRawDataSinceLastShutdown();
        this.invalidMetricsManager = new InvalidMetricsManager(this.dateTimeService, this.dao);
    }

    private void determineMostRecentRawDataSinceLastShutdown() {
        DateTime previousHour = this.dateTimeService.currentHour().minus((ReadableDuration)this.configuration.getRawTimeSliceDuration());
        DateTime oldestRawTime = previousHour.minus(this.configuration.getRawRetention());
        CacheIndexEntryMapper mapper = new CacheIndexEntryMapper();
        DateTime day = this.dateTimeService.current24HourTimeSlice();
        StorageResultSetFuture future = this.dao.findPastCacheIndexEntriesFromToday(MetricsTable.RAW, day.getMillis(), 0, previousHour.getMillis());
        List<CacheIndexEntry> indexEntries = mapper.map(future.get());
        if (!indexEntries.isEmpty()) {
            this.log.info((Object)"Raw data aggregate computations are up to date");
            this.setMostRecentRawDataPriorToStartup(indexEntries);
        } else {
            DateTime hour;
            if ((day = day.minus((ReadableDuration)this.configuration.getSixHourTimeSliceDuration())).isAfter((ReadableInstant)oldestRawTime)) {
                future = this.dao.findCacheIndexEntriesByDay(MetricsTable.RAW, day.getMillis(), 0);
            } else {
                hour = day.plusHours(this.dateTimeService.currentHour().getHourOfDay());
                future = this.dao.findPastCacheIndexEntriesBeforeToday(MetricsTable.RAW, day.getMillis(), 0, hour.getMillis());
            }
            indexEntries = mapper.map(future.get());
            while (indexEntries.isEmpty() && day.isAfter((ReadableInstant)oldestRawTime)) {
                future = this.dao.findCacheIndexEntriesByDay(MetricsTable.RAW, day.getMillis(), 0);
                indexEntries = mapper.map(future.get());
                day = day.minus((ReadableDuration)this.configuration.getSixHourTimeSliceDuration());
            }
            if (indexEntries.isEmpty()) {
                hour = day.plusHours(this.dateTimeService.currentHour().getHourOfDay());
                future = this.dao.findPastCacheIndexEntriesBeforeToday(MetricsTable.RAW, day.getMillis(), 0, hour.getMillis());
                indexEntries = mapper.map(future.get());
                if (indexEntries.isEmpty()) {
                    this.log.info((Object)"Did not find any raw data in the storage database since the last server shutdown. Raw data aggregate computations are up to date.");
                } else {
                    this.setMostRecentRawDataPriorToStartup(indexEntries);
                }
            } else {
                this.setMostRecentRawDataPriorToStartup(indexEntries);
            }
        }
    }

    private void setMostRecentRawDataPriorToStartup(List<CacheIndexEntry> indexEntries) {
        CacheIndexEntry lastIndexEntry = indexEntries.get(indexEntries.size() - 1);
        this.mostRecentRawDataPriorToStartup = lastIndexEntry.getCollectionTimeSlice();
        this.pastAggregationMissed = true;
        this.log.info((Object)("Found the most recently inserted raw data prior to this server start up with a timestamp of [" + this.mostRecentRawDataPriorToStartup + "]. Aggregates for this data will be computed the " + "next time the aggregation job runs."));
    }

    protected DateTime roundDownToHour(long timestamp) {
        return this.dateTimeService.getTimeSlice(new DateTime(timestamp), this.configuration.getRawTimeSliceDuration());
    }

    public void shutdown() {
        this.aggregationWorkers.shutdown();
        this.invalidMetricsManager.shutdown();
    }

    public RawNumericMetric findLatestValueForResource(int scheduleId) {
        this.log.debug((Object)("Querying for most recent raw metrics for [scheduleId: " + scheduleId + "]"));
        return this.dao.findLatestRawMetric(scheduleId);
    }

    public long getTotalAggregationTime() {
        return this.totalAggregationTime.get();
    }

    public Iterable<MeasurementDataNumericHighLowComposite> findDataForResource(int scheduleId, long beginTime, long endTime, int numberOfBuckets) {
        Stopwatch stopwatch = new Stopwatch().start();
        try {
            DateTime begin = new DateTime(beginTime);
            if (this.dateTimeService.isInRawDataRange(begin)) {
                List<RawNumericMetric> metrics = this.dao.findRawMetrics(scheduleId, beginTime, endTime);
                List<MeasurementDataNumericHighLowComposite> list = this.createRawComposites(metrics, beginTime, endTime, numberOfBuckets);
                return list;
            }
            List<AggregateNumericMetric> metrics = null;
            if (this.dateTimeService.isIn1HourDataRange(begin)) {
                metrics = this.dao.findOneHourMetrics(scheduleId, beginTime, endTime);
                List<MeasurementDataNumericHighLowComposite> list = this.createComposites(metrics, beginTime, endTime, numberOfBuckets, MetricsTable.ONE_HOUR);
                return list;
            }
            if (this.dateTimeService.isIn6HourDataRange(begin)) {
                metrics = this.dao.findSixHourMetrics(scheduleId, beginTime, endTime);
                List<MeasurementDataNumericHighLowComposite> list = this.createComposites(metrics, beginTime, endTime, numberOfBuckets, MetricsTable.SIX_HOUR);
                return list;
            }
            if (this.dateTimeService.isIn24HourDataRange(begin)) {
                metrics = this.dao.findTwentyFourHourMetrics(scheduleId, beginTime, endTime);
                List<MeasurementDataNumericHighLowComposite> list = this.createComposites(metrics, beginTime, endTime, numberOfBuckets, MetricsTable.TWENTY_FOUR_HOUR);
                return list;
            }
            throw new IllegalArgumentException("beginTime[" + beginTime + "] is outside the accepted range.");
        }
        finally {
            stopwatch.stop();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Finished calculating resource summary aggregate in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
            }
        }
    }

    public List<MeasurementDataNumericHighLowComposite> findDataForGroup(List<Integer> scheduleIds, long beginTime, long endTime, int numberOfBuckets) {
        DateTime begin;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Querying for metric data using parameters [scheduleIds: " + scheduleIds + ", beingTime: " + beginTime + ", endTime: " + endTime + ", numberOfBuckets: " + numberOfBuckets + "]"));
        }
        if (this.dateTimeService.isInRawDataRange(begin = new DateTime(beginTime))) {
            Iterable<RawNumericMetric> metrics = this.dao.findRawMetrics(scheduleIds, beginTime, endTime);
            return this.createRawComposites(metrics, beginTime, endTime, numberOfBuckets);
        }
        Iterable<AggregateNumericMetric> metrics = null;
        if (this.dateTimeService.isIn1HourDataRange(begin)) {
            metrics = this.dao.findOneHourMetrics(scheduleIds, beginTime, endTime);
            return this.createComposites(metrics, beginTime, endTime, numberOfBuckets, MetricsTable.ONE_HOUR);
        }
        if (this.dateTimeService.isIn6HourDataRange(begin)) {
            metrics = this.dao.findSixHourMetrics(scheduleIds, beginTime, endTime);
            return this.createComposites(metrics, beginTime, endTime, numberOfBuckets, MetricsTable.SIX_HOUR);
        }
        if (this.dateTimeService.isIn24HourDataRange(begin)) {
            metrics = this.dao.findTwentyFourHourMetrics(scheduleIds, beginTime, endTime);
            return this.createComposites(metrics, beginTime, endTime, numberOfBuckets, MetricsTable.TWENTY_FOUR_HOUR);
        }
        throw new IllegalArgumentException("beginTime[" + beginTime + "] is outside the accepted range.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AggregateNumericMetric getSummaryAggregate(int scheduleId, long beginTime, long endTime) {
        Stopwatch stopwatch = new Stopwatch().start();
        try {
            DateTime begin = new DateTime(beginTime);
            if (this.dateTimeService.isInRawDataRange(begin)) {
                List<RawNumericMetric> metrics = this.dao.findRawMetrics(scheduleId, beginTime, endTime);
                AggregateNumericMetric aggregateNumericMetric = this.calculateAggregatedRaw(metrics, beginTime);
                return aggregateNumericMetric;
            }
            List<AggregateNumericMetric> metrics = null;
            if (this.dateTimeService.isIn1HourDataRange(begin)) {
                metrics = this.dao.findOneHourMetrics(scheduleId, beginTime, endTime);
            } else if (this.dateTimeService.isIn6HourDataRange(begin)) {
                metrics = this.dao.findSixHourMetrics(scheduleId, beginTime, endTime);
            } else if (this.dateTimeService.isIn24HourDataRange(begin)) {
                metrics = this.dao.findTwentyFourHourMetrics(scheduleId, beginTime, endTime);
            } else {
                throw new IllegalArgumentException("beginTime[" + beginTime + "] is outside the accepted range.");
            }
            AggregateNumericMetric aggregateNumericMetric = this.calculateAggregate(metrics, beginTime);
            return aggregateNumericMetric;
        }
        finally {
            stopwatch.stop();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Finished calculating resource summary aggregate for [scheduleId: " + scheduleId + ", beginTime: " + beginTime + ", endTime: " + endTime + "] in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<AggregateNumericMetric> getSummaryAggregateAsync(int scheduleId, long beginTime, long endTime) {
        long start = System.currentTimeMillis();
        try {
            StorageResultSetFuture queryFuture;
            DateTime begin;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Calculating resource summary aggregate (async) for [scheduleId: " + scheduleId + ", beginTime: " + beginTime + ", endTime: " + endTime + "]"));
            }
            if (this.dateTimeService.isInRawDataRange(begin = new DateTime(beginTime))) {
                StorageResultSetFuture queryFuture2 = this.dao.findRawMetricsAsync(scheduleId, beginTime, endTime);
                ListenableFuture listenableFuture = Futures.transform((ListenableFuture)queryFuture2, (Function)new ComputeRawAggregate(beginTime));
                return listenableFuture;
            }
            if (this.dateTimeService.isIn1HourDataRange(begin)) {
                queryFuture = this.dao.findOneHourMetricsAsync(scheduleId, beginTime, endTime);
            } else if (this.dateTimeService.isIn6HourDataRange(begin)) {
                queryFuture = this.dao.findSixHourMetricsAsync(scheduleId, beginTime, endTime);
            } else if (this.dateTimeService.isIn24HourDataRange(begin)) {
                queryFuture = this.dao.findTwentyFourHourMetricsAsync(scheduleId, beginTime, endTime);
            } else {
                throw new IllegalArgumentException("beginTime[" + beginTime + "] is outside the accepted range.");
            }
            ListenableFuture listenableFuture = Futures.transform((ListenableFuture)queryFuture, (Function)new ComputeAggregate(beginTime));
            return listenableFuture;
        }
        finally {
            long end = System.currentTimeMillis();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Finished calculating resource summary aggregate (async) in " + (end - start) + " ms"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AggregateNumericMetric getSummaryAggregate(List<Integer> scheduleIds, long beginTime, long endTime) {
        Stopwatch stopwatch = new Stopwatch().start();
        try {
            DateTime begin = new DateTime(beginTime);
            if (this.dateTimeService.isInRawDataRange(new DateTime(beginTime))) {
                Iterable<RawNumericMetric> metrics = this.dao.findRawMetrics(scheduleIds, beginTime, endTime);
                AggregateNumericMetric aggregateNumericMetric = this.calculateAggregatedRaw(metrics, beginTime);
                return aggregateNumericMetric;
            }
            Iterable<AggregateNumericMetric> metrics = null;
            if (this.dateTimeService.isIn1HourDataRange(begin)) {
                metrics = this.dao.findOneHourMetrics(scheduleIds, beginTime, endTime);
            } else if (this.dateTimeService.isIn6HourDataRange(begin)) {
                metrics = this.dao.findSixHourMetrics(scheduleIds, beginTime, endTime);
            } else if (this.dateTimeService.isIn24HourDataRange(begin)) {
                metrics = this.dao.findTwentyFourHourMetrics(scheduleIds, beginTime, endTime);
            } else {
                throw new IllegalArgumentException("beginTime[" + beginTime + "] is outside the accepted range.");
            }
            AggregateNumericMetric aggregateNumericMetric = this.calculateAggregate(metrics, beginTime);
            return aggregateNumericMetric;
        }
        finally {
            stopwatch.stop();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Finished calculating group summary aggregate for [scheduleIds: " + scheduleIds + ", beginTime: " + beginTime + ", endTime: " + endTime + "] in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
            }
        }
    }

    private List<MeasurementDataNumericHighLowComposite> createRawComposites(Iterable<RawNumericMetric> metrics, long beginTime, long endTime, int numberOfBuckets) {
        Buckets buckets = new Buckets(beginTime, endTime, numberOfBuckets);
        for (RawNumericMetric metric : metrics) {
            buckets.insert(metric.getTimestamp(), metric.getValue(), metric.getValue(), metric.getValue());
        }
        ArrayList<MeasurementDataNumericHighLowComposite> data = new ArrayList<MeasurementDataNumericHighLowComposite>();
        for (int i = 0; i < buckets.getNumDataPoints(); ++i) {
            Buckets.Bucket bucket = buckets.get(i);
            data.add(new MeasurementDataNumericHighLowComposite(bucket.getStartTime(), bucket.getAvg(), bucket.getMax(), bucket.getMin()));
        }
        return data;
    }

    private List<MeasurementDataNumericHighLowComposite> createComposites(Iterable<AggregateNumericMetric> metrics, long beginTime, long endTime, int numberOfBuckets, MetricsTable type) {
        Buckets buckets = new Buckets(beginTime, endTime, numberOfBuckets);
        for (AggregateNumericMetric metric : metrics) {
            if (this.invalidMetricsManager.isInvalidMetric(metric)) {
                this.log.warn((Object)("The " + (Object)((Object)type) + " metric " + metric + " is invalid. It will be excluded from the results " + "sent to the client and we will attempt to recompute the metric."));
                this.invalidMetricsManager.submit(type, metric);
                continue;
            }
            buckets.insert(metric.getTimestamp(), metric.getAvg(), metric.getMin(), metric.getMax());
        }
        ArrayList<MeasurementDataNumericHighLowComposite> data = new ArrayList<MeasurementDataNumericHighLowComposite>();
        for (int i = 0; i < buckets.getNumDataPoints(); ++i) {
            Buckets.Bucket bucket = buckets.get(i);
            data.add(new MeasurementDataNumericHighLowComposite(bucket.getStartTime(), bucket.getAvg(), bucket.getMax(), bucket.getMin()));
        }
        return data;
    }

    private void updateMaxWithNewTTL(AggregateNumericMetric metric, MetricsTable type) {
        switch (type) {
            case ONE_HOUR: {
                int newTTL = this.calculateNewTTL(MetricsTable.ONE_HOUR.getTTLinMilliseconds(), metric.getTimestamp());
                this.updateMax(metric, MetricsTable.ONE_HOUR, newTTL);
                break;
            }
            case SIX_HOUR: {
                int newTTL = this.calculateNewTTL(MetricsTable.SIX_HOUR.getTTLinMilliseconds(), metric.getTimestamp());
                this.updateMax(metric, MetricsTable.SIX_HOUR, newTTL);
                break;
            }
            case TWENTY_FOUR_HOUR: {
                int newTTL = this.calculateNewTTL(MetricsTable.TWENTY_FOUR_HOUR.getTTLinMilliseconds(), metric.getTimestamp());
                this.updateMax(metric, MetricsTable.TWENTY_FOUR_HOUR, newTTL);
                break;
            }
            default: {
                throw new IllegalArgumentException("This method should only be called for aggregate metrics");
            }
        }
    }

    private int calculateNewTTL(long originalTTLMillis, long timestamp) {
        return new Duration(originalTTLMillis - (System.currentTimeMillis() - timestamp)).toStandardSeconds().getSeconds();
    }

    private void updateMax(final AggregateNumericMetric metric, MetricsTable table, int ttl) {
        StorageSession session = this.dao.getStorageSession();
        StorageResultSetFuture future = session.executeAsync("INSERT INTO " + (Object)((Object)table) + " (schedule_id, time, type, value) " + "VALUES (" + metric.getScheduleId() + ", " + metric.getTimestamp() + ", " + AggregateType.MAX.ordinal() + ", " + metric.getMax() + ") " + "USING TTL " + ttl);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<ResultSet>(){

            public void onSuccess(ResultSet result) {
                MetricsServer.this.log.info((Object)("Successfully updated the max value for " + metric));
            }

            public void onFailure(Throwable t) {
                MetricsServer.this.log.warn((Object)("Failed to update the max value for " + metric), t);
            }
        });
    }

    public void addNumericData(final Set<MeasurementDataNumeric> dataSet, final RawDataInsertedCallback callback) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Inserting " + dataSet.size() + " raw metrics"));
        }
        final Stopwatch stopwatch = new Stopwatch().start();
        final AtomicInteger remainingInserts = new AtomicInteger(dataSet.size());
        boolean partition = false;
        DateTime insertTimeSlice = this.dateTimeService.currentHour();
        for (final MeasurementDataNumeric data : dataSet) {
            DateTime collectionTimeSlice = this.dateTimeService.getTimeSlice(new DateTime(data.getTimestamp()), this.configuration.getRawTimeSliceDuration());
            Days days = Days.daysBetween((ReadableInstant)collectionTimeSlice, (ReadableInstant)this.dateTimeService.now());
            if (days.isGreaterThan(this.rawDataAgeLimit)) {
                callback.onSuccess(data);
                continue;
            }
            int startScheduleId = this.calculateStartScheduleId(data.getScheduleId());
            DateTime day = this.dateTimeService.get24HourTimeSlice(collectionTimeSlice);
            StorageResultSetFuture rawFuture = this.dao.insertRawData(data);
            StorageResultSetFuture cacheFuture = this.dao.updateMetricsCache(MetricsTable.RAW, collectionTimeSlice.getMillis(), startScheduleId, data.getScheduleId(), data.getTimestamp(), (Map<Integer, Double>)ImmutableMap.of((Object)AggregateType.VALUE.ordinal(), (Object)data.getValue()));
            StorageResultSetFuture indexFuture = this.dao.updateCacheIndex(MetricsTable.RAW, day.getMillis(), 0, collectionTimeSlice.getMillis(), startScheduleId, insertTimeSlice.getMillis(), (Set<Integer>)ImmutableSet.of((Object)data.getScheduleId()));
            ListenableFuture insertsFuture = Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{rawFuture, cacheFuture, indexFuture});
            Futures.addCallback((ListenableFuture)insertsFuture, (FutureCallback)new FutureCallback<List<ResultSet>>(){

                public void onSuccess(List<ResultSet> result) {
                    callback.onSuccess(data);
                    if (remainingInserts.decrementAndGet() == 0) {
                        stopwatch.stop();
                        if (MetricsServer.this.log.isDebugEnabled()) {
                            MetricsServer.this.log.debug((Object)("Finished inserting " + dataSet.size() + " raw metrics in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
                        }
                        callback.onFinish();
                    }
                }

                public void onFailure(Throwable t) {
                    if (MetricsServer.this.log.isDebugEnabled()) {
                        MetricsServer.this.log.debug((Object)"An error occurred while inserting raw data", ThrowableUtil.getRootCause((Throwable)t));
                    } else {
                        MetricsServer.this.log.warn((Object)("An error occurred while inserting raw data: " + ThrowableUtil.getRootMessage((Throwable)t)));
                    }
                    callback.onFailure(t);
                }
            }, (Executor)this.aggregationWorkers);
        }
    }

    private int calculateStartScheduleId(int scheduleId) {
        return scheduleId / this.cacheBatchSize * this.cacheBatchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<AggregateNumericMetric> calculateAggregates() {
        Stopwatch stopwatch = new Stopwatch().start();
        try {
            AggregationManager aggregator;
            DateTime theHour = this.dateTimeService.currentHour();
            if (this.pastAggregationMissed) {
                DateTime missedHour = this.roundDownToHour(this.mostRecentRawDataPriorToStartup);
                aggregator = new AggregationManager(this.aggregationWorkers, this.dao, this.dateTimeService, missedHour, this.aggregationBatchSize, this.parallelism, this.cacheBatchSize, this.configuration.getIndexPageSize());
                aggregator.setCacheActivationTime(this.cacheActivationTime);
                this.pastAggregationMissed = false;
            }
            DateTime timeSlice = theHour.minus((ReadableDuration)this.configuration.getRawTimeSliceDuration());
            aggregator = new AggregationManager(this.aggregationWorkers, this.dao, this.dateTimeService, timeSlice, this.aggregationBatchSize, this.parallelism, this.cacheBatchSize, this.configuration.getIndexPageSize());
            aggregator.setCacheActivationTime(this.cacheActivationTime);
            Set<AggregateNumericMetric> set = aggregator.run();
            return set;
        }
        finally {
            stopwatch.stop();
            this.totalAggregationTime.addAndGet(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            this.log.info((Object)("Finished metrics aggregation in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
        }
    }

    private AggregateNumericMetric calculateAggregatedRaw(Iterable<RawNumericMetric> rawMetrics, long timestamp) {
        double min;
        double max = min = Double.NaN;
        int count = 0;
        ArithmeticMeanCalculator mean = new ArithmeticMeanCalculator();
        for (RawNumericMetric metric : rawMetrics) {
            double value = metric.getValue();
            if (count == 0) {
                max = min = value;
            }
            if (value < min) {
                min = value;
            } else if (value > max) {
                max = value;
            }
            mean.add(value);
            ++count;
        }
        return new AggregateNumericMetric(0, mean.getArithmeticMean(), min, max, timestamp);
    }

    private AggregateNumericMetric calculateAggregate(Iterable<AggregateNumericMetric> metrics, long timestamp) {
        double min;
        double max = min = Double.NaN;
        int count = 0;
        ArithmeticMeanCalculator mean = new ArithmeticMeanCalculator();
        for (AggregateNumericMetric metric : metrics) {
            if (count == 0) {
                min = metric.getMin();
                max = metric.getMax();
            }
            if (metric.getMin() < min) {
                min = metric.getMin();
            }
            if (metric.getMax() > max) {
                max = metric.getMax();
            }
            mean.add(metric.getAvg());
            ++count;
        }
        return new AggregateNumericMetric(0, mean.getArithmeticMean(), min, max, timestamp);
    }
}

