/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.rhq.server.metrics.CacheMapper;
import org.rhq.server.metrics.domain.AggregateType;
import org.rhq.server.metrics.domain.RawNumericMetric;

public class RawCacheMapper
implements CacheMapper<RawNumericMetric> {
    @Override
    public RawNumericMetric map(Row row) {
        return new RawNumericMetric(this.getScheduleId(row), this.getTimestamp(row), this.getValue(row));
    }

    @Override
    public List<RawNumericMetric> map(ResultSet resultSet) {
        ArrayList<RawNumericMetric> metrics = new ArrayList<RawNumericMetric>();
        for (Row row : resultSet) {
            metrics.add(this.map(row));
        }
        return metrics;
    }

    private int getScheduleId(Row row) {
        return row.getInt(0);
    }

    private long getTimestamp(Row row) {
        return row.getDate(1).getTime();
    }

    private Double getValue(Row row) {
        Map values = row.getMap(2, Integer.class, Double.class);
        return (Double)values.get(AggregateType.VALUE.ordinal());
    }
}

