/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StorageClientThreadFactory
implements ThreadFactory,
Thread.UncaughtExceptionHandler {
    private final Log log;
    private AtomicInteger threadNumber = new AtomicInteger(0);
    private String poolName = "StorageClientThreadPool";

    public StorageClientThreadFactory() {
        this.log = LogFactory.getLog((String)this.poolName);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, this.poolName + "-" + this.threadNumber.getAndIncrement());
        t.setDaemon(false);
        t.setUncaughtExceptionHandler(this);
        return t;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.log.error((Object)("Uncaught exception on scheduled thread [" + t.getName() + "]"), e);
    }
}

