/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.aggregation;

import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.rhq.server.metrics.AbortedException;
import org.rhq.server.metrics.DateTimeService;
import org.rhq.server.metrics.MetricsDAO;
import org.rhq.server.metrics.aggregation.AggregationType;
import org.rhq.server.metrics.aggregation.CacheAggregator;
import org.rhq.server.metrics.aggregation.IndexAggregatesPair;
import org.rhq.server.metrics.aggregation.PastDataAggregator;
import org.rhq.server.metrics.aggregation.PersistFunctions;
import org.rhq.server.metrics.domain.AggregateNumericMetric;
import org.rhq.server.metrics.domain.AggregateNumericMetricMapper;
import org.rhq.server.metrics.domain.RawNumericMetricMapper;

public class AggregationManager {
    public static final int INDEX_PARTITION = 0;
    private static final Comparator<AggregateNumericMetric> AGGREGATE_COMPARATOR = new Comparator<AggregateNumericMetric>(){

        @Override
        public int compare(AggregateNumericMetric left, AggregateNumericMetric right) {
            return left.getScheduleId() < right.getScheduleId() ? -1 : (left.getScheduleId() == right.getScheduleId() ? 0 : 1);
        }
    };
    private final Log log = LogFactory.getLog(AggregationManager.class);
    private MetricsDAO dao;
    private DateTimeService dtService;
    private DateTime startTime;
    private ListeningExecutorService aggregationTasks;
    private Set<AggregateNumericMetric> oneHourData;
    private int cacheBatchSize;
    private Semaphore permits;
    private long cacheActivationTime;
    private int indexPageSize;

    public AggregationManager(ListeningExecutorService aggregationTasks, MetricsDAO dao, DateTimeService dtService, DateTime startTime, int batchSize, int parallelism, int cacheBatchSize, int indexPageSize) {
        this.dao = dao;
        this.dtService = dtService;
        this.startTime = startTime;
        this.oneHourData = new ConcurrentSkipListSet<AggregateNumericMetric>(AGGREGATE_COMPARATOR);
        this.cacheBatchSize = cacheBatchSize;
        this.permits = new Semaphore(batchSize * parallelism);
        this.aggregationTasks = aggregationTasks;
        this.indexPageSize = indexPageSize;
    }

    private boolean is6HourTimeSliceFinished() {
        return this.dtService.is6HourTimeSliceFinished(this.startTime);
    }

    private boolean is24HourTimeSliceFinished() {
        return this.dtService.is24HourTimeSliceFinished(this.startTime);
    }

    public void setCacheActivationTime(long cacheActivationTime) {
        this.cacheActivationTime = cacheActivationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AggregateNumericMetric> run() {
        this.log.info((Object)("Starting aggregation for time slice " + this.startTime));
        Stopwatch stopwatch = new Stopwatch().start();
        int numRaw = 0;
        int num1Hour = 0;
        int num6Hour = 0;
        try {
            PersistFunctions persistFunctions = new PersistFunctions(this.dao, this.dtService);
            Map<AggregationType, Integer> counts = this.createPastDataAggregator(persistFunctions).execute();
            numRaw += counts.get((Object)AggregationType.RAW).intValue();
            num1Hour += counts.get((Object)AggregationType.ONE_HOUR).intValue();
            num6Hour += counts.get((Object)AggregationType.SIX_HOUR).intValue();
            counts = this.createRawAggregator(persistFunctions).execute();
            numRaw += counts.get((Object)AggregationType.RAW).intValue();
            if (this.is6HourTimeSliceFinished()) {
                counts = this.create1HourAggregator(persistFunctions).execute();
                num1Hour += counts.get((Object)AggregationType.ONE_HOUR).intValue();
            }
            if (this.is24HourTimeSliceFinished()) {
                counts = this.create6HourAggregator(persistFunctions).execute();
                num6Hour += counts.get((Object)AggregationType.SIX_HOUR).intValue();
            }
            Set<AggregateNumericMetric> set = this.oneHourData;
            return set;
        }
        catch (InterruptedException e) {
            this.log.info((Object)"There was an interrupt while waiting for aggregation to finish. Aggregation will be aborted.");
            Set<AggregateNumericMetric> set = Collections.emptySet();
            return set;
        }
        catch (AbortedException e) {
            this.log.warn((Object)("Aggregation has been aborted: " + e.getMessage()));
            Set<AggregateNumericMetric> set = Collections.emptySet();
            return set;
        }
        finally {
            stopwatch.stop();
            this.log.info((Object)("Finished aggregation of {\"raw schedules\": " + numRaw + ", \"1 hour schedules\": " + num1Hour + ", \"6 hour schedules\": " + num6Hour + "} in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
        }
    }

    private PastDataAggregator createPastDataAggregator(PersistFunctions persistFunctions) {
        PastDataAggregator aggregator = new PastDataAggregator();
        aggregator.setAggregationTasks(this.aggregationTasks);
        aggregator.setAggregationType(AggregationType.RAW);
        aggregator.setCurrentDay(this.dtService.get24HourTimeSlice(this.startTime));
        aggregator.setDao(this.dao);
        aggregator.setPermits(this.permits);
        aggregator.setStartingDay(this.dtService.get24HourTimeSlice(this.startTime).minusDays(1));
        aggregator.setStartTime(this.startTime);
        aggregator.setDateTimeService(this.dtService);
        aggregator.setPersistFns(persistFunctions);
        aggregator.setPersistMetrics(persistFunctions.persist1HourMetricsAndUpdateCache());
        aggregator.setCacheActive(this.isCacheActive());
        aggregator.setIndexPageSize(this.indexPageSize);
        return aggregator;
    }

    private CacheAggregator createRawAggregator(PersistFunctions persistFunctions) {
        CacheAggregator aggregator = new CacheAggregator();
        aggregator.setAggregationTasks(this.aggregationTasks);
        aggregator.setAggregationType(AggregationType.RAW);
        aggregator.setDao(this.dao);
        aggregator.setPermits(this.permits);
        aggregator.setStartTime(this.startTime);
        aggregator.setCurrentDay(this.dtService.get24HourTimeSlice(this.startTime));
        aggregator.setDateTimeService(this.dtService);
        aggregator.setPersistMetrics(persistFunctions.persist1HourMetricsAndUpdateCache());
        aggregator.setCacheBlockFinishedListener(new CacheAggregator.CacheBlockFinishedListener(){

            @Override
            public void onFinish(IndexAggregatesPair pair) {
                AggregationManager.this.oneHourData.addAll(pair.metrics);
            }
        });
        aggregator.setCacheActive(this.isCacheActive());
        aggregator.setResultSetMapper(new RawNumericMetricMapper());
        aggregator.setIndexPageSize(this.indexPageSize);
        return aggregator;
    }

    private CacheAggregator create1HourAggregator(PersistFunctions persistFunctions) {
        CacheAggregator aggregator = new CacheAggregator();
        aggregator.setAggregationTasks(this.aggregationTasks);
        aggregator.setAggregationType(AggregationType.ONE_HOUR);
        aggregator.setDao(this.dao);
        aggregator.setPermits(this.permits);
        aggregator.setStartTime(this.dtService.get6HourTimeSlice(this.startTime));
        aggregator.setCurrentDay(this.dtService.get24HourTimeSlice(this.startTime));
        aggregator.setDateTimeService(this.dtService);
        aggregator.setPersistMetrics(persistFunctions.persist6HourMetricsAndUpdateCache());
        aggregator.setCacheActive(this.isCacheActive());
        aggregator.setResultSetMapper(new AggregateNumericMetricMapper());
        aggregator.setIndexPageSize(this.indexPageSize);
        return aggregator;
    }

    private CacheAggregator create6HourAggregator(PersistFunctions persistFunctions) {
        CacheAggregator aggregator = new CacheAggregator();
        aggregator.setAggregationTasks(this.aggregationTasks);
        aggregator.setAggregationType(AggregationType.SIX_HOUR);
        aggregator.setDao(this.dao);
        aggregator.setPermits(this.permits);
        aggregator.setStartTime(this.dtService.get24HourTimeSlice(this.startTime));
        aggregator.setCurrentDay(this.dtService.get24HourTimeSlice(this.startTime));
        aggregator.setDateTimeService(this.dtService);
        aggregator.setPersistMetrics(persistFunctions.persist24HourMetrics());
        aggregator.setCacheActive(this.isCacheActive());
        aggregator.setResultSetMapper(new AggregateNumericMetricMapper());
        aggregator.setIndexPageSize(this.indexPageSize);
        return aggregator;
    }

    private boolean isCacheActive() {
        return this.startTime.getMillis() >= this.cacheActivationTime;
    }
}

