/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.aggregation;

import java.util.ArrayList;
import java.util.List;
import org.rhq.core.util.exception.ThrowableUtil;

class BatchException
extends Exception {
    private int startScheduleId;
    private List<Throwable> errors;

    public BatchException(int startScheduleId, List<Throwable> errors) {
        this.startScheduleId = startScheduleId;
        this.errors = errors;
    }

    int getStartScheduleId() {
        return this.startScheduleId;
    }

    List<Throwable> getErrors() {
        return this.errors;
    }

    List<String> getErrorMessages() {
        ArrayList<String> messages = new ArrayList<String>(this.errors.size());
        for (Throwable error : this.errors) {
            messages.add(ThrowableUtil.getRootMessage((Throwable)error));
        }
        return messages;
    }

    List<Throwable> getRootCauses() {
        ArrayList<Throwable> rootCauses = new ArrayList<Throwable>(this.errors.size());
        for (Throwable error : this.errors) {
            rootCauses.add(ThrowableUtil.getRootCause((Throwable)error));
        }
        return rootCauses;
    }
}

