/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.aggregation;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.rhq.server.metrics.CacheMapper;
import org.rhq.server.metrics.domain.NumericMetric;

class CacheIterator<T extends NumericMetric>
implements Iterator<List<T>> {
    private CacheMapper<T> mapper;
    private T currentMetric;
    private Iterator<Row> rowIterator;

    public CacheIterator(CacheMapper<T> mapper, ResultSet resultSet) {
        this.mapper = mapper;
        this.rowIterator = resultSet.iterator();
        if (this.rowIterator.hasNext()) {
            this.currentMetric = mapper.map(this.rowIterator.next());
        }
    }

    @Override
    public boolean hasNext() {
        return this.rowIterator.hasNext() || this.currentMetric != null;
    }

    @Override
    public List<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ArrayList<T> metrics = new ArrayList<T>();
        metrics.add(this.currentMetric);
        while (this.rowIterator.hasNext()) {
            T nextMetric = this.mapper.map(this.rowIterator.next());
            if (this.currentMetric.getScheduleId() == nextMetric.getScheduleId()) {
                this.currentMetric = nextMetric;
                metrics.add(this.currentMetric);
                continue;
            }
            this.currentMetric = nextMetric;
            return metrics;
        }
        this.currentMetric = null;
        return metrics;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

