/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.aggregation;

import com.datastax.driver.core.ResultSet;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.rhq.server.metrics.aggregation.CombinedMetricsPair;
import org.rhq.server.metrics.domain.AggregateNumericMetric;
import org.rhq.server.metrics.domain.AggregateNumericMetricMapper;

class CombinedMetricsIterator
implements Iterator<List<AggregateNumericMetric>> {
    private Iterator<List<AggregateNumericMetric>> iterator;

    public CombinedMetricsIterator(List<CombinedMetricsPair> pairs) {
        Preconditions.checkArgument((!pairs.isEmpty() ? 1 : 0) != 0);
        ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>(pairs.size());
        ArrayList<AggregateNumericMetric> metrics = new ArrayList<AggregateNumericMetric>(pairs.size());
        for (CombinedMetricsPair pair : pairs) {
            resultSets.add(pair.resultSet);
            metrics.add(pair.metric);
        }
        List<List<AggregateNumericMetric>> combinedMetrics = this.combine(resultSets, metrics);
        this.iterator = combinedMetrics.iterator();
    }

    private List<List<AggregateNumericMetric>> combine(List<ResultSet> resultSets, List<AggregateNumericMetric> inMemoryMetrics) {
        ArrayList<List<AggregateNumericMetric>> combinedMetrics = new ArrayList<List<AggregateNumericMetric>>();
        AggregateNumericMetricMapper mapper = new AggregateNumericMetricMapper();
        for (ResultSet resultSet : resultSets) {
            AggregateNumericMetric inMemoryMetric;
            if (resultSet.isExhausted()) continue;
            List<AggregateNumericMetric> metricsFromDB = mapper.mapAll(resultSet);
            int scheduleId = metricsFromDB.get(0).getScheduleId();
            int index = this.findIndex(scheduleId, inMemoryMetrics);
            if (index != -1 && !metricsFromDB.contains(inMemoryMetric = inMemoryMetrics.remove(index))) {
                metricsFromDB.add(inMemoryMetric);
            }
            combinedMetrics.add(metricsFromDB);
        }
        return combinedMetrics;
    }

    private int findIndex(int scheduleId, List<AggregateNumericMetric> metrics) {
        int i = 0;
        for (AggregateNumericMetric metric : metrics) {
            if (metric.getScheduleId() == scheduleId) break;
            ++i;
        }
        return i;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public List<AggregateNumericMetric> next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

