/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.domain;

import org.joda.time.Duration;

public enum MetricsTable {
    METRICS_CACHE("metrics_cache", -1),
    METRICS_CACHE_INDEX("metrics_cache_index", -1),
    RAW("raw_metrics", Duration.standardDays((long)7L).toStandardSeconds().getSeconds()),
    ONE_HOUR("one_hour_metrics", Duration.standardDays((long)14L).toStandardSeconds().getSeconds()),
    SIX_HOUR("six_hour_metrics", Duration.standardDays((long)31L).toStandardSeconds().getSeconds()),
    TWENTY_FOUR_HOUR("twenty_four_hour_metrics", Duration.standardDays((long)365L).toStandardSeconds().getSeconds());

    private final String tableName;
    private final int ttl;

    public static MetricsTable fromString(String table) {
        if (table.equals(MetricsTable.METRICS_CACHE.tableName)) {
            return METRICS_CACHE;
        }
        if (table.equals(MetricsTable.METRICS_CACHE_INDEX.tableName)) {
            return METRICS_CACHE_INDEX;
        }
        if (table.equals(MetricsTable.RAW.tableName)) {
            return RAW;
        }
        if (table.equals(MetricsTable.ONE_HOUR.tableName)) {
            return ONE_HOUR;
        }
        if (table.equals(MetricsTable.SIX_HOUR.tableName)) {
            return SIX_HOUR;
        }
        if (table.equals(MetricsTable.TWENTY_FOUR_HOUR.tableName)) {
            return TWENTY_FOUR_HOUR;
        }
        throw new IllegalArgumentException(table + " is not a recognized table name");
    }

    private MetricsTable(String tableName, int ttl) {
        this.tableName = tableName;
        this.ttl = ttl;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getTTL() {
        return this.ttl;
    }

    public long getTTLinMilliseconds() {
        return (long)this.ttl * 1000L;
    }

    public String toString() {
        return this.tableName;
    }
}

