/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics;

import com.datastax.driver.core.ResultSet;
import com.google.common.base.Function;
import java.util.List;
import org.rhq.server.metrics.ArithmeticMeanCalculator;
import org.rhq.server.metrics.domain.AggregateNumericMetric;
import org.rhq.server.metrics.domain.Bucket;
import org.rhq.server.metrics.domain.RawNumericMetric;
import org.rhq.server.metrics.domain.RawNumericMetricMapper;

public class ComputeRawAggregate
implements Function<ResultSet, AggregateNumericMetric> {
    private RawNumericMetricMapper mapper;
    private long timestamp;

    public ComputeRawAggregate(long timestamp) {
        this.timestamp = timestamp;
        this.mapper = new RawNumericMetricMapper();
    }

    public AggregateNumericMetric apply(ResultSet resultSet) {
        double min;
        List<RawNumericMetric> rawMetrics = this.mapper.mapAll(resultSet);
        double max = min = Double.NaN;
        int count = 0;
        ArithmeticMeanCalculator mean = new ArithmeticMeanCalculator();
        for (RawNumericMetric metric : rawMetrics) {
            double value = metric.getValue();
            if (count == 0) {
                max = min = value;
            }
            if (value < min) {
                min = value;
            } else if (value > max) {
                max = value;
            }
            mean.add(value);
            ++count;
        }
        return new AggregateNumericMetric(0, Bucket.ONE_HOUR, mean.getArithmeticMean(), min, max, this.timestamp);
    }
}

