/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.aggregation;

import com.datastax.driver.core.ResultSet;
import com.google.common.base.Objects;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.joda.time.DateTime;
import org.rhq.server.metrics.domain.Bucket;
import org.rhq.server.metrics.domain.IndexEntry;

public class Batch
implements Iterable<IndexEntry> {
    private DateTime startTime;
    private DateTime endTime;
    private List<IndexEntry> indexEntries = new ArrayList<IndexEntry>();
    private Bucket targetBucket;
    private ListenableFuture<List<ResultSet>> queriesFuture;

    public DateTime getStartTime() {
        return this.startTime;
    }

    public Batch setStartTime(long timestamp) {
        this.startTime = new DateTime(timestamp);
        return this;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public Batch setEndTime(DateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public List<IndexEntry> getIndexEntries() {
        return this.indexEntries;
    }

    public Batch add(IndexEntry indexEntry) {
        this.indexEntries.add(indexEntry);
        return this;
    }

    public int size() {
        return this.indexEntries.size();
    }

    public ListenableFuture<List<ResultSet>> getQueriesFuture() {
        return this.queriesFuture;
    }

    public Batch setQueriesFuture(ListenableFuture<List<ResultSet>> queriesFuture) {
        this.queriesFuture = queriesFuture;
        return this;
    }

    @Override
    public Iterator<IndexEntry> iterator() {
        return this.indexEntries.iterator();
    }

    public String toString() {
        return Objects.toStringHelper(Batch.class).add("startTime", (Object)this.startTime).add("endTime", (Object)this.endTime).add("indexEntries", this.indexEntries).toString();
    }
}

