/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.aggregation;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.rhq.server.metrics.MetricsConfiguration;
import org.rhq.server.metrics.MetricsDAO;
import org.rhq.server.metrics.domain.IndexBucket;
import org.rhq.server.metrics.domain.IndexEntry;

public class IndexIterator
implements Iterator<IndexEntry> {
    private static final Log log = LogFactory.getLog(IndexIterator.class);
    private static final ResultSet EMPTY_RESULT_SET = new ResultSet(){

        public ColumnDefinitions getColumnDefinitions() {
            return null;
        }

        public boolean isExhausted() {
            return true;
        }

        public Row one() {
            return null;
        }

        public List<Row> all() {
            return Collections.emptyList();
        }

        public Iterator<Row> iterator() {
            return null;
        }

        public ExecutionInfo getExecutionInfo() {
            return null;
        }
    };
    private DateTime time;
    private Duration duration;
    private DateTime endTime;
    private IndexBucket bucket;
    private MetricsDAO dao;
    private Iterator<Row> rowIterator;
    private int numPartitions;
    private int partition;
    private int pageSize;
    private int lastScheduleId;
    private int rowCount;

    public IndexIterator(DateTime startTime, DateTime endTime, IndexBucket bucket, MetricsDAO dao, MetricsConfiguration configuration) {
        this.time = startTime;
        this.endTime = endTime;
        this.bucket = bucket;
        this.dao = dao;
        this.numPartitions = configuration.getIndexPartitions();
        this.pageSize = configuration.getIndexPageSize();
        switch (bucket) {
            case RAW: {
                this.duration = configuration.getRawTimeSliceDuration();
                break;
            }
            case ONE_HOUR: {
                this.duration = configuration.getOneHourTimeSliceDuration();
                break;
            }
            default: {
                this.duration = configuration.getSixHourTimeSliceDuration();
            }
        }
        this.loadPage();
    }

    @Override
    public boolean hasNext() {
        return this.rowIterator.hasNext();
    }

    @Override
    public IndexEntry next() {
        Row row = this.rowIterator.next();
        this.lastScheduleId = row.getInt(0);
        IndexEntry indexEntry = new IndexEntry(this.bucket, this.partition, this.time.getMillis(), this.lastScheduleId);
        if (!this.rowIterator.hasNext()) {
            this.loadPage();
        }
        return indexEntry;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void loadPage() {
        if (this.rowIterator == null) {
            this.nextPage(this.findIndexEntries());
        } else if (this.rowCount < this.pageSize) {
            ++this.partition;
            this.nextPage(this.findIndexEntries());
        } else {
            this.nextPage(this.findIndexEntriesAfterScheduleId());
        }
    }

    private void nextPage(ResultSet resultSet) {
        ResultSet nextResultSet = resultSet;
        while (nextResultSet.isExhausted() && this.time.isBefore((ReadableInstant)this.endTime)) {
            if (this.partition < this.numPartitions - 1) {
                ++this.partition;
            } else {
                this.partition = 0;
                this.time = this.time.plus((ReadableDuration)this.duration);
            }
            nextResultSet = this.findIndexEntries();
        }
        if (this.time.isBefore((ReadableInstant)this.endTime)) {
            List rows = nextResultSet.all();
            this.rowCount = rows.size();
            this.rowIterator = rows.iterator();
        } else {
            this.rowCount = 0;
            this.rowIterator = Iterators.emptyIterator();
        }
    }

    private ResultSet findIndexEntries() {
        try {
            return this.dao.findIndexEntries(this.bucket, this.partition, this.time.getMillis()).get();
        }
        catch (ReadTimeoutException e) {
            log.warn((Object)("There was a read timeout while querying the index with {bucket: " + (Object)((Object)this.bucket) + ", partition: " + this.partition + ", time: " + this.time + "}"), (Throwable)e);
            return EMPTY_RESULT_SET;
        }
    }

    private ResultSet findIndexEntriesAfterScheduleId() {
        try {
            return this.dao.findIndexEntries(this.bucket, this.partition, this.time.getMillis(), this.lastScheduleId).get();
        }
        catch (ReadTimeoutException e) {
            log.warn((Object)("There was a read timeout while querying the index with {bucket: " + (Object)((Object)this.bucket) + ", partition: " + this.partition + ", time: " + this.time + ", lastScheduleId: " + this.lastScheduleId + "}"), (Throwable)e);
            return EMPTY_RESULT_SET;
        }
    }
}

