/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.aggregation;

import com.datastax.driver.core.ResultSet;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.rhq.server.metrics.DateTimeService;
import org.rhq.server.metrics.MetricsDAO;
import org.rhq.server.metrics.StorageResultSetFuture;
import org.rhq.server.metrics.domain.AggregateNumericMetric;
import org.rhq.server.metrics.domain.IndexBucket;

class PersistFunctions {
    private MetricsDAO dao;
    private DateTimeService dateTimeService;
    private AsyncFunction<List<AggregateNumericMetric>, List<ResultSet>> persist1HourMetrics;
    private AsyncFunction<List<AggregateNumericMetric>, List<ResultSet>> persist6HourMetrics;
    private AsyncFunction<List<AggregateNumericMetric>, List<ResultSet>> persist24HourMetrics;

    public PersistFunctions(MetricsDAO dao, DateTimeService dateTimeService) {
        this.dao = dao;
        this.dateTimeService = dateTimeService;
        this.initFunctions();
    }

    private void initFunctions() {
        this.persist1HourMetrics = new AsyncFunction<List<AggregateNumericMetric>, List<ResultSet>>(){

            public ListenableFuture<List<ResultSet>> apply(List<AggregateNumericMetric> metrics) throws Exception {
                ArrayList<StorageResultSetFuture> futures = new ArrayList<StorageResultSetFuture>(metrics.size());
                for (AggregateNumericMetric metric : metrics) {
                    DateTime timeSlice = PersistFunctions.this.dateTimeService.get6HourTimeSlice(metric.getTimestamp());
                    futures.add(PersistFunctions.this.dao.insert1HourData(metric));
                    futures.add(PersistFunctions.this.dao.updateIndex(IndexBucket.ONE_HOUR, timeSlice.getMillis(), metric.getScheduleId()));
                }
                return Futures.allAsList(futures);
            }
        };
        this.persist6HourMetrics = new AsyncFunction<List<AggregateNumericMetric>, List<ResultSet>>(){

            public ListenableFuture<List<ResultSet>> apply(List<AggregateNumericMetric> metrics) throws Exception {
                ArrayList<StorageResultSetFuture> futures = new ArrayList<StorageResultSetFuture>(metrics.size());
                for (AggregateNumericMetric metric : metrics) {
                    DateTime timeSlice = PersistFunctions.this.dateTimeService.get24HourTimeSlice(metric.getTimestamp());
                    futures.add(PersistFunctions.this.dao.insert6HourData(metric));
                    futures.add(PersistFunctions.this.dao.updateIndex(IndexBucket.SIX_HOUR, timeSlice.getMillis(), metric.getScheduleId()));
                }
                return Futures.allAsList(futures);
            }
        };
        this.persist24HourMetrics = new AsyncFunction<List<AggregateNumericMetric>, List<ResultSet>>(){

            public ListenableFuture<List<ResultSet>> apply(List<AggregateNumericMetric> metrics) throws Exception {
                ArrayList<StorageResultSetFuture> futures = new ArrayList<StorageResultSetFuture>(metrics.size());
                for (AggregateNumericMetric metric : metrics) {
                    futures.add(PersistFunctions.this.dao.insert24HourData(metric));
                }
                return Futures.allAsList(futures);
            }
        };
    }

    public AsyncFunction<List<AggregateNumericMetric>, List<ResultSet>> persist1HourMetrics() {
        return this.persist1HourMetrics;
    }

    public AsyncFunction<List<AggregateNumericMetric>, List<ResultSet>> persist6HourMetrics() {
        return this.persist6HourMetrics;
    }

    public AsyncFunction<List<AggregateNumericMetric>, List<ResultSet>> persist24HourMetrics() {
        return this.persist24HourMetrics;
    }
}

