/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.domain;

import com.google.common.base.Objects;
import org.joda.time.DateTime;
import org.rhq.server.metrics.domain.IndexBucket;

public class IndexEntry {
    private IndexBucket bucket;
    private int partition;
    private long timestamp;
    private int scheduleId;

    public IndexEntry() {
    }

    public IndexEntry(IndexBucket bucket, int partition, long timestamp, int scheduleId) {
        this.bucket = bucket;
        this.partition = partition;
        this.timestamp = timestamp;
        this.scheduleId = scheduleId;
    }

    public IndexEntry(IndexBucket bucket, int partition, DateTime time, int scheduleId) {
        this(bucket, partition, time.getMillis(), scheduleId);
    }

    public IndexBucket getBucket() {
        return this.bucket;
    }

    public void setBucket(IndexBucket bucket) {
        this.bucket = bucket;
    }

    public int getPartition() {
        return this.partition;
    }

    public void setPartition(int partition) {
        this.partition = partition;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(int scheduleId) {
        this.scheduleId = scheduleId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexEntry that = (IndexEntry)o;
        if (this.partition != that.partition) {
            return false;
        }
        if (this.scheduleId != that.scheduleId) {
            return false;
        }
        if (this.timestamp != that.timestamp) {
            return false;
        }
        return this.bucket == that.bucket;
    }

    public int hashCode() {
        int result = this.bucket.hashCode();
        result = 31 * result + this.partition;
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.scheduleId;
        return result;
    }

    public String toString() {
        return Objects.toStringHelper(IndexEntry.class).add("bucket", (Object)this.bucket).add("partition", this.partition).add("time", this.timestamp).add("scheduleId", this.scheduleId).toString();
    }
}

