/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.MeasurementBaseline;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.server.metrics.ArithmeticMeanCalculator;
import org.rhq.server.metrics.MetricsDAO;
import org.rhq.server.metrics.domain.AggregateSimpleNumericMetric;
import org.rhq.server.metrics.domain.AggregateType;

public class MetricsBaselineCalculator {
    private final Log log = LogFactory.getLog(MetricsBaselineCalculator.class);
    private MetricsDAO metricsDAO;

    public MetricsBaselineCalculator(MetricsDAO metricsDAO) {
        this.metricsDAO = metricsDAO;
    }

    public List<MeasurementBaseline> calculateBaselines(List<MeasurementSchedule> schedules, long startTime, long endTime) {
        ArrayList<MeasurementBaseline> calculatedBaselines = new ArrayList<MeasurementBaseline>();
        for (MeasurementSchedule schedule : schedules) {
            MeasurementBaseline measurementBaseline = this.calculateBaseline(schedule, startTime, endTime);
            if (measurementBaseline == null) continue;
            calculatedBaselines.add(measurementBaseline);
        }
        return calculatedBaselines;
    }

    private MeasurementBaseline calculateBaseline(MeasurementSchedule schedule, long startTime, long endTime) {
        Iterable<AggregateSimpleNumericMetric> metrics = this.metricsDAO.findAggregatedSimpleOneHourMetric(schedule.getId(), startTime, endTime);
        if (metrics != null && metrics.iterator() != null && metrics.iterator().hasNext()) {
            ArithmeticMeanCalculator mean = new ArithmeticMeanCalculator();
            double max = Double.NaN;
            for (AggregateSimpleNumericMetric entry : metrics) {
                if (!AggregateType.MAX.equals((Object)entry.getType())) continue;
                max = entry.getValue();
                break;
            }
            double min = Double.NaN;
            for (AggregateSimpleNumericMetric entry : metrics) {
                if (!AggregateType.MIN.equals((Object)entry.getType())) continue;
                min = entry.getValue();
                break;
            }
            for (AggregateSimpleNumericMetric entry : metrics) {
                if (AggregateType.AVG.equals((Object)entry.getType())) {
                    mean.add(entry.getValue());
                    continue;
                }
                if (AggregateType.MAX.equals((Object)entry.getType())) {
                    if (!(max < entry.getValue())) continue;
                    max = entry.getValue();
                    continue;
                }
                if (!AggregateType.MIN.equals((Object)entry.getType()) || !(min > entry.getValue())) continue;
                min = entry.getValue();
            }
            MeasurementBaseline baseline = new MeasurementBaseline();
            baseline.setMax(Double.valueOf(max));
            baseline.setMin(Double.valueOf(min));
            baseline.setMean(Double.valueOf(mean.getArithmeticMean()));
            baseline.setSchedule(schedule);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Calculated baseline: " + baseline.toString()));
            }
            return baseline;
        }
        MeasurementBaseline baseline = new MeasurementBaseline();
        baseline.setMax(Double.valueOf(Double.NaN));
        baseline.setMin(Double.valueOf(Double.NaN));
        baseline.setMean(Double.valueOf(Double.NaN));
        baseline.setSchedule(schedule);
        return baseline;
    }
}

