/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.server.metrics.CQLException;
import org.rhq.server.metrics.MetricResultFuture;
import org.rhq.server.metrics.MetricsConfiguration;
import org.rhq.server.metrics.domain.AggregateNumericMetric;
import org.rhq.server.metrics.domain.AggregateNumericMetricMapper;
import org.rhq.server.metrics.domain.AggregateSimpleNumericMetric;
import org.rhq.server.metrics.domain.AggregateSimpleNumericMetricMapper;
import org.rhq.server.metrics.domain.AggregateType;
import org.rhq.server.metrics.domain.ListPagedResult;
import org.rhq.server.metrics.domain.MetricsIndexEntry;
import org.rhq.server.metrics.domain.MetricsIndexEntryMapper;
import org.rhq.server.metrics.domain.MetricsTable;
import org.rhq.server.metrics.domain.RawNumericMetric;
import org.rhq.server.metrics.domain.RawNumericMetricMapper;
import org.rhq.server.metrics.domain.SimplePagedResult;

public class MetricsDAO {
    private final Log log = LogFactory.getLog(MetricsDAO.class);
    private Session session;
    private MetricsConfiguration configuration;
    private PreparedStatement insertRawData;
    private PreparedStatement rawMetricsQuery;
    private PreparedStatement updateMetricsIndex;
    private PreparedStatement insertOneHourData;
    private PreparedStatement insertSixHourData;
    private PreparedStatement insertTwentyFourHourData;
    private PreparedStatement findLatestRawMetric;
    private PreparedStatement findRawMetrics;
    private PreparedStatement findOneHourMetricsByDateRange;
    private PreparedStatement findSixHourMetricsByDateRange;
    private PreparedStatement findTwentyFourHourMetricsByDateRange;
    private PreparedStatement findIndexEntries;
    private PreparedStatement findTimeSliceForIndex;
    private PreparedStatement deleteIndexEntries;

    public MetricsDAO(Session session, MetricsConfiguration configuration) {
        this.session = session;
        this.configuration = configuration;
        this.initPreparedStatements();
    }

    public void initPreparedStatements() {
        this.log.info((Object)"Initializing prepared statements");
        long startTime = System.currentTimeMillis();
        this.insertRawData = this.session.prepare("INSERT INTO " + (Object)((Object)MetricsTable.RAW) + " (schedule_id, time, value) VALUES (?, ?, ?) USING TTL " + this.configuration.getRawTTL());
        this.rawMetricsQuery = this.session.prepare("SELECT schedule_id, time, value FROM " + (Object)((Object)MetricsTable.RAW) + " WHERE schedule_id = ? AND time >= ? AND time < ? ORDER BY time");
        this.insertOneHourData = this.session.prepare("INSERT INTO " + (Object)((Object)MetricsTable.ONE_HOUR) + "(schedule_id, time, " + "type, value) VALUES (?, ?, ?, ?) USING TTL " + this.configuration.getOneHourTTL());
        this.insertSixHourData = this.session.prepare("INSERT INTO " + (Object)((Object)MetricsTable.SIX_HOUR) + "(schedule_id, time, " + "type, value) VALUES (?, ?, ?, ?) USING TTL " + this.configuration.getOneHourTTL());
        this.insertTwentyFourHourData = this.session.prepare("INSERT INTO " + (Object)((Object)MetricsTable.TWENTY_FOUR_HOUR) + "(schedule_id, " + "time, type, value) VALUES (?, ?, ?, ?) USING TTL " + this.configuration.getOneHourTTL());
        this.updateMetricsIndex = this.session.prepare("INSERT INTO " + (Object)((Object)MetricsTable.INDEX) + " (bucket, time, schedule_id) " + "VALUES (?, ?, ?)");
        this.findLatestRawMetric = this.session.prepare("SELECT schedule_id, time, value FROM " + (Object)((Object)MetricsTable.RAW) + " WHERE schedule_id = ? ORDER BY time DESC LIMIT 1");
        this.findRawMetrics = this.session.prepare("SELECT schedule_id, time, value FROM " + (Object)((Object)MetricsTable.RAW) + " WHERE schedule_id = ? AND time >= ? AND time <= ?");
        this.findOneHourMetricsByDateRange = this.session.prepare("SELECT schedule_id, time, type, value FROM " + (Object)((Object)MetricsTable.ONE_HOUR) + " WHERE schedule_id = ? AND time >= ? AND time < ?");
        this.findSixHourMetricsByDateRange = this.session.prepare("SELECT schedule_id, time, type, value FROM " + (Object)((Object)MetricsTable.SIX_HOUR) + " WHERE schedule_id = ? AND time >= ? AND time < ?");
        this.findTwentyFourHourMetricsByDateRange = this.session.prepare("SELECT schedule_id, time, type, value FROM " + (Object)((Object)MetricsTable.TWENTY_FOUR_HOUR) + " WHERE schedule_id = ? AND time >= ? AND time < ?");
        this.findIndexEntries = this.session.prepare("SELECT time, schedule_id FROM " + (Object)((Object)MetricsTable.INDEX) + " WHERE bucket = ? AND time = ?");
        this.findTimeSliceForIndex = this.session.prepare("SELECT time FROM " + (Object)((Object)MetricsTable.INDEX) + " WHERE bucket = ? AND time = ?");
        this.deleteIndexEntries = this.session.prepare("DELETE FROM " + (Object)((Object)MetricsTable.INDEX) + " WHERE bucket = ? AND time = ?");
        long endTime = System.currentTimeMillis();
        this.log.info((Object)("Finished initializing prepared statements in " + (endTime - startTime) + " ms"));
    }

    public ResultSetFuture insertRawData(MeasurementDataNumeric data) {
        BoundStatement statement = this.insertRawData.bind(new Object[]{data.getScheduleId(), new Date(data.getTimestamp()), data.getValue()});
        return this.session.executeAsync((Query)statement);
    }

    public List<MetricResultFuture<MeasurementDataNumeric>> insertRawMetricsAsync(Set<MeasurementDataNumeric> dataSet, int ttl) {
        try {
            ArrayList<MetricResultFuture<MeasurementDataNumeric>> resultFutures = new ArrayList<MetricResultFuture<MeasurementDataNumeric>>();
            String cql = "INSERT INTO raw_metrics (schedule_id, time, value) VALUES (?, ?, ?) USING TTL " + ttl;
            PreparedStatement statement = this.session.prepare(cql);
            for (MeasurementDataNumeric data : dataSet) {
                BoundStatement boundStatement = statement.bind(new Object[]{data.getScheduleId(), new Date(data.getTimestamp()), data.getValue()});
                resultFutures.add(new MetricResultFuture<MeasurementDataNumeric>(this.session.executeAsync((Query)boundStatement), data));
            }
            return resultFutures;
        }
        catch (NoHostAvailableException e) {
            throw new CQLException(e);
        }
    }

    public ResultSet insertOneHourData(int scheduleId, long timestamp, AggregateType type, double value) {
        BoundStatement statement = this.insertOneHourData.bind(new Object[]{scheduleId, new Date(timestamp), type.ordinal(), value});
        return this.session.execute((Query)statement);
    }

    public ResultSet insertSixHourData(int scheduleId, long timestamp, AggregateType type, double value) {
        BoundStatement statement = this.insertSixHourData.bind(new Object[]{scheduleId, new Date(timestamp), type.ordinal(), value});
        return this.session.execute((Query)statement);
    }

    public ResultSet insertTwentyFourHourData(int scheduleId, long timestamp, AggregateType type, double value) {
        BoundStatement statement = this.insertTwentyFourHourData.bind(new Object[]{scheduleId, new Date(timestamp), type.ordinal(), value});
        return this.session.execute((Query)statement);
    }

    public List<MetricResultFuture<AggregateNumericMetric>> insertAggregatesAsync(MetricsTable table, List<AggregateNumericMetric> metrics, int ttl) {
        ArrayList<MetricResultFuture<AggregateNumericMetric>> updates = new ArrayList<MetricResultFuture<AggregateNumericMetric>>();
        if (metrics.isEmpty()) {
            return updates;
        }
        try {
            Insert statement = null;
            for (AggregateNumericMetric metric : metrics) {
                statement = QueryBuilder.insertInto((String)table.getTableName()).value("schedule_id", (Object)metric.getScheduleId()).value("time", (Object)new Date(metric.getTimestamp())).value("type", (Object)AggregateType.MIN.ordinal()).value("value", (Object)metric.getMin());
                updates.add(new MetricResultFuture<AggregateNumericMetric>(this.session.executeAsync((Query)statement), metric));
                statement = QueryBuilder.insertInto((String)table.getTableName()).value("schedule_id", (Object)metric.getScheduleId()).value("time", (Object)new Date(metric.getTimestamp())).value("type", (Object)AggregateType.MAX.ordinal()).value("value", (Object)metric.getMax());
                updates.add(new MetricResultFuture<AggregateNumericMetric>(this.session.executeAsync((Query)statement), metric));
                statement = QueryBuilder.insertInto((String)table.getTableName()).value("schedule_id", (Object)metric.getScheduleId()).value("time", (Object)new Date(metric.getTimestamp())).value("type", (Object)AggregateType.AVG.ordinal()).value("value", (Object)metric.getAvg());
                updates.add(new MetricResultFuture<AggregateNumericMetric>(this.session.executeAsync((Query)statement), metric));
            }
            return updates;
        }
        catch (Exception e) {
            throw new CQLException(e);
        }
    }

    public Iterable<RawNumericMetric> findRawMetrics(int scheduleId, long startTime, long endTime) {
        try {
            BoundStatement boundStatement = this.rawMetricsQuery.bind(new Object[]{scheduleId, new Date(startTime), new Date(endTime)});
            return new SimplePagedResult<RawNumericMetric>((Query)boundStatement, new RawNumericMetricMapper(false), this.session);
        }
        catch (NoHostAvailableException e) {
            throw new CQLException(e);
        }
    }

    public ResultSetFuture findRawMetricsAsync(int scheduleId, long startTime, long endTime) {
        BoundStatement boundStatement = this.rawMetricsQuery.bind(new Object[]{scheduleId, new Date(startTime), new Date(endTime)});
        return this.session.executeAsync((Query)boundStatement);
    }

    public RawNumericMetric findLatestRawMetric(int scheduleId) {
        RawNumericMetricMapper mapper = new RawNumericMetricMapper(false);
        BoundStatement boundStatement = this.findLatestRawMetric.bind(new Object[]{scheduleId});
        ResultSet resultSet = this.session.execute((Query)boundStatement);
        return mapper.mapOne(resultSet);
    }

    public Iterable<RawNumericMetric> findRawMetrics(List<Integer> scheduleIds, long startTime, long endTime) {
        return new ListPagedResult<RawNumericMetric>(this.findRawMetrics, scheduleIds, startTime, endTime, new RawNumericMetricMapper(), this.session);
    }

    public Iterable<AggregateNumericMetric> findOneHourMetrics(int scheduleId, long startTime, long endTime) {
        BoundStatement statement = this.findOneHourMetricsByDateRange.bind(new Object[]{scheduleId, new Date(startTime), new Date(endTime)});
        return new SimplePagedResult<AggregateNumericMetric>((Query)statement, new AggregateNumericMetricMapper(), this.session);
    }

    public Iterable<AggregateNumericMetric> findSixHourMetrics(int scheduleId, long startTime, long endTime) {
        BoundStatement statement = this.findSixHourMetricsByDateRange.bind(new Object[]{scheduleId, new Date(startTime), new Date(endTime)});
        return new SimplePagedResult<AggregateNumericMetric>((Query)statement, new AggregateNumericMetricMapper(), this.session);
    }

    public Iterable<AggregateNumericMetric> findTwentyFourHourMetrics(int scheduleId, long startTime, long endTime) {
        BoundStatement statement = this.findTwentyFourHourMetricsByDateRange.bind(new Object[]{scheduleId, new Date(startTime), new Date(endTime)});
        return new SimplePagedResult<AggregateNumericMetric>((Query)statement, new AggregateNumericMetricMapper(), this.session);
    }

    public Iterable<AggregateSimpleNumericMetric> findAggregatedSimpleOneHourMetric(int scheduleId, long startTime, long endTime) {
        BoundStatement statement = this.findOneHourMetricsByDateRange.bind(new Object[]{scheduleId, new Date(startTime), new Date(endTime)});
        return new SimplePagedResult<AggregateSimpleNumericMetric>((Query)statement, new AggregateSimpleNumericMetricMapper(), this.session);
    }

    public Iterable<AggregateNumericMetric> findOneHourMetrics(List<Integer> scheduleIds, long startTime, long endTime) {
        return new ListPagedResult<AggregateNumericMetric>(this.findOneHourMetricsByDateRange, scheduleIds, startTime, endTime, new AggregateNumericMetricMapper(), this.session);
    }

    public Iterable<AggregateNumericMetric> findSixHourMetrics(List<Integer> scheduleIds, long startTime, long endTime) {
        return new ListPagedResult<AggregateNumericMetric>(this.findSixHourMetricsByDateRange, scheduleIds, startTime, endTime, new AggregateNumericMetricMapper(), this.session);
    }

    public Iterable<AggregateNumericMetric> findTwentyFourHourMetrics(List<Integer> scheduleIds, long startTime, long endTime) {
        return new ListPagedResult<AggregateNumericMetric>(this.findTwentyFourHourMetricsByDateRange, scheduleIds, startTime, endTime, new AggregateNumericMetricMapper(), this.session);
    }

    public Iterable<MetricsIndexEntry> findMetricsIndexEntries(MetricsTable table, long timestamp) {
        BoundStatement statement = this.findIndexEntries.bind(new Object[]{table.toString(), new Date(timestamp)});
        return new SimplePagedResult<MetricsIndexEntry>((Query)statement, new MetricsIndexEntryMapper(table), this.session);
    }

    public ResultSet setFindTimeSliceForIndex(MetricsTable table, long timestamp) {
        BoundStatement statement = this.findTimeSliceForIndex.bind(new Object[]{table.toString(), new Date(timestamp)});
        return this.session.execute((Query)statement);
    }

    public void updateMetricsIndex(MetricsTable table, Map<Integer, Long> updates) {
        for (Integer scheduleId : updates.keySet()) {
            BoundStatement statement = this.updateMetricsIndex.bind(new Object[]{table.getTableName(), new Date(updates.get(scheduleId)), scheduleId});
            this.session.execute((Query)statement);
        }
    }

    public ResultSetFuture updateMetricsIndex(MetricsTable table, int scheduleId, long timestamp) {
        BoundStatement statement = this.updateMetricsIndex.bind(new Object[]{table.getTableName(), new Date(timestamp), scheduleId});
        return this.session.executeAsync((Query)statement);
    }

    public void deleteMetricsIndexEntries(MetricsTable table, long timestamp) {
        BoundStatement statement = this.deleteIndexEntries.bind(new Object[]{table.getTableName(), new Date(timestamp)});
        this.session.execute((Query)statement);
    }
}

