/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics;

import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Duration;
import org.joda.time.Minutes;
import org.joda.time.Period;
import org.joda.time.chrono.GregorianChronology;
import org.joda.time.field.DividedDateTimeField;
import org.rhq.server.metrics.MetricsConfiguration;

public class DateTimeService {
    private DateTimeComparator dateTimeComparator = DateTimeComparator.getInstance();
    private MetricsConfiguration configuration;

    public void setConfiguration(MetricsConfiguration configuration) {
        this.configuration = configuration;
    }

    public DateTime getTimeSlice(long timestamp, Minutes interval) {
        return this.getTimeSlice(new DateTime(timestamp), interval);
    }

    public DateTime getTimeSlice(DateTime dateTime, Minutes interval) {
        GregorianChronology chronology = GregorianChronology.getInstance();
        DateTimeField hourField = chronology.hourOfDay();
        DividedDateTimeField dividedField = new DividedDateTimeField(hourField, DateTimeFieldType.clockhourOfDay(), interval.toStandardHours().getHours());
        long timestamp = dividedField.roundFloor(dateTime.getMillis());
        return new DateTime(timestamp);
    }

    public DateTime getTimeSlice(long timestamp, Duration duration) {
        return this.getTimeSlice(new DateTime(timestamp), duration);
    }

    public DateTime getTimeSlice(DateTime dt, Duration duration) {
        Period p = duration.toPeriod();
        if (p.getYears() != 0) {
            return dt.yearOfEra().roundFloorCopy().minusYears(dt.getYearOfEra() % p.getYears());
        }
        if (p.getMonths() != 0) {
            return dt.monthOfYear().roundFloorCopy().minusMonths((dt.getMonthOfYear() - 1) % p.getMonths());
        }
        if (p.getWeeks() != 0) {
            return dt.weekOfWeekyear().roundFloorCopy().minusWeeks((dt.getWeekOfWeekyear() - 1) % p.getWeeks());
        }
        if (p.getDays() != 0) {
            return dt.dayOfMonth().roundFloorCopy().minusDays((dt.getDayOfMonth() - 1) % p.getDays());
        }
        if (p.getHours() != 0) {
            return dt.hourOfDay().roundFloorCopy().minusHours(dt.getHourOfDay() % p.getHours());
        }
        if (p.getMinutes() != 0) {
            return dt.minuteOfHour().roundFloorCopy().minusMinutes(dt.getMinuteOfHour() % p.getMinutes());
        }
        if (p.getSeconds() != 0) {
            return dt.secondOfMinute().roundFloorCopy().minusSeconds(dt.getSecondOfMinute() % p.getSeconds());
        }
        return dt.millisOfSecond().roundCeilingCopy().minusMillis(dt.getMillisOfSecond() % p.getMillis());
    }

    public boolean isInRawDataRange(DateTime dateTime) {
        return this.dateTimeComparator.compare((Object)DateTime.now().minus(this.configuration.getRawRetention()), (Object)dateTime) < 0;
    }

    public boolean isIn1HourDataRange(DateTime dateTime) {
        return this.dateTimeComparator.compare((Object)DateTime.now().minus(this.configuration.getOneHourRetention()), (Object)dateTime) < 0;
    }

    public boolean isIn6HourDataRnage(DateTime dateTime) {
        return this.dateTimeComparator.compare((Object)DateTime.now().minus(this.configuration.getSixHourRetention()), (Object)dateTime) < 0;
    }

    public boolean isIn24HourDataRnage(DateTime dateTime) {
        return this.dateTimeComparator.compare((Object)DateTime.now().minus(this.configuration.getTwentyFourHourRetention()), (Object)dateTime) < 0;
    }

    public DateTime hour0() {
        DateTime rightNow = DateTime.now();
        return rightNow.hourOfDay().roundFloorCopy().minusHours(rightNow.hourOfDay().roundFloorCopy().hourOfDay().get());
    }
}

