/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.jboss.software;

import churchillobjects.rss4j.RssChannel;
import churchillobjects.rss4j.RssChannelItem;
import churchillobjects.rss4j.RssDocument;
import churchillobjects.rss4j.RssDublinCore;
import churchillobjects.rss4j.RssJbnDependency;
import churchillobjects.rss4j.RssJbnPatch;
import java.io.ByteArrayInputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetails;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetailsKey;
import org.rhq.enterprise.server.plugin.pc.content.PackageSyncReport;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RssFeedParser {
    public static final String JBOSS_AS4_PLUGIN_NAME = "JBossAS";
    public static final String JBOSS_AS5_PLUGIN_NAME = "JBossAS5";
    public static final String ARCHITECTURE = "noarch";
    public static final String RESOURCE_TYPE_JBOSS_AS = "JBossAS Server";
    public static final String PACKAGE_TYPE_CUMULATIVE_PATCH = "cumulativePatch";
    public static final String RSS_SOFTWARE_TYPE_BUGFIX = "BUGFIX";
    public static final String RSS_SOFTWARE_TYPE_SECURITY = "SECURITY";
    public static final String RSS_SOFTWARE_TYPE_ENHANCEMENT = "ENHANCEMENT";
    public static final String RSS_SOFTWARE_TYPE_DISTRIBUTION = "DISTRIBUTION";
    public static final String DIST_STATUS_AVAILABLE = "AVAILABLE";
    public static final String DIST_STATUS_OBSOLETE = "OBSOLETE";
    public static final String DIST_STATUS_REMOVED = "REMOVED";
    private final Log log = LogFactory.getLog(this.getClass());

    public void parseResults(RssDocument feed, PackageSyncReport report, Collection<ContentProviderPackageDetails> existingPackages) throws ParserConfigurationException {
        Map<PackageDetailsKey, ContentProviderPackageDetails> existingPackageMap = this.unpack(existingPackages);
        Enumeration repos = feed.channels();
        DocumentBuilderFactory xmlFact = DocumentBuilderFactory.newInstance();
        xmlFact.setNamespaceAware(false);
        DocumentBuilder builder = xmlFact.newDocumentBuilder();
        XPath xpath = XPathFactory.newInstance().newXPath();
        String instructionExpression = "/automatedInstallation/instructions/instructionSet";
        while (repos.hasMoreElements()) {
            RssChannel repo = (RssChannel)repos.nextElement();
            Enumeration repotems = repo.items();
            while (repotems.hasMoreElements()) {
                RssChannelItem item = (RssChannelItem)repotems.nextElement();
                RssJbnPatch patch = item.getJbnPatch();
                RssDublinCore dublinCore = item.getDublinCore();
                if (dublinCore == null || patch == null) {
                    this.log.debug((Object)("Feed entry parsed data returned null. Skipping entry.  Patch: " + patch + ", Dublin Core: " + dublinCore));
                    continue;
                }
                Collection products = patch.getProducts();
                if (products == null || products.size() == 0) continue;
                String packageName = dublinCore.getSubject();
                String softwareType = patch.getType();
                String distributionStatus = patch.getDistributionStatus();
                String jiraId = patch.getJira();
                String downloadUrl = patch.getDownloadUrl();
                String instructionCompatibilityVersion = patch.getInstructionCompatibilityVersion();
                if (distributionStatus.equals(DIST_STATUS_REMOVED)) continue;
                Configuration extraProperties = new Configuration();
                extraProperties.put((Property)new PropertySimple("jiraId", (Object)jiraId));
                extraProperties.put((Property)new PropertySimple("distributionStatus", (Object)distributionStatus));
                extraProperties.put((Property)new PropertySimple("downloadUrl", (Object)downloadUrl));
                extraProperties.put((Property)new PropertySimple("instructionCompatibilityVersion", (Object)instructionCompatibilityVersion));
                if (!softwareType.equals(RSS_SOFTWARE_TYPE_BUGFIX) || instructionCompatibilityVersion == null) continue;
                String version = this.parseCumulativePatchVersion(packageName);
                if (version == null) {
                    this.log.error((Object)("Could not parse version for package: " + packageName));
                    continue;
                }
                ContentProviderPackageDetailsKey key = new ContentProviderPackageDetailsKey(packageName, version, PACKAGE_TYPE_CUMULATIVE_PATCH, ARCHITECTURE, RESOURCE_TYPE_JBOSS_AS, this.getPluginName(version));
                if (existingPackageMap.get(key) != null) {
                    existingPackageMap.remove(key);
                    continue;
                }
                ContentProviderPackageDetails packageDetails = new ContentProviderPackageDetails(key);
                packageDetails.setClassification(softwareType);
                packageDetails.setDisplayName(packageName);
                packageDetails.setFileCreatedDate(Long.valueOf(dublinCore.getDate().getTime()));
                packageDetails.setFileName(patch.getFileName());
                packageDetails.setFileSize(Long.valueOf(Long.parseLong(patch.getFileSize())));
                packageDetails.setLicenseName(patch.getLicenseName());
                packageDetails.setLicenseVersion(patch.getLicenseVersion());
                packageDetails.setLocation(patch.getAutomatedDownloadUrl());
                packageDetails.setMD5(patch.getMd5());
                packageDetails.setSHA256(patch.getSha256());
                packageDetails.setShortDescription(patch.getShortDescription());
                packageDetails.setLongDescription(patch.getLongDescription());
                if (patch.getAutomatedInstallation() != null) {
                    String instructions = patch.getAutomatedInstallation();
                    try {
                        Document document = builder.parse(new ByteArrayInputStream(instructions.getBytes()));
                        String choppedInstructions = xpath.evaluate(instructionExpression, document);
                        packageDetails.setMetadata(choppedInstructions.trim().getBytes());
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Could not parse or set automated installation instructions for package: " + packageName));
                        continue;
                    }
                }
                packageDetails.setExtraProperties(extraProperties);
                for (Object productObj : products) {
                    RssJbnDependency product = (RssJbnDependency)productObj;
                    String productVersion = product.getJonResourceVersion();
                    if (product.getProductVersion().equals("4.0.4")) {
                        productVersion = "4.0.4.GA";
                    }
                    if (null == productVersion || "".equals(productVersion.trim())) {
                        productVersion = product.getProductVersion();
                    }
                    packageDetails.addResourceVersion(productVersion);
                }
                report.addNewPackage(packageDetails);
            }
        }
        for (ContentProviderPackageDetails pkg : existingPackageMap.values()) {
            report.addDeletePackage(pkg);
        }
    }

    private Map<PackageDetailsKey, ContentProviderPackageDetails> unpack(Collection<ContentProviderPackageDetails> existingPackages) {
        HashMap<PackageDetailsKey, ContentProviderPackageDetails> map = new HashMap<PackageDetailsKey, ContentProviderPackageDetails>();
        if (existingPackages == null) {
            return map;
        }
        for (ContentProviderPackageDetails pkg : existingPackages) {
            map.put(pkg.getKey(), pkg);
        }
        return map;
    }

    private String parseCumulativePatchVersion(String title) {
        if (title.startsWith("JBoss AS ")) {
            return title.substring(9);
        }
        if (title.startsWith("JBoss EAP ")) {
            return title.substring(10);
        }
        if (title.startsWith("JBoss SOA ")) {
            return title.substring(10);
        }
        return null;
    }

    private String getPluginName(String jbossVersion) {
        if (jbossVersion.trim().startsWith("5")) {
            return JBOSS_AS5_PLUGIN_NAME;
        }
        return JBOSS_AS4_PLUGIN_NAME;
    }
}

