/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.yum;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.rhq.enterprise.server.plugins.yum.RepoReader;

public class HttpReader
implements RepoReader {
    private final String baseurl;
    HttpURLConnection connection;

    public HttpReader(String baseurl) {
        this.baseurl = baseurl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws Exception {
        URL url = new URL(this.baseurl);
        this.connection = (HttpURLConnection)url.openConnection();
        this.connection.setRequestMethod("GET");
        try {
            if (this.connection.getHeaderField(0) == null) {
                throw new IOException("Cannot validate connection - check URL");
            }
        }
        finally {
            this.connection.disconnect();
        }
    }

    public InputStream openStream(String suffix) throws IOException {
        URL url = new URL(this.baseurl + "/" + suffix);
        this.connection = (HttpURLConnection)url.openConnection();
        this.connection.setRequestMethod("GET");
        InputStream in = this.connection.getInputStream();
        if (suffix.endsWith(".gz")) {
            return new GZIPInputStream(in);
        }
        return in;
    }

    public String toString() {
        return this.baseurl;
    }
}

