/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.yum;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.util.Base64;
import org.rhq.enterprise.server.plugins.yum.RepoProvider;
import org.rhq.enterprise.server.plugins.yum.UrlReader;

public class HttpReader
extends UrlReader {
    private static final Log LOG = LogFactory.getLog(RepoProvider.class);
    private final String username;
    private final String password;

    public HttpReader(URL baseUrl, String username, String password) {
        super(baseUrl);
        this.username = username;
        this.password = password;
    }

    @Override
    protected InputStream doOpen(URL url) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("open " + url));
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(true);
        if (this.username != null) {
            String userInfo = this.username;
            if (this.password != null) {
                userInfo = userInfo + ":" + this.password;
            }
            String basicAuth = "Basic " + Base64.encode((byte[])userInfo.getBytes("ISO-8859-1"));
            connection.setRequestProperty("Authorization", basicAuth);
        }
        return connection.getInputStream();
    }
}

