/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.yum;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.rhq.enterprise.server.plugins.yum.DiskReader;
import org.rhq.enterprise.server.plugins.yum.HttpReader;
import org.rhq.enterprise.server.plugins.yum.RepoReader;

public class UrlReader
implements RepoReader {
    protected final URL baseUrl;

    public static UrlReader fromUri(URI uri, String username, String password) throws MalformedURLException {
        if (uri.getScheme() == null) {
            try {
                return new DiskReader(new URI("file", uri.getSchemeSpecificPart(), uri.getFragment()).toURL());
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("URI syntax exception while adding the 'file' scheme to a path. This should not have happened.", e);
            }
        }
        if (uri.getScheme().equals("file")) {
            return new DiskReader(uri.toURL());
        }
        if (uri.getScheme().startsWith("http")) {
            return new HttpReader(uri.toURL(), username, password);
        }
        return new UrlReader(uri.toURL());
    }

    protected UrlReader(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public void validate() throws IOException, URISyntaxException {
        InputStream content = this.doOpen(this.baseUrl);
        content.close();
    }

    @Override
    public final InputStream openStream(String path) throws IOException {
        URL url = this.extendBaseUrl(path);
        InputStream ret = this.doOpen(url);
        if (path.endsWith(".gz")) {
            ret = new GZIPInputStream(ret);
        }
        return ret;
    }

    protected InputStream doOpen(URL url) throws IOException {
        return url.openStream();
    }

    public URL getBaseURL() {
        return this.baseUrl;
    }

    protected URL extendBaseUrl(String suffix) throws MalformedURLException {
        if (suffix != null) {
            suffix = suffix.trim();
        }
        return suffix == null ? this.baseUrl : new URL(this.baseUrl + "/" + suffix);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.baseUrl;
    }
}

