/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.snmptrapd;

import java.io.IOException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.event.EventContext;
import org.rhq.core.pluginapi.event.EventPoller;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.plugins.snmptrapd.SnmpTrapEventPoller;
import org.snmp4j.CommandResponder;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.log.Log4jLogFactory;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SnmpTrapdComponent
implements ResourceComponent<ResourceComponent<?>>,
MeasurementFacet {
    private final Log log = org.apache.commons.logging.LogFactory.getLog(SnmpTrapdComponent.class);
    public static final String TRAP_TYPE = "SnmpTrap";
    private EventContext eventContext;
    private Snmp snmp;
    private SnmpTrapEventPoller snmpTrapEventPoller;
    public static int trapCount = 0;

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public void start(ResourceContext context) throws InvalidPluginConfigurationException, Exception {
        Configuration conf = context.getPluginConfiguration();
        PropertySimple ps = conf.getSimple("port");
        Integer port = ps.getIntegerValue();
        ps = conf.getSimple("community");
        String community = ps.getStringValue();
        ps = conf.getSimple("eventSeverityOid");
        String severityOid = ps.getStringValue();
        ps = conf.getSimple("pollInterval");
        int pollInterval = ps.getIntegerValue();
        this.eventContext = context.getEventContext();
        try {
            UdpAddress targetAddress = new UdpAddress(port.intValue());
            this.snmp = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
            this.snmpTrapEventPoller = new SnmpTrapEventPoller(severityOid);
            this.eventContext.registerEventPoller((EventPoller)this.snmpTrapEventPoller, pollInterval);
            if (!this.snmp.addNotificationListener((Address)targetAddress, (CommandResponder)this.snmpTrapEventPoller)) {
                throw new IOException("cannot attach to " + targetAddress);
            }
        }
        catch (IOException e) {
            this.log.error((Object)("Cannot start snmp engine. Cause: " + ThrowableUtil.getAllMessages((Throwable)e)));
        }
    }

    public void stop() {
        if (this.snmp != null) {
            this.snmp.removeCommandResponder((CommandResponder)this.snmpTrapEventPoller);
            try {
                this.snmp.close();
            }
            catch (IOException e) {
                this.log.error((Object)("Cannot stop snmp engine. Cause: " + ThrowableUtil.getAllMessages((Throwable)e)));
            }
            this.snmp = null;
        }
        this.eventContext.unregisterEventPoller(TRAP_TYPE);
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        for (MeasurementScheduleRequest req : metrics) {
            if (!req.getName().equals("trap_count")) continue;
            MeasurementDataNumeric res = new MeasurementDataNumeric(req, Double.valueOf(trapCount));
            report.addData(res);
        }
    }

    static {
        LogFactory.setLogFactory((LogFactory)new Log4jLogFactory());
    }
}

