/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.sonarqube;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SonarQubeJSONUtility {
    private static final Log LOG = LogFactory.getLog(SonarQubeJSONUtility.class);

    public static String getVersion(String path) throws JSONException {
        return SonarQubeJSONUtility.getData(path, "server").getString("version");
    }

    public static String getStatus(String path) throws JSONException {
        return SonarQubeJSONUtility.getData(path, "server").getString("status");
    }

    public static JSONObject getData(String path, String query) {
        try {
            return new JSONObject(SonarQubeJSONUtility.call(path, query));
        }
        catch (JSONException e) {
            LOG.warn((Object)e);
            return null;
        }
    }

    public static JSONArray getDatas(String path, String query) {
        try {
            return new JSONArray(SonarQubeJSONUtility.call(path, query));
        }
        catch (JSONException e) {
            LOG.warn((Object)e);
            return null;
        }
    }

    private static String call(String path, String query) {
        URL url = null;
        try {
            String line;
            path = path.replaceAll(" ", "%20");
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            url = new URL(path + "api/" + query);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            InputStream is = connection.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            StringBuilder builder = new StringBuilder(2048);
            while ((line = br.readLine()) != null) {
                builder.append(line);
            }
            return builder.toString();
        }
        catch (MalformedURLException e) {
            LOG.warn((Object)e);
        }
        catch (IOException e) {
            LOG.warn((Object)e);
        }
        return null;
    }
}

