/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.sonarqube;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.sonarqube.SonarQubeJSONUtility;
import org.rhq.plugins.sonarqube.SonarQubeServerComponent;

public class SonarQubeProjectComponent
implements ResourceComponent<SonarQubeServerComponent>,
MeasurementFacet {
    private static final Log LOG = LogFactory.getLog(SonarQubeProjectComponent.class);
    private ResourceContext<SonarQubeServerComponent> resourceContext;

    public void start(ResourceContext<SonarQubeServerComponent> hudsonServerComponentResourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = hudsonServerComponentResourceContext;
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        String key = this.resourceContext.getResourceKey();
        String serverPath = ((SonarQubeServerComponent)this.resourceContext.getParentResourceComponent()).getPath();
        JSONArray projects = SonarQubeJSONUtility.getDatas(serverPath, "resources?resource=" + key);
        if (projects != null && projects.length() == 1) {
            return AvailabilityType.UP;
        }
        return AvailabilityType.DOWN;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        try {
            String key = this.resourceContext.getResourceKey();
            String serverPath = ((SonarQubeServerComponent)this.resourceContext.getParentResourceComponent()).getPath();
            JSONArray projects = SonarQubeJSONUtility.getDatas(serverPath, "resources?resource=" + key);
            if (projects != null && projects.length() == 1) {
                String date = projects.getJSONObject(0).getString("date");
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss Z");
                Date lastAnalysisTime = df.parse(date.replaceAll("(?=.{5}$)", " "));
                long currentTime = System.currentTimeMillis();
                for (MeasurementScheduleRequest request : metrics) {
                    try {
                        if (request.getName().equals("lastAnalysisTime") && lastAnalysisTime != null) {
                            report.addData(new MeasurementDataTrait(request, lastAnalysisTime.toString()));
                            continue;
                        }
                        if (!request.getName().equals("lastAnalysisElapsedTime") || lastAnalysisTime == null) continue;
                        report.addData(new MeasurementDataNumeric(request, Double.valueOf((double)(currentTime - lastAnalysisTime.getTime()) / 1000.0)));
                    }
                    catch (Exception e) {
                        LOG.warn((Object)e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e);
        }
    }
}

