/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.gui.webdav;

import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.server.util.LookupUtil;

public class Authenticator {
    private static final Log LOG = LogFactory.getLog(Authenticator.class);
    private Subject subject = null;

    public Authenticator(Subject subject) {
        this.subject = subject;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Subject getOverlord() {
        return LookupUtil.getSubjectManager().getOverlord();
    }

    public Object authenticate(String username, String password) {
        try {
            this.subject = LookupUtil.getSubjectManager().login(username, password);
            LOG.debug((Object)("User [" + username + "] logged into the webdav server"));
        }
        catch (LoginException e) {
            LOG.warn((Object)("User [" + username + "] failed to log into the webdav server"));
            this.subject = null;
        }
        return this.subject;
    }

    public String getRealm() {
        return "Jopr Management Environment";
    }
}

