/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.gui.webdav;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.gui.webdav.BasicResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GetableBasicResource
extends BasicResource
implements GetableResource {
    public GetableBasicResource(Subject subject, Resource managedResource) {
        super(subject, managedResource);
    }

    public String getContentType(String accepts) {
        return "text/xml";
    }

    public Long getContentLength() {
        return this.loadContent().length();
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String str) throws IOException, NotAuthorizedException {
        byte[] bytes = this.loadContent().getBytes();
        long start = range != null ? range.getStart() : 0L;
        long length = range != null ? range.getFinish() - start + 1L : (long)bytes.length;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        StreamUtil.copy((InputStream)in, (OutputStream)out, (long)start, (long)length);
    }

    public Long getMaxAgeSeconds(Auth auth) {
        return 0L;
    }

    protected abstract String loadContent();
}

